define(['service', 'jquery', 'language', 'config/config'], function (service, $, language, config) {
    var trafficData = {};
    var smsUsed = 0;
    var hasSubUnread = false;
    var smsUsedLast = 0;

    /**
     * 获取当前网络状态
     *
     * @method getNetworkType
     */
    function getNetworkType(networkType, simStatus) {
        if(simStatus == "modem_sim_undetected") {
            return $.i18n.prop("sim_undetected_info");
        }

        var networkTypeTmp = networkType.toLowerCase();
        if (networkTypeTmp == '' || networkTypeTmp == 'limited service') {
            networkTypeTmp = 'limited_service';
        }
        if(networkTypeTmp == 'no service') {
            networkTypeTmp = 'no_service';
        }
        if (networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service') {
            return $.i18n.prop("network_type_" + networkTypeTmp);
        } else {
            return networkType;
        }
    }

    function getNetWorkProvider(spn_b1_flag,spn_name_data,spn_b2_flag,network_provider,roamStatus){
        if(spn_name_data==""){
            return network_provider;
        }else{
            spn_name_data=decodeMessage(spn_name_data);

            if(spn_b1_flag=="1" && spn_b2_flag=="1"){
                if(roamStatus){//漫游
                    return network_provider;
                }else{//不漫游
                    return network_provider+"  "+spn_name_data;
                }
            }else if(spn_b1_flag=="1"){
                if(roamStatus){//漫游
                    return network_provider+"  "+spn_name_data;
                }else{//不漫游
                    return network_provider+"  "+spn_name_data;
                }
            }else if(spn_b2_flag=="1"){
                if(roamStatus){//漫游
                    return network_provider;
                }else{//不漫游
                    return spn_name_data;
                }
            }else if(spn_b1_flag=="0" && spn_b2_flag=="0"){
                if(roamStatus){//漫游
                    return network_provider+"  "+spn_name_data;
                }else{//不漫游
                    return spn_name_data;
                }
            }
            return "";
        }
    }

    function refreshHome() {
        var info = service.getStatusInfo();
        var roamStatus=info.roamingStatus?true:false;
        homeUtil.setData('networkOperator', getNetWorkProvider(info.spn_b1_flag,info.spn_name_data,info.spn_b2_flag,info.networkOperator,roamStatus));
        homeUtil.setData('network_type', getNetworkType(info.networkType, info.simStatus));
        homeUtil.setData('roaming', info.roamingStatus ? $.i18n.prop('roaming') : '');
        var signalCSS = homeUtil.getSignalCssClass(info.signalImg, info.networkType, info.simStatus);
        $("#signal_div").removeAttr('class').addClass(signalCSS);
        if (config.HAS_BATTERY) {
            homeUtil.showElement('battery_div');
            var batteryPers = homeUtil.convertBatteryPers(info.battery_value, info.batteryStatus);
            var $batteryDiv = $("img", "#battery_div");
            if ($batteryDiv.attr('src') != batteryPers) {
                $batteryDiv.attr('src', batteryPers);
            }
        } else {
            homeUtil.hideElement('battery_div');
        }

        homeUtil.setData('speed_up', transUnit(info.data_counter.uploadRate || 0, true));
        homeUtil.setData('speed_down', transUnit(info.data_counter.downloadRate || 0, true));
        if (info.limitVolumeEnable) {
            homeUtil.showElement('traffic_div');
            homeUtil.showElement(info.limitVolumeType == '1' ? 'traffic_data_div' : 'traffic_time_div');
            var monthlyTraffic = parseInt(info.data_counter.monthlySent, 10) + parseInt(info.data_counter.monthlyReceived, 10);
            homeUtil.setData('data_used', $.i18n.prop('data_used', transUnit(monthlyTraffic, false)));
            homeUtil.setData('data_total', $.i18n.prop('data_total', transUnit(trafficData.limitDataMonth, false)));
            homeUtil.setData('time_used', $.i18n.prop('time_used', transSecond2Time(info.data_counter.monthlyConnectedTime)));
            homeUtil.setData('time_total', $.i18n.prop('time_total', trafficData.limitTimeMonth / 60 / 60));
        } else {
            homeUtil.hideElement('traffic_div');
        }

        homeUtil.setData('wireless_size', $.i18n.prop('n_wireless_devices', info.attachedDevices.length));

        if (hasSubUnread) {
            homeUtil.setData('sms_used', $.i18n.prop('sms_total_count', parseInt(smsUsedLast + info.smsUnreadCount, 10)));
        } else {
            smsUsedLast = smsUsed - info.smsUnreadCount;
            homeUtil.setData('sms_used', $.i18n.prop('sms_total_count', smsUsed));
            hasSubUnread = true;
        }
//        homeUtil.setData('sms_unread', $.i18n.prop('sms_unread_count', info.smsUnreadCount));

        if(info.smsUnreadCount == 0) {
            homeUtil.getEle('smsNewCount').hide();
        } else {
            homeUtil.getEle('smsNewCount').text(info.smsUnreadCount).show();
        }
        if(info.new_version_state){
            $('#newVersionTips').show();
        }else{
            $('#newVersionTips').hide();
        }
    }

    var homeUtil = {
        cacheEle: {},
        getEle: function (id) {
            if (this.cacheEle.hasOwnProperty('id')) {
                return this.cacheEle[id];
            } else {
                this.cacheEle[id] = $("#" + id);
                return this.cacheEle[id];
            }
        },
        setData: function (id, data) {
            return this.getEle(id).html(data);
        },
        showElement: function (id) {
            return this.getEle(id).show();
        },
        hideElement: function (id) {
            return this.getEle(id).hide();
        },

        convertBatteryPers: function(battery_val, status) {
            var src = null;
            var val = parseInt(battery_val);
            if ("0" == status) {
                if (val >= 0 && val <= 5) {
                    src = "img/battery_out.png";
                } else if (val > 5 && val <= 25) {
                    src = "img/battery_one.png";
                } else if (val > 25 && val <= 50) {
                    src = "img/battery_two.png";
                } else if (val > 50 && val < 100) {
                    src = "img/battery_three.png";
                } else {
                    src = "img/battery_full.png";
                }
            }else if("2" == status){
                src = "img/battery_full.png";
            } else {
                src = "img/battery_charging.gif";
            }
            return src;
        },
        getSignalCssClass: function (siganl, networkType, simStatus) {
            networkType = networkType.toLowerCase();
            simStatus = simStatus ? simStatus.toLowerCase() : '';
            if (networkType == '' || networkType == 'limited_service' || networkType == 'no_service' || networkType == 'limited service' || networkType == 'no service'
                || simStatus != 'modem_init_complete') {
                siganl = '_none';
            }
            return "signal" + siganl;
        }
    };

    /**
     * 显示OTA升级结果
     * @method showOtaResult
     */
    function showOtaResult(otaResult) {
        var msg = otaResult ? "ota_update_success" : "ota_update_failed";
        showAlert(msg, function () {
            if (config.UPGRADE_TYPE == "OTA") {
                service.clearUpdateResult({}, $.noop());
            }
        });

    }

     function checkOtaResult() {
        if (config.UPGRADE_TYPE == "FOTA" || config.UPGRADE_TYPE == "OTA") {
            var info = service.getStatusInfo();
            if (info.isLoggedIn) {
                service.getUpgradeResult({}, function (data) {
                    if (data.upgrade_result == "success") {
                        showOtaResult(true);
                    } else if (data.upgrade_result == "fail") {
                        showOtaResult(false);
                    } else {
                        window.setTimeout(checkOtaResult, 1000);
                    }
                }, function () {
                    window.setTimeout(checkOtaResult, 1000);
                });
            } else {
                window.setTimeout(checkOtaResult, 1000);
            }
        }
    }

    function redirectNoConPath(){
        var curentHref = window.location.href;
        if(config.SIM_CARD_STATUS == "modem_imsi_waitnck") {
            window.location.hash = "#/network_lock";
        }else {
            window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + "#/nosimcard";
        }
    }
    function init() {
        var info = service.getStatusInfo();
        var curentHref = window.location.href;
        if(window.location.href.indexOf("?no_connect") != -1){
            if(info.opms_wan_mode == 'PPPOE' || (info.opms_wan_mode == 'AUTO' && info.opms_wan_auto_mode == 'AUTO_PPPOE')){
                showAlert("pppoe_error_jump",function(){
                    redirectNoConPath()
                });
            }else {
                if(info.simStatus == "modem_init_complete"){
                    if(info.connectStatus == "ppp_disconnected"){
                        if(info.ppp_dial_conn_fail_counter == '0' || info.ppp_dial_conn_fail_counter == ''){
                            showAlert("no_connect_jump",function(){
                                redirectNoConPath()
                            });
                        } else {
                            showAlert("connect_failed_jump",function(){
                                redirectNoConPath()
                            });
                        }

                    }
                } else if(info.simStatus == "modem_sim_undetected"){
                    showAlert("no_simcard_jump",function(){
                        redirectNoConPath()
                    });
                } else if(info.simStatus == "modem_sim_destroy" || info.simStatus == "modem_destroy") {
                    showAlert("invalid_simcard_jump",function(){
                        redirectNoConPath()
                    });
                }else if(info.simStatus == "modem_imsi_waitnck"  || info.simStatus == "modem_waitpin"|| info.simStatus == "modem_waitpuk") {
                    showAlert("locked_simcard_jump",function(){
                        redirectNoConPath()
                    });
                }else {
                    showAlert("connect_failed_jump",function(){
                        redirectNoConPath()
                    });
                }
            }
        } else if(window.location.href.indexOf("?flow_beyond") != -1){
            showAlert("flow_beyond_jump",function(){
                service.setRedirectOff();
                window.location.href = curentHref.slice(0,curentHref.indexOf("?flow_beyond")) + (config.isTrafficAlertSet? "#/traffic/view" : "#/traffic/traffic_setting");
            });
        } else if(window.location.href.indexOf("?fota_upgrade") != -1){
            showAlert("fota_upgrade_jump",function(){
                service.setRedirectOff();
                window.location.href = curentHref.slice(0,curentHref.indexOf("?fota_upgrade")) + "#/others/ota_update";
            });
        }

        $('#logout').off('click').on('click', function() {
            showConfirm("confirm_logout", function () {
                manualLogout = true;
                service.logout({}, function(){
                    window.location = 'index.html';
                });
            });
        });

        $('#trafficGo').off('click').on('click', function() {
            if(config.isTrafficAlertSet) {
                window.location.hash = '#/traffic/view';
            } else {
                window.location.hash = '#/traffic/traffic_setting';
            }
        });

        hasSubUnread = false;
        trafficData = service.getConnectionInfo();
        service.getSmsCapability({}, function (capa) {
            smsUsed = capa.nvUsed;
        });
        addInterval(function () {
            trafficData = service.getConnectionInfo();
            refreshHome();
        }, 1000);
        checkOtaResult();

    }

    return {
        init: init
    }
});
