#!/bin/sh
# Syslog mode control script by qianying

path_setted=`cfg get syslog_path`
#level_setted=`cfg get syslog_level`
#size_setted=`cfg get syslog_size`

#echo -e "setted values, path:[$path_setted]"
#echo "level:[$level_setted] size:[$size_setted]"

CACHE_DIR=/cache
DEFAULT_SYSLOG_PATH_1=$CACHE_DIR/zte_log
DEFAULT_SYSLOG_PATH_2=/usr/zte_web/web/zte_log
SYSLOG_FILENAME=syslog
ENMERGE_LEVEL=1
NOTICE_LEVEL=6
INFO_LEVEL=7
DEFAULT_SYSLOG_SIZE=1024
SYSLOG_CONFIG_FILE=/usr/zte/zte_conf/scripts/zte_syslog.conf

if [ -d $path_setted -a $path_setted != "" ] ; then
    path=$path_setted
    if [ -d $path ]
    then 
            echo "[$path] exist"
    else
            mkdir $path
     fi
    echo "good, using setted value[$path] as path"
else
#Set syslog default location
    if [ -d $CACHE_DIR ]
    then
          if [ -d $DEFAULT_SYSLOG_PATH_1 ]
          then 
            path=$DEFAULT_SYSLOG_PATH_1
          else
            mkdir $DEFAULT_SYSLOG_PATH_1
            path=$DEFAULT_SYSLOG_PATH_1 
          fi
    else
          path=$DEFAULT_SYSLOG_PATH_2
    fi
    echo "err, syslog_path not setted, use default [$path]"
fi

#Set syslog default level
level=$ENMERGE_LEVEL

#Set syslog default size
size=$DEFAULT_SYSLOG_SIZE

para1=$1

if [ "$para1" = "-L" -o "$para1" = "-R" ]
then
  echo "Start syslog setting"
else
  echo "Comand usage:"
  echo "./zte_syslog.sh -L -o <Path> -l Level <Level> -s <Size>"
  echo "                -R <HostIP>"
  exit 1
fi

if [ "$para1" = "-L" ]
then
  shift 
  if [ $# = 0 ]
  then
     cfg set syslog_mode=0
     cfg set syslog_path=$path
     cfg set syslog_level=$level
     cfg set syslog_size=$size
     cfg save
     
     killall -9 syslogd
     usleep 100
     syslogd -O $path/$SYSLOG_FILENAME  -l $level -s $size  
     echo "Please check if syslog running as you want"
     ps | grep -m 1 syslogd
     exit 0
  fi
  
  while getopts "o:l:s:" arg
  do
     case $arg in
        o)
          if [ -d $OPTARG ]
          then   
             path=$OPTARG
          else
             echo "Wrong path=$OPTARG"
             exit 1   
          fi
          ;;
        l)
             echo $OPTARG 
             level=$OPTARG

          ;;   
        s)      
          if [ $OPTARG -gt 0 ]
          then
          #echo $OPTARG   
             size=$OPTARG
          else
             echo "Wrong size=$OPTARG"
             exit 1   
          fi
          ;;            
        *)
           echo $OPTARG 
           echo "Comand usage:"
           echo "./zte_syslog.sh -L -o <Path> -l Level <Level> -s <Size>"
          exit 1   
        esac
      
    done
    
     cfg set syslog_mode=0
     cfg set syslog_path=$path
     cfg set syslog_level=$level
     cfg set syslog_size=$size
     cfg save

    killall -9 syslogd
    usleep 100
    syslogd -O $path/$SYSLOG_FILENAME  -l $level -s $size 
    echo "Please check if syslog running as you want"
    ps | grep -m 1 syslogd
	
	#added by liuweipeng for wpa_supplicant log 20140901 begin
	if [ "$level" = "7" ]
	then
		wpa_cli -i wlan0 log_level MSGDUMP -B
		echo "wpa_cli -i wlan0 log_level MSGDUMP -B"
	else
		wpa_cli -i wlan0 log_level ERROR -B
		echo "wpa_cli -i wlan0 log_level ERROR -B"
	fi
	#added by liuweipeng for wpa_supplicant log 20140901 end
	
    exit 0    
fi

if [ "$para1" = "-R" ]
then
    echo "Start sylog remote setting"
    if [ $# = 1 ]
    then
        echo "Comand usage:"
        echo "./zte_syslog.sh -R <Hostip> -l Level <Level>"
        exit 1   
   fi
fi 
   
  hostip=$2
  echo "Enable remote syslog hostip=$hostip"
  
  paralevel=$3
  echo "paralevel=$paralevel"
  if [ "$paralevel" = "-l" ]
  then
    echo "Start sylog remote setting"
    shift 
    if [ $# = 0 ]
    then
        echo "Comand usage:"
        echo "./zte_syslog.sh -R <Hostip> -l Level <Level>"
        exit 1
    else
        levelR=$3
        level=$levelR
        echo "level=$level "
        cfg set syslog_level=$level
    fi
  else
    echo "unknown $paralevel"
    echo "Comand usage:"
    echo "./zte_syslog.sh -R <Hostip> -l Level <Level>"
    #exit 1 
  fi

  cfg set syslog_mode=1
  cfg set syslog_host_ip=$hostip
  cfg save
     
  killall -9 syslogd
  usleep 100
  syslogd -R $hostip -l $level
  echo "Please check if syslog running as you want"
  ps | grep -m 1 syslogd
  
 	#added by liuweipeng for wpa_supplicant log 20140901 begin
	if [ "$level" = "7" ]
	then
		wpa_cli -i wlan0 log_level MSGDUMP -B
		echo "wpa_cli -i wlan0 log_level MSGDUMP -B"
	else
		wpa_cli -i wlan0 log_level ERROR -B
		echo "wpa_cli -i wlan0 log_level ERROR -B"
	fi
	#added by liuweipeng for wpa_supplicant log 20140901 end 
  
  exit 0
fi

 