﻿/**
 * statusBar 模块
 * @module statusBar
 * @class statusBar
 */
define([ 'knockout', 'jquery', 'underscore', 'service', 'config/config', 'config/menu', 'tooltip', 'status/statusBar'],
    function (ko, $, _, service, config, menu, tooltip, status) {
        var para_popup_Tel = {
            first_into_web:1,      //first_into_web:0—非首次打开web UI,1—首次打开web UI
            datausage_balancetolow:1,//datausage_balancetolow:0—流量未从高变低，1—流量从高变低
            datausage_creditexpired:0  //datausage_creditexpired: 0—未显示，1—已显示
        };
        var needAddBookMarks = true; //是否需要添加书签，false：不需要，true：需要

        var dataUsageUnit = 'MB';
		var dataUsageUnit2 = "MB";
		var dataUsageUnit3 = "MB";
		var rechargeUrl = "";

    function HeaderViewModel(){
        var self = this;
        var info = service.getHeaderInfo_Tel();
		rechargeUrl = info.rechargeUrl;
		self.isPrepaid = ko.observable(info.datausage_plantype == "prepaid");
		self.isPostpaid = ko.observable(info.datausage_plantype == "postpaid");
        self.datausage_Tel = ko.observable(changeUnit(info.datausage_remainamount, 1)); // prepaid	
		
		self.datausage_postpaid_percent = ko.observable(info.datausage_usedrate + "%");		
		self.datausage_usedamount = ko.observable(changeUnit(info.datausage_usedamount, 1));//postpaid
		self.datausage_allotedamount = ko.observable(changeUnit(info.datausage_allotedamount, 2));//postpaid
		var overDatausage = parseInt(info.datausage_usedamount, 10) - parseInt(info.datausage_allotedamount, 10);
		self.datausage_over = ko.observable(changeUnit(overDatausage, 3));
		self.isDatausageExpired = ko.observable(false);
		
        //self.percent = ko.observable(info.datausage_remainrate);
        self.datausage_unit = ko.observable(dataUsageUnit);
		self.datausage_unit2 = ko.observable(dataUsageUnit2);
		self.datausage_unit3 = ko.observable(dataUsageUnit3);
        self.datausage_lowbalance = ko.observable(info.datausage_lowbalance);
		self.rechargeUrl = ko.observable(rechargeUrl);
        self.remaindays_Tel = ko.observable('0'+' '+$.i18n.prop('days_remaining'));
        if(parseInt(info.datausage_remaindays) == 1){
            self.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('day_remaining'));
        }else{
            self.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('days_remaining'));
        }

        self.header_notification = ko.observable('');
        self.header_alert_content1 = ko.observable("");
        self.header_alert_content2 = ko.observable("");
        self.header_alert_content3 = ko.observable("");
		self.header_alert_content4 = ko.observable("");

        self.showDatausage = ko.observable(true);
        self.showNewVersionOnly = ko.observable(false);
        self.isTelstraSimCard = ko.observable(info.Telstra_sim_card);
        $("#header_alert_content li").css('color','#ffffff');
		$("#header_alert_content_postpaid li").css('color','#ffffff');
        if((info.header_hasNewVersion || info.dm_update_package_file_exist) && !config.HEADER_ALREADY_UPDATE_NOTICE && !info.isDisconnect){ //有新版本的情况
			if(!(info.datausage_syncresult)){  //有FOTA且无法同步到服务器的时候
                self.showDatausage(false);
            } else if(info.datausage_plantype == "postpaid"){
				var model_name = service.getNewVersionInfo_Tel().model_name;
				$("#header_alert_postpaid").addClass("color_darkblue");
				$("#close_img_postpaid").show();
				var temptext = "<span style=\'font-size:18px\'>" + $.i18n.prop('header_update_notification') + "</span>"+"<div style=\'height:5px\'></div>"+
					$.i18n.prop('header_update_alert1',model_name)+
					"<span style=\'text-decoration: underline;cursor: pointer;\' onclick=\'header_update()\'>"+
					$.i18n.prop('header_update_alert2')+"</span>";;
				$("#header_content1_postpaid").html(temptext);
				$("#header_notification_postpaid").hide();
				$("#header_content2_postpaid").hide();
				$("#header_content3_postpaid").hide();

				if(!info.Telstra_sim_card && !info.isDisconnect){
					self.showNewVersionOnly(true);
					$("#header_content1_onlyNewVersion").html(temptext);
				}
			} else {
				var model_name = service.getNewVersionInfo_Tel().model_name;
				$("#header_alert").addClass("color_darkblue");
				$("#close_img").show();
				var temptext = "<span style=\'font-size:18px\'>" + $.i18n.prop('header_update_notification') + "</span>"+"<div style=\'height:5px\'></div>"+
					$.i18n.prop('header_update_alert1',model_name)+
					"<span style=\'text-decoration: underline;cursor: pointer;\' onclick=\'header_update()\'>"+
					$.i18n.prop('header_update_alert2')+"</span>";;
				$("#header_content1").html(temptext);
				$("#header_notification").hide();
				$("#header_content2").hide();
				$("#header_content3").hide();

				if(!info.Telstra_sim_card && !info.isDisconnect){
					self.showNewVersionOnly(true);
					$("#header_content1_onlyNewVersion").html(temptext);
				}
			}
                
        }else if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete" && info.datausage_plantype == "prepaid"){  //是Telstra 预付费卡的情况
            if(!(info.datausage_syncresult)){  //没有联网或者流量信息无法获取的情况
                self.showDatausage(false);
            }else if(self.datausage_lowbalance() &&(parseInt(info.datausage_remainamount) !=0 &&
                parseInt(info.datausage_remaindays) != 0)
                && !config.HEADER_ALREADY_LOWBALANCE_NOTICE){ //Low Credit时的情况
                $("#header_alert").addClass("color_orange");
                $("#close_img").hide();
                self.header_notification = ko.observable($.i18n.prop('header_alert_notification'));
                self.header_alert_content1 = ko.observable($.i18n.prop('header_datausage_lowbalance_alert1'));
                self.header_alert_content2 = ko.observable($.i18n.prop('header_datausage_normal'));
                self.header_alert_content3 = ko.observable(rechargeUrl);
                $("#header_alert_link").attr("onclick","goToLink(1)");
            }else if(info.datausage_preactive && (parseInt(info.datausage_remainamount)==0||parseInt(info.datausage_remaindays) == 0) && !config.HEADER_ALREADY_EXPIRED_NOTICE){ //流量用完时的情况。
                $("#header_alert").addClass("color_red");
                $("#close_img").hide();
                self.header_notification = ko.observable($.i18n.prop('header_alert_notification'));
                self.header_alert_content1 = ko.observable($.i18n.prop('header_datausage_expired_alert1'));
                self.header_alert_content2 = ko.observable($.i18n.prop('header_datausage_normal'));
                self.header_alert_content3 = ko.observable(rechargeUrl);
                self.header_alert_content4 = ko.observable($.i18n.prop('header_popup_expire_content5'));	
				$("#header_alert_link").attr("onclick","goToLink(2)");
            }else{ //正常的可获取剩余流量信息的情况
                $("#close_img").hide();
                if($('#header_alert').hasClass("color_darkblue")){
                    $('#header_alert').removeClass("color_darkblue");
                }
                if($('#header_alert').hasClass("color_red")){
                    $('#header_alert').removeClass("color_red");
                }
                if($('#header_alert').hasClass("color_orange")){
                    $('#header_alert').removeClass("color_orange");
                }

                $("#header_alert_content li").css('color','#000000');
                var temp_text = $.i18n.prop('header_datausage_normal')+"   "+
                    "<a href=\'" + rechargeUrl + "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+
                    rechargeUrl +"</span></a>";
                $('#header_content1').html(temp_text);
            }
        } else if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete" && info.datausage_plantype == "postpaid"){//是Telstra 后付费的卡
			if(!(info.datausage_syncresult)){  //没有联网或者流量信息无法获取的情况
                self.showDatausage(false);
            }else if((parseInt(info.datausage_usedrate, 10) >= 50 && parseInt(info.datausage_usedrate, 10) <= 84) && !config.HEADER_ALREADY_HALFBALANCE_NOTICE){//流量使用在 50% ~ 84% 之间的情况
				self.isDatausageExpired(false);
				$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_blue");			
				$("#header_alert_postpaid").addClass("color_blue2");
                $("#close_img_postpaid").show();
                self.header_notification = ko.observable($.i18n.prop('header_alert_notification_postpaid'));
                self.header_alert_content1=ko.observable($.i18n.prop('header_datausage_halfbalance_postpaid'));
                self.header_alert_content2 = ko.observable($.i18n.prop('header_datausage_normal_postpaid'));
                self.header_alert_content3 = ko.observable(rechargeUrl);
                //$("#header_alert_link").attr("onclick","goToLink(0)");
			}else if((parseInt(info.datausage_usedrate, 10) >= 85 && parseInt(info.datausage_usedrate, 10) <= 99) && !config.HEADER_ALREADY_LOWBALANCE_NOTICE){ //流量使用在 85% ~ 99% 之间的情况
                self.isDatausageExpired(false);
				$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_orange");	
			    $("#header_alert_postpaid").addClass("color_orange");
                $("#close_img_postpaid").show();
                self.header_notification = ko.observable($.i18n.prop('header_alert_notification_postpaid'));
                //self.header_alert_content1=ko.observable(HTMLDecode($.i18n.prop('header_datausage_lowbalance_postpaid')));
				$('#header_content1_postpaid').html($.i18n.prop('header_datausage_lowbalance_postpaid'));
                self.header_alert_content2 = ko.observable($.i18n.prop('header_datausage_normal_postpaid'));
                self.header_alert_content3 = ko.observable(rechargeUrl);
                //$("#header_alert_link").attr("onclick","goToLink(1)");
            }else if(parseInt(info.datausage_usedrate, 10) >= 100 && !config.HEADER_ALREADY_EXPIRED_NOTICE){ //流量使用大于等于100%的情况。
				self.isDatausageExpired(true);
				var overDatausage = parseInt(info.datausage_usedamount, 10) - parseInt(info.datausage_allotedamount, 10);
				self.datausage_over(changeUnit(overDatausage, 3));
				self.datausage_unit3(dataUsageUnit3);
				$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_red");
                $("#header_alert_postpaid").addClass("color_red");
                $("#close_img_postpaid").hide();
                self.header_notification = ko.observable($.i18n.prop('header_alert_notification_postpaid'));
                self.header_alert_content1 = ko.observable($.i18n.prop('header_datausage_expired_postpaid'));
                self.header_alert_content2 = ko.observable($.i18n.prop('header_datausage_normal_postpaid'));
                self.header_alert_content3 = ko.observable(rechargeUrl);
                //self.header_alert_content4 = ko.observable($.i18n.prop('header_popup_expire_content5'));	
				//$("#header_alert_link").attr("onclick","goToLink(2)");
            }else{ //使用流量在0% ~ 49% 的情况
				self.isDatausageExpired(false);
				$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel");
                $("#close_img_postpaid").hide();
                if($('#header_alert_postpaid').hasClass("color_darkblue")){
                    $('#header_alert_postpaid').removeClass("color_darkblue");
                }
                if($('#header_alert_postpaid').hasClass("color_red")){
                    $('#header_alert_postpaid').removeClass("color_red");
                }
                if($('#header_alert_postpaid').hasClass("color_orange")){
                    $('#header_alert_postpaid').removeClass("color_orange");
                }

                $("#header_alert_content_postpaid li").css('color','#000000');
                var temp_text = $.i18n.prop('header_datausage_normal_postpaid')+"   "+
                    "<a href=\'" + rechargeUrl+ "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+
                    rechargeUrl +"</span></a>";
                $('#header_content1_postpaid').html(temp_text);
            }
		
		} else if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete" && !(info.datausage_syncresult)){//是telstra卡，但是没有同步上服务器的时候
			self.showDatausage(false);	
			$("#Header_unavailable").show();
		} else{  //不是Telstra的SIM卡的情况
             $("#Header_unavailable").hide();
             $("#Header_available").hide();
            $('#prepaidnumber').find('label').hide();
        }
    }
        header_update = function () {
            var info = service.getStatusInfo();
            if(info.isLoggedIn){
				var packHasExist = parseInt(service.getPackStatus().dm_update_package_file_exist)==1?true:false;
				if(downloadingDone || packHasExist) {
					downloadingDone = true;
					status.showFOTAInstallOrLater();
					return;
				} else {
					status.showOTAAlert();
				}                
            } else {
                showAlert("header_update_alert3");
            }
        }

        hide_header_alert = function (isPostpaid) {
			if(isPostpaid) {
				if($('#header_alert_postpaid').hasClass("color_darkblue")){
					$('#header_alert_postpaid').removeClass("color_darkblue");
					$("#header_notification_postpaid").show();
					$("#header_content2_postpaid").show();
					$("#header_content3_postpaid").show();
					$("#header_content3_postpaid").unbind().attr("style","text-decoration:underline");
					config.HEADER_ALREADY_UPDATE_NOTICE = true;
				}else if($('#header_alert_postpaid').hasClass("color_orange")){
					$('#header_alert_postpaid').removeClass("color_orange");
					config.HEADER_ALREADY_LOWBALANCE_NOTICE = true;					
					$("#close_img_postpaid").hide();
					$("#header_notification_postpaid").hide();
					$("#header_alert_content_postpaid li").css('color','#000000');
					var temp_text = $.i18n.prop('header_datausage_normal_postpaid')+"   "+
			"<a href=\'" + $.i18n.prop("rechargeurl_postpaid")+ "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+ $.i18n.prop("rechargeurl_postpaid") +"</span></a>";
					$('#header_content1_postpaid').html(temp_text);
					$("#header_content2_postpaid").html("");
					$("#header_content3_postpaid").html("");
				}else if($('#header_alert_postpaid').hasClass("color_red")){
					$('#header_alert_postpaid').removeClass("color_red");
					config.HEADER_ALREADY_EXPIRED_NOTICE = true;
					$("#close_img_postpaid").hide();
					$("#header_notification_postpaid").hide();
					$("#header_alert_content_postpaid li").css('color','#000000');
					var temp_text = $.i18n.prop('header_datausage_normal_postpaid')+"   "+
			"<a href=\'" + $.i18n.prop("rechargeurl_postpaid")+ "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+ $.i18n.prop("rechargeurl_postpaid") +"</span></a>";
					$('#header_content1_postpaid').html(temp_text);
					$("#header_content2_postpaid").html("");
					$("#header_content3_postpaid").html("");
				} else if($('#header_alert_postpaid').hasClass("color_blue2")){
					$('#header_alert_postpaid').removeClass("color_blue2");
					config.HEADER_ALREADY_HALFBALANCE_NOTICE = true;
					$("#close_img_postpaid").hide();
					$("#header_notification_postpaid").hide();
					$("#header_alert_content_postpaid li").css('color','#000000');
					var temp_text = $.i18n.prop('header_datausage_normal_postpaid')+"   "+
			"<a href=\'" + $.i18n.prop("rechargeurl_postpaid")+ "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+ $.i18n.prop("rechargeurl_postpaid") +"</span></a>";
					$('#header_content1_postpaid').html(temp_text);
					$("#header_content2_postpaid").html("");
					$("#header_content3_postpaid").html("");
				}
				if($('#header_alert_onlyNewVersion').hasClass("color_darkblue")){
					$('#header_alert_onlyNewVersion').removeClass("color_darkblue").hide();
					config.HEADER_ALREADY_UPDATE_NOTICE = true;
				}
			} else {
				 if($('#header_alert').hasClass("color_darkblue")){
					$('#header_alert').removeClass("color_darkblue");
					$("#header_notification").show();
					$("#header_content2").show();
					$("#header_content3").show();
					$("#header_content3").unbind().attr("style","text-decoration:underline");
					config.HEADER_ALREADY_UPDATE_NOTICE = true;
				}else if($('#header_alert').hasClass("color_orange")){
					$('#header_alert').removeClass("color_orange").hide();
					config.HEADER_ALREADY_LOWBALANCE_NOTICE = true;
				}else if($('#header_alert').hasClass("color_red")){
					$('#header_alert').removeClass("color_red").hide();
					config.HEADER_ALREADY_EXPIRED_NOTICE = true;
				}
				if($('#header_alert_onlyNewVersion').hasClass("color_darkblue")){
					$('#header_alert_onlyNewVersion').removeClass("color_darkblue").hide();
					config.HEADER_ALREADY_UPDATE_NOTICE = true;
				}
			}
        };

        hide_header_popup = function () {
            if($('#confirm_Tel').hasClass("color_orange")){
                $('#confirm_Tel').removeClass("color_orange");
                para_popup_Tel.datausage_balancetolow = 0;
                service.setpopupStatus_Tel(para_popup_Tel,function(){
                });
            }if($('#confirm_Tel').hasClass("color_red")){
                $('#confirm_Tel').removeClass("color_red");
                para_popup_Tel.datausage_creditexpired = 1;
                service.setpopupStatus_Tel(para_popup_Tel,function(){
                });
            }
            $.modal.close();
        };

        addcheckclass = function () {
            if($("#addBootMark_radio:visible").length>0){
                if($("#addBootMark_radio").is(":checked")){
                    needAddBookMarks = true;
                }else{
                    needAddBookMarks = false;
                }
            }

        }

        function changeUnit(volume, number) {
            if(volume == "" ||volume == undefined){
                volume = 0;
            }
            volume = parseFloat(volume);
            var needReverse = false;
            if(volume < 0){
                needReverse = true;
                volume = 0 - volume;
            }
            var numberOfBytesInOneB = 1;
            var numberOfBytesInOneKB = numberOfBytesInOneB * 1024;
            var numberOfBytesInOneMB = numberOfBytesInOneKB * 1024;
            var numberOfBytesInOneGB = numberOfBytesInOneMB * 1024;
            var numberOfBytesInOneTB = numberOfBytesInOneGB * 1024;

            var labelForOneB =  'B';
            var labelForOneKB =  'KB';
            var labelForOneMB =  'MB';
            var labelForOneGB =  'GB';
            var labelForOneTB =  'TB';

            if(volume>10737418){
                var vol = volume / numberOfBytesInOneGB;
                displayString = roundToTwoDecimalNumber(vol);
                displayString = displayString.toFixed(2);
                if(number == 1){
					dataUsageUnit = 'GB';
				} else if (number == 2) {
					dataUsageUnit2 = 'GB';
				} else if (number == 3) {
					dataUsageUnit3 = 'GB';
				}
            }else{
                var vol = volume / numberOfBytesInOneMB;
                displayString = roundToTwoDecimalNumber(vol);
                displayString = displayString.toFixed(2);
				if(number == 1) {
					dataUsageUnit = 'MB';
				} else if(number == 2) {
					dataUsageUnit2 = 'MB';
				} else if (number == 3) {
					dataUsageUnit3 = 'MB';
				}
                
            }
/*            var vol = volume / numberOfBytesInOneTB;
            var displayString = roundToTwoDecimalNumber(vol) + labelForOneTB;
            if (vol < 0.5) {
                vol = volume / numberOfBytesInOneGB;
                displayString = roundToTwoDecimalNumber(vol) + labelForOneGB;

                if (vol < 0.5) {
                    vol = volume / numberOfBytesInOneMB;
                    displayString = roundToTwoDecimalNumber(vol) + labelForOneMB;

                    if (vol < 0.5) {
                        vol = volume / numberOfBytesInOneKB;
                        displayString = roundToTwoDecimalNumber(vol) + labelForOneKB;

                        if (vol < 0.5) {
                            vol = volume;
                            displayString = roundToTwoDecimalNumber(vol) + labelForOneB;
                        }
                    }
                }
            }*/
            if(needReverse){
                displayString = "-" + displayString;
            }
            return displayString;
        };

        /*
        * 添加书签
        * */

        function addFavorite() {
            var favURL = "http://m.home";
            if (window.sidebar && window.sidebar.addPanel) { // Mozilla Firefox Bookmark
                window.sidebar.addPanel(document.title,favURL,'');
            } else if(window.external && ('AddFavorite' in window.external)) { // IE Favorite
                window.external.AddFavorite(favURL,document.title);
            } else if(window.opera && window.print) { // Opera Hotlist
                this.title=document.title;
                return true;
            } else { // webkit - safari/chrome
                /*showAlert($.i18n.prop('addBookMark_fastkey',(navigator.userAgent.toLowerCase().indexOf('mac') != - 1 ? 'Command/Cmd' : 'CTRL')));*/
            }
        }
		
		function isSupportBookmark(){			 
            if (window.sidebar && window.sidebar.addPanel) { // Mozilla Firefox Bookmark
                return true;
            } else if(window.external && ('AddFavorite' in window.external)) { // IE Favorite
                return true;
            } else if(window.opera && window.print) { // Opera Hotlist
                this.title=document.title;
                return true;
            } else { // webkit - safari/chrome
               return false;
            }
		}

        goToLink = function(status){
            if(status==1){
                para_popup_Tel.datausage_balancetolow = 0;
                service.setpopupStatus_Tel(para_popup_Tel);
				$("#header_alert_link").attr("href", rechargeUrl); 				
            }else if(status==2){
                para_popup_Tel.datausage_creditexpired = 1;
                service.setpopupStatus_Tel(para_popup_Tel);
				$("#header_alert_link").attr("href", rechargeUrl);
            }else if(status==3){
                para_popup_Tel.first_into_web = 0;
                service.setpopupStatus_Tel(para_popup_Tel);
				$("#header_unavailable_link").attr("href", $.i18n.prop("header_link")); 				
            } else if(status == 4){
				para_popup_Tel.first_into_web = 0;
                service.setpopupStatus_Tel(para_popup_Tel);
				$("#header_unavailable_link2").attr("href", $.i18n.prop("header_link2")); 
			}
			return true;
        }

    /**
     * 初始化ViewModel
     * @method init
     */
    function init() {
        window.setTimeout(function () {
            var vm = new HeaderViewModel();
            ko.applyBindings(vm, $('#Header_Tel')[0]);
            addcheckclass();
           
            window.setInterval(function () {
                service.getHeaderInfo_Tel({},function(info){
					rechargeUrl = info.rechargeUrl;
					vm.rechargeUrl(rechargeUrl);
                    if(info.modem_main_state == "modem_init_complete" && info.datausage_plantype == "prepaid"){
						vm.isPostpaid(false);
						vm.isPrepaid(true);
                        vm.showDatausage(true);
                        $('#prepaidnumber').find('label').show();
                        vm.datausage_Tel(changeUnit(info.datausage_remainamount, 1));
                        vm.datausage_unit(dataUsageUnit);
                        if(parseInt(info.datausage_remaindays) == 1){
                            vm.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('day_remaining'));
                        }else{
                            vm.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('days_remaining'));
                        }
                        vm.datausage_lowbalance(info.datausage_lowbalance);
						if(parseInt(info.datausage_remaindays) == 1){
							vm.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('day_remaining'));
						}else{
							vm.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('days_remaining'));
						}
                    } else if (info.modem_main_state == "modem_init_complete" && info.datausage_plantype == "postpaid"){
						vm.isPostpaid(true);
						vm.isPrepaid(false);
						vm.showDatausage(true);
						setProgressBar_Tel(parseInt(vm.datausage_postpaid_percent()));
						if((parseInt(info.datausage_usedrate, 10) >= 50 && parseInt(info.datausage_usedrate, 10) <= 84)){
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_blue");
							vm.isDatausageExpired(false);
						}else if(parseInt(info.datausage_usedrate, 10) >= 85 && parseInt(info.datausage_usedrate, 10) <= 99){
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_orange");
							vm.isDatausageExpired(false);
						}else if(parseInt(info.datausage_usedrate, 10) >= 100){
							vm.isDatausageExpired(true);
							var overDatausage = parseInt(info.datausage_usedamount, 10) - parseInt(info.datausage_allotedamount, 10);
							vm.datausage_over(changeUnit(overDatausage, 3));
							vm.datausage_unit3(dataUsageUnit3);
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_red");
						}else {
							vm.isDatausageExpired(false);
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel");
						}
						
						if(parseInt(vm.datausage_postpaid_percent(), 10) >= 100){
							vm.datausage_postpaid_percent(info.datausage_usedrate + "%+");
						} else {
							vm.datausage_postpaid_percent(info.datausage_usedrate + "%");
						}								
						vm.datausage_usedamount(changeUnit(info.datausage_usedamount, 1));//postpaid used
						vm.datausage_unit(dataUsageUnit);
						vm.datausage_allotedamount(changeUnit(info.datausage_allotedamount, 2));//postpaid total
						vm.datausage_unit2(dataUsageUnit2);
						if(parseInt(info.datausage_remaindays) == 1){
							vm.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('day_remaining'));
						}else{
							vm.remaindays_Tel(info.datausage_remaindays + ' ' + $.i18n.prop('days_remaining'));
						}
						
					} else {
                        vm.showDatausage(false);
						if(!info.Telstra_sim_card){
							$("#Header_unavailable").hide();
							$("#Header_avilable").hide();
							$('#prepaidnumber').find('label').hide();
						}                     
                    }                   

                    vm.header_notification("");
                    vm.header_alert_content1("");
                    vm.header_alert_content2("");
                    vm.header_alert_content3("");
					vm.header_alert_content4("");
                    vm.isTelstraSimCard(info.Telstra_sim_card);
                    $("#header_alert_content li").css('color','#ffffff');
					if (!info.header_hasNewVersion && !info.dm_update_package_file_exist){
						vm.showNewVersionOnly(false);
					}
                    if((info.header_hasNewVersion || info.dm_update_package_file_exist) && !config.HEADER_ALREADY_UPDATE_NOTICE && !info.isDisconnect){ //有新版本的情况
						if(!(info.datausage_syncresult) && info.Telstra_sim_card){  //有FOTA且无法同步到服务器的时候
							vm.showDatausage(false);
						} else if(info.datausage_plantype == "postpaid"){//同步上并且是postpaid
							$("#header_alert_content_postpaid li").css('color','#ffffff');
							var model_name = service.getNewVersionInfo_Tel().model_name;
							$("#header_alert_postpaid").addClass("color_darkblue");
							$("#close_img_postpaid").show();
						   //vm.header_notification($.i18n.prop('header_update_notification'));
							var temptext = "<span style=\'font-size:18px\'>" + $.i18n.prop('header_update_notification') + "</span>" +"<div style=\'height:5px\'></div>"+
								$.i18n.prop('header_update_alert1',model_name)+
								"<span style=\'text-decoration: underline;cursor: pointer;\' onclick=\'header_update()\'>"+
								$.i18n.prop('header_update_alert2')+"</span>";
							$("#header_content1_postpaid").html(temptext);
							$("#header_notification_postpaid").hide();
							$("#header_content2_postpaid").hide();
							$("#header_content3_postpaid").hide();
							vm.showNewVersionOnly(false);
							if(!info.Telstra_sim_card && !info.isDisconnect){
								vm.showNewVersionOnly(true);
								$("#header_content1_onlyNewVersion").html(temptext);
								$('#prepaidnumber').find('label').hide();
							}
						} else {
							var model_name = service.getNewVersionInfo_Tel().model_name;
							$("#header_alert").addClass("color_darkblue");
							$("#close_img").show();
						   //vm.header_notification($.i18n.prop('header_update_notification'));
							var temptext = "<span style=\'font-size:18px\'>" + $.i18n.prop('header_update_notification') + "</span>" +"<div style=\'height:5px\'></div>"+
								$.i18n.prop('header_update_alert1',model_name)+
								"<span style=\'text-decoration: underline;cursor: pointer;\' onclick=\'header_update()\'>"+
								$.i18n.prop('header_update_alert2')+"</span>";
							$("#header_content1").html(temptext);
							$("#header_notification").hide();
							$("#header_content2").hide();
							$("#header_content3").hide();
							vm.showNewVersionOnly(false);
							if(!info.Telstra_sim_card && !info.isDisconnect){
								vm.showNewVersionOnly(true);
								$("#header_content1_onlyNewVersion").html(temptext);
								$('#prepaidnumber').find('label').hide();
							}

						}
					} else if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete" && info.datausage_plantype == "prepaid"){  //是Telstra 预付费SIM卡的情况
                        $('#prepaidnumber').find('label').show();
                        if(!(info.datausage_syncresult)){  //没有联网或者流量信息无法获取的情况
                            vm.showDatausage(false);
                        }else if(vm.datausage_lowbalance()&&(parseInt(info.datausage_remainamount) !=0 &&
                            parseInt(info.datausage_remaindays) != 0) && !config.HEADER_ALREADY_LOWBALANCE_NOTICE){ //Low Credit时的情况
                            $("#header_alert").show();
                            if($('#header_alert').hasClass("color_darkblue")){
                                $('#header_alert').removeClass("color_darkblue");
                            }
                            $("#header_alert").addClass("color_orange");
                            $("#header_content2").show();
                            $("#header_content3").show();
                            $("#close_img").hide();
                            vm.header_notification($.i18n.prop('header_alert_notification'));
                            vm.header_alert_content1($.i18n.prop('header_datausage_lowbalance_alert1'));
                            vm.header_alert_content2($.i18n.prop('header_datausage_normal'));
                            vm.header_alert_content3(rechargeUrl);
                            $("#header_alert_link").attr("onclick","goToLink(1)");
                        }else if(info.datausage_preactive && (parseInt(info.datausage_remainamount)==0||parseInt(info.datausage_remaindays) == 0)&&!config.HEADER_ALREADY_EXPIRED_NOTICE){ //流量用完时的情况。
                            $("#header_alert").show();
                            if($('#header_alert').hasClass("color_darkblue")){
                                $('#header_alert').removeClass("color_darkblue");
                            }
                            $("#header_alert").addClass("color_red");
                            $("#header_content2").show();
                            $("#header_content3").show();
                            $("#close_img").hide();
                            vm.header_notification($.i18n.prop('header_alert_notification'));
                            vm.header_alert_content1($.i18n.prop('header_datausage_expired_alert1'));
                            vm.header_alert_content2($.i18n.prop('header_datausage_normal'));
                            vm.header_alert_content3(rechargeUrl);
							vm.header_alert_content4($.i18n.prop('header_popup_expire_content5'));
                            $("#header_alert_link").attr("onclick","goToLink(2)");
                        }else{ //正常的可获取剩余流量信息的情况
                            $("#close_img").hide();
                            if($('#header_alert').hasClass("color_darkblue")){
                                $('#header_alert').removeClass("color_darkblue");
                            }
                            if($('#header_alert').hasClass("color_red")){
                                $('#header_alert').removeClass("color_red");
                            }
                            if($('#header_alert').hasClass("color_orange")){
                                $('#header_alert').removeClass("color_orange");
                            }
                            $("#header_alert_content li").css('color','#000000');
                            var temp_text = $.i18n.prop('header_datausage_normal')+"  "+
                                "<a href=\'" + rechargeUrl + "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+
                                rechargeUrl +"</span></a>";
                            $('#header_content1').html(temp_text);
                        }
                    } else if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete" && info.datausage_plantype == "postpaid"){//是Telstra 后付费卡的情况
						$('#prepaidnumber').find('label').show();
                        if(!(info.datausage_syncresult)){  //没有联网或者流量信息无法获取的情况
                            vm.showDatausage(false);
                        }else if((parseInt(info.datausage_usedrate, 10) >= 50 && parseInt(info.datausage_usedrate, 10) <= 84)){//使用流量在50% ~ 84% 之间的情况
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_blue");
							vm.isDatausageExpired(false);
							
							if(!config.HEADER_ALREADY_HALFBALANCE_NOTICE){
								$("#header_alert_content_postpaid li").css('color','#ffffff');
								$("#header_alert_postpaid").addClass("color_blue2");
								$("#close_img_postpaid").show();
								$("#header_notification_postpaid").show();
								$("#header_content2_postpaid").show();
								$("#header_content3_postpaid").show();
								vm.header_notification($.i18n.prop('header_alert_notification_postpaid'));
								$('#header_content1_postpaid').html($.i18n.prop('header_datausage_halfbalance_postpaid'));
								//vm.header_alert_content1($.i18n.prop('header_datausage_halfbalance_postpaid'));
								vm.header_alert_content2($.i18n.prop('header_datausage_normal_postpaid'));
								//vm.header_alert_content3(rechargeUrl);
								vm.header_alert_content3($.i18n.prop("rechargeurl_postpaid"));
								$("#header_alert_link_postpaid").attr("href",$.i18n.prop("rechargeurl_postpaid")).css("color", '#ffffff');
								//$("#header_alert_link_postpaid").attr("onclick","goToLink(0)");
							}						
						} else if(parseInt(info.datausage_usedrate, 10) >= 85 && parseInt(info.datausage_usedrate, 10) <= 99){ //使用流量在85% ~ 99% 之间的情况						
                            $("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_orange");
							vm.isDatausageExpired(false);
							if(!config.HEADER_ALREADY_LOWBALANCE_NOTICE){
								$("#header_alert_content_postpaid li").css('color','#ffffff');
								$("#header_alert_postpaid").show();
								if($('#header_alert_postpaid').hasClass("color_darkblue")){
									$('#header_alert_postpaid').removeClass("color_darkblue");
								}
								$("#header_alert_postpaid").addClass("color_orange");
								$("#header_notification_postpaid").show();
								$("#header_content2_postpaid").show();
								$("#header_content3_postpaid").show();
								$("#close_img_postpaid").show();
							   
								vm.header_notification($.i18n.prop('header_alert_notification_postpaid'));
								$('#header_content1_postpaid').html($.i18n.prop('header_datausage_lowbalance_postpaid'));
								//vm.header_alert_content1(HTMLDecode($.i18n.prop('header_datausage_lowbalance_postpaid')));
								vm.header_alert_content2($.i18n.prop('header_datausage_normal_postpaid'));
								//vm.header_alert_content3(rechargeUrl);
								vm.header_alert_content3($.i18n.prop("rechargeurl_postpaid"));
								$("#header_alert_link_postpaid").attr("href",$.i18n.prop("rechargeurl_postpaid")).css("color", '#ffffff');
								//$("#header_alert_link").attr("onclick","goToLink(1)");
							}							
                        }else if(parseInt(info.datausage_usedrate, 10) >= 100){ //使用流量大于等于 100%的情况
                            vm.isDatausageExpired(true);
							var overDatausage = parseInt(info.datausage_usedamount, 10) - parseInt(info.datausage_allotedamount, 10);
							vm.datausage_over(changeUnit(overDatausage, 3));
							vm.datausage_unit3(dataUsageUnit3);
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel_red");
							if(!config.HEADER_ALREADY_EXPIRED_NOTICE){
								$("#header_alert_content_postpaid li").css('color','#ffffff');
								$("#header_alert_postpaid").show();
								if($('#header_alert_postpaid').hasClass("color_darkblue")){
									$('#header_alert_postpaid').removeClass("color_darkblue");
								}
								$("#header_alert_postpaid").addClass("color_red");
								$("#header_notification_postpaid").show();
								$("#header_content2_postpaid").show();
								$("#header_content3_postpaid").show();
								$("#close_img_postpaid").hide();
								vm.header_notification($.i18n.prop('header_alert_notification_postpaid'));
								vm.header_alert_content1($.i18n.prop('header_datausage_expired_postpaid'));
								vm.header_alert_content2($.i18n.prop('header_datausage_normal_postpaid'));
								//vm.header_alert_content3(rechargeUrl);
								vm.header_alert_content3($.i18n.prop("rechargeurl_postpaid"));
								$("#header_alert_link_postpaid").attr("href",$.i18n.prop("rechargeurl_postpaid")).css('color', '#ffffff');;
								//vm.header_alert_content4($.i18n.prop('header_popup_expire_content5'));
								//$("#header_alert_link").attr("onclick","goToLink(2)");
							}							
                        }else{ //使用流量在0% ~ 49%的情况
							vm.isDatausageExpired(false);
							$("#bar_Tel_postpaid").removeClass().addClass("progress-bar_Tel");
                            $("#close_img_postpaid").hide();
                            if($('#header_alert_postpaid').hasClass("color_darkblue")){
                                $('#header_alert_postpaid').removeClass("color_darkblue");
                            }
                            if($('#header_alert_postpaid').hasClass("color_red")){
                                $('#header_alert_postpaid').removeClass("color_red");
                            }
                            if($('#header_alert_postpaid').hasClass("color_orange")){
                                $('#header_alert_postpaid').removeClass("color_orange");
                            }
							$("#header_alert_content_postpaid li").css('color','#000000');
							var temp_text = $.i18n.prop('header_datausage_normal_postpaid')+"   "+
                    "<a href=\'" + $.i18n.prop("rechargeurl_postpaid")+ "\' target=\'_blank\'><span style=\'text-decoration: underline;color:#000000\'>"+ $.i18n.prop("rechargeurl_postpaid") +"</span></a>";
							$('#header_content1_postpaid').html(temp_text);
                       }				
				}else if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete" && !(info.datausage_syncresult)){//是telstra卡，但是没有同步上服务器的时候
					vm.showDatausage(false);
					$("#Header_unavailable").show();					
				} else{  //不是Telstra的SIM卡的情况
                        $("#Header_unavailable").hide();
                        $("#Header_avilable").hide();
                        $('#prepaidnumber').find('label').hide();
                    }

                    service.getpopupStatus_Tel({},function(popupStatus){
                        para_popup_Tel.first_into_web = popupStatus.first_into_web==true?1:0;
                        para_popup_Tel.datausage_balancetolow = popupStatus.datausage_balancetolow==true?1:0;
                        para_popup_Tel.datausage_creditexpired = popupStatus.datausage_creditexpired==true?0:1;

                        var msgObj = {
                            title : "",
                            msg : ""
                        };
                        if($("#confirm_Tel:visible").length==0 && $("#confirm:visible").length==0){   //当不存在弹出框时
                            if(info.Telstra_sim_card && info.modem_main_state == "modem_init_complete"){  //是Telstra的SIM卡的情况
                                if(!(info.datausage_syncresult)){  //没有联网或者流量信息无法获取的情况
                                    //vm.showDatausage(false);
                        }else if(popupStatus.first_into_web && info.datausage_prepaid){  //首次打开UI
                                    msgObj.title = "header_popup_active_notification1";
									if(isSupportBookmark()){
										msgObj.msg = $.i18n.prop("header_popup_active_content1")+"<br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_active_content2")+$.i18n.prop("header_popup_active_content_bookmark")+"<br/><br/>"+
                                        '<input id=\"addBootMark_radio\" type=\"checkbox\" onclick=\"addcheckclass();\"  style=\"margin-left: 0px; cursor:pointer\" checked=\"true\" />'+" "+
                                        $.i18n.prop("addBookMark");
									} else {
										msgObj.msg = $.i18n.prop("header_popup_active_content1")+"<br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_active_content2")+"<br/><br/>"+ $.i18n.prop("addBookMark_keyboard");
                                        
									}
									$("#confirm_Tel").removeClass("color_orange");
                                    $("#confirm_Tel").removeClass("color_red");
                                    $("#confirm_Tel").addClass("color_darkblue");
                                    $("#close_div").hide();
                                    showAlert_Tel(msgObj,function(){
                                        para_popup_Tel.first_into_web = 0;
                                        service.setpopupStatus_Tel(para_popup_Tel,function(){
                                        });

                                        if(needAddBookMarks){
                                            $("#confirm_Tel").removeClass("color_darkblue");
                                            addFavorite();
                                        }else{
                                            if(info.datausage_preactive){
                                                $("#confirm_Tel").removeClass("color_darkblue");
                                                return false;
                                            }else{
                                                msgObj.title = "header_popup_active_notification2";
                                                msgObj.msg = $.i18n.prop("header_popup_active_content3")+"<br/>"+"<br/>"+
                                                    $.i18n.prop("header_popup_active_content4")+
                                                    "<span>"+$.i18n.prop("header_popup_active_content5")+"</span><br/>"+"<br/>"+
                                                    $.i18n.prop("header_popup_active_content6",info.msisdn_Tel);
                                                showAlert_Tel(msgObj,function(){
                                                    para_popup_Tel.first_into_web = 0;
                                                    service.setpopupStatus_Tel(para_popup_Tel);
													config.HEADER_ACTIVATE_NOTICE = true;
													$("#confirm_Tel").removeClass("color_darkblue");
													$("#okbtn_Tel").attr("href","https://www.my.telstra.com.au/activate");
													return true;
                                                },'header_popup_activate');
                                            }
                                        }
                                    });
                    }else if(!info.datausage_preactive&& !config.HEADER_ACTIVATE_NOTICE && info.datausage_prepaid){  //未激活的情况
									$("#confirm_Tel").removeClass("color_orange");
                                    $("#confirm_Tel").removeClass("color_red");
                                    $("#confirm_Tel").addClass("color_darkblue");
                                    $("#close_div").hide();
                                    msgObj.title = "header_popup_active_notification2";
                                    msgObj.msg = $.i18n.prop("header_popup_active_content3")+"<br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_active_content4")+
                                        "<span>"+$.i18n.prop("header_popup_active_content5")+"</span><br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_active_content6",info.msisdn_Tel);
                                    showAlert_Tel(msgObj,function(){
                                        para_popup_Tel.first_into_web = 0;
                                        service.setpopupStatus_Tel(para_popup_Tel);
										config.HEADER_ACTIVATE_NOTICE = true;
										$("#confirm_Tel").removeClass("color_darkblue");
										$("#okbtn_Tel").attr("href","https://www.my.telstra.com.au/activate");
										return true;
                                    },'header_popup_activate');
                                }
                                else if(vm.datausage_lowbalance() &&
                                    (parseInt(info.datausage_remainamount)!=0&&parseInt(info.datausage_remaindays) != 0)
                                    && popupStatus.datausage_balancetolow && info.datausage_prepaid){  //流量低
                                   /* msgObj.title = "header_alert_notification_popup";
                                    msgObj.msg = $.i18n.prop("header_popup_low_content1")+"<br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_low_content2")+
                                        "<span>"+rechargeUrl+"</span><br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_low_content4",info.msisdn_Tel);
									$("#confirm_Tel").removeClass("color_darkblue");
									$("#confirm_Tel").removeClass("color_red");
                                    $("#confirm_Tel").addClass("color_orange");
                                    $("#close_div").show();
                                    showAlert_Tel(msgObj,function(){
                                        para_popup_Tel.datausage_balancetolow = 0;
                                        service.setpopupStatus_Tel(para_popup_Tel);	
											$("#confirm_Tel").removeClass("color_orange");
											$("#okbtn_Tel").attr("href",rechargeUrl);
										return true;
                                    },'header_popup_continue');*/
                                }/*else if(info.datausage_preactive && (parseInt(info.datausage_remainamount)==0||parseInt(info.datausage_remaindays) == 0) &&
                                    popupStatus.datausage_creditexpired && info.datausage_prepaid){ //流量超期
                                    msgObj.title = "header_alert_notification_popup";
                                    msgObj.msg = $.i18n.prop("header_popup_expire_content1")+"<br/>"+"<br/>"+
                                        $.i18n.prop("header_popup_expire_content2")+
                                        "<span>"+rechargeUrl+"</span><br/>"+ $.i18n.prop("header_popup_expire_content5") + "<br/><br/>" + 
                                        $.i18n.prop("header_popup_expire_content4",info.msisdn_Tel);
									$("#confirm_Tel").removeClass("color_orange");
									$("#confirm_Tel").removeClass("color_darkblue");
                                    $("#confirm_Tel").addClass("color_red");
                                    $("#close_div").show();
                                    showAlert_Tel(msgObj,function(){
                                        para_popup_Tel.datausage_creditexpired = 1;
                                        service.setpopupStatus_Tel(para_popup_Tel);
										$("#confirm_Tel").removeClass("color_red");
											$("#okbtn_Tel").attr("href",rechargeUrl);
										return true;
                                    },'header_popup_Topupnow');
                                }*/
                            }
                        }
                    });
                });
            },1000);
        },1000);
    }

    return {
        init:init
    };
});