/**
 * 选网模块
 * @module net_select
 * @class net_select
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'status/statusBar' ],

function($, ko, config, service, _,statusBar) {
	
	var selectModes = _.map(config.AUTO_MODES, function(item) {
		return new Option(item.name, item.value);
	});

    /**
     * 选网功能view model
     * @class NetSelectVM
     */
	function NetSelectVM() {
		var self = this;
        var info = service.getConnectionInfo();
        self.enableFlag = ko.observable(true);
        self.types = ko.observableArray(selectModes);
		self.selectedType = ko.observable();
		self.selectMode = ko.observable();
		self.networkList = ko.observableArray([]);
		self.selectNetwork = ko.observable('');

        self.networkStatus = function(data) {
            return $.i18n.prop(getNetworkStatus(data.nState));
        };

        self.networkStatusId = function(data) {
            return getNetworkStatus(data.nState);
        };

		self.networkText = function(data) {
			return data.strNumeric;
		};

        self.operatorName = function(data) {
            return data.strShortName;
        };

        self.networkType = function(data) {
            var result = getNetworkType(data.nRat);
            if(result == "auto")
                result = $.i18n.prop("auto");
            return result;
        };

        self.networkTypeId = function(data) {
            return getNetworkType(data.nRat);
        };

		self.networkValue = function(data) {
			var result = [];
			//strNumeric
			result.push(data.strNumeric);
			//nRat
			result.push(data.nRat);
            //nState
            result.push(data.nState);
			return result.join(',');
		};

        /**
         * 自动选网时设置网络模式
         * @method save
         */
		self.save = function() {
			showLoading();
			
			//AutoSelect call SetBearerPreference
			var params = {};
			params.strBearerPreference = self.selectedType();
			service.setBearerPreference(params, function(result) {
				if (result.result == "success") {
                    self.networkList([]);
					successOverlay();
				} else {
					errorOverlay();
				}
			});
		};

        /**
         * 手动搜网
         * @method search
         */
		self.search = function() {
			showLoading('searching_net');
			service.scanForNetwork(function(result, networkList) {
				hideLoading();
				if (result) {
					self.networkList(networkList);
                    for(var i=0;i<networkList.length;i++){
                        var obj = networkList[i];
                        if(obj.nState == "2"){
                            self.selectNetwork(obj.strNumeric + "," + obj.nRat + "," + obj.nState);
                            return;
                        }
                    }
				} else {
					self.networkList([]);
				}
			});
		};

        /**
         * 注册选择的网络
         * @method register
         */
		self.register = function() {
			showLoading('registering_net');
			var networkToSet = self.selectNetwork().split(',');
			var nState = parseInt(networkToSet[2]);
            service.setNetwork(networkToSet[0], parseInt(networkToSet[1]), function(result) {
				if (result) {
					self.networkList([]);
                    /*var autoType = getNetSelectInfo();
                    self.selectedType(autoType.net_select);*/
                    var params = {};
                    params.strBearerPreference = self.selectedType();
                    service.setBearerPreference(params, function(result) {
                        if (result.result == "success") {
                            self.networkList([]);
                            self.selectMode("auto_select");
                        } else {									
                        }
                    });
					successOverlay();
				} else {
                    if(nState==3){
                        hideLoading();
                        showAlert("register_forbidden_network_info",function(){
                            var info = getNetSelectInfo();
                            if ("manual_select" == info.net_select_mode || "manual_select" == info.m_netselect_save){
                                self.selectMode("manual_select");
                            }
                            else {
                                self.selectMode("auto_select");
                            }
                            var params = {};
							params.strBearerPreference = self.selectedType();
							service.setBearerPreference(params, function(result) {
								if (result.result == "success") {
									self.networkList([]);
									self.selectMode("auto_select");
								} else {									
								}
							});
                        });
                    }else{
                        errorOverlay();
                    }

				}
			});
		};

        self.checkEnable = function() {
            var status = service.getStatusInfo();
            if (checkConnectedStatus(status.connectStatus) || status.connectStatus == "ppp_connecting") {
                self.enableFlag(false);
            }
            else {
                self.enableFlag(true);
            }
        };

		//init data
		self.checkEnable();
        var info = getNetSelectInfo();
		if ("manual_select" == info.net_select_mode || "manual_select" == info.m_netselect_save){
			self.selectMode("manual_select");
		}
		else {
			self.selectMode("auto_select");
		}

        self.selectedType(info.net_select);
        self.connectStatus = ko.observable(info.connectStatus);
        self.transText = ko.dependentObservable(function() {
            if (checkConnectedStatus(self.connectStatus())) {
                $("#btnConnect").attr("class","btnConnect_connect");
                return "disconnect";
            }else if(checkConnectingStatus(self.connectStatus())){
                return "connecting";
            }else if(checkDisconnectingStatus(self.connectStatus())){
                return "disconnecting";
            }else{
                $("#btnConnect").attr("class","btnConnect_disconnect");
                return "connect";
            }
        });
        self.canConnect = ko.observable(getCanConnectNetWork());
        self.connectStatusText = ko.dependentObservable(function() {
            self.canConnect();

            /*if (checkConnectedStatus(self.connectStatus())) {
             return $.i18n.prop("disconnect");
             } else {
             return $.i18n.prop("connect");
             }*/

            if (checkConnectedStatus(self.connectStatus())) {
                $("#btnConnect").attr("class","btnConnect_connect");
                return $.i18n.prop("disconnect");
            }else if(checkConnectingStatus(self.connectStatus())){
                return $.i18n.prop("connecting");
            }else if(checkDisconnectingStatus(self.connectStatus())){
                return $.i18n.prop("disconnecting");
            }else{
                $("#btnConnect").attr("class","btnConnect_disconnect");
                return $.i18n.prop("connect");
            }
        });
        /**
         * 响应连接按钮事件
         *
         * @event connectHandler
         */
        self.connectHandler = function() {
            if (checkConnectedStatus(self.connectStatus())) {
                showLoading('disconnecting');
                $("#btnConnect").attr("trans","disconnecting").translate();
                service.disconnect({}, function(data) {
                    if(data.result){
                        successOverlay("disconnect_success_info");
                        $("#homebtn").attr("trans","connect").translate();
                    } else {
                        errorOverlay();
                        $("#homebtn").attr("trans","disconnect").translate();
                    }
                });
            } else {
                if(service.getStatusInfo().roamingStatus && service.getStatusInfo().roamMode == "off") {
                    showAlert("dial_roam_info");
                }
                else {
                    self.connect();
                }
            }
        };

        self.connect = function() {
            var statusInfo = service.getStatusInfo();
            var trafficResult = statusBar.getTrafficResult(statusInfo);
            if(statusInfo.limitVolumeEnable && trafficResult.showConfirm){
                var confirmMsg = null;
                if(trafficResult.usedPercent > 100){
                    confirmMsg = {msg: 'traffic_beyond_connect_msg'};
                    statusBar.setTrafficAlertPopuped(true);
                } else {
                    confirmMsg = {msg: 'traffic_limit_connect_msg', params: [trafficResult.limitPercent]};
                    statusBar.setTrafficAlert100Popuped(false);
                }
                showConfirm(confirmMsg, function(){
                    doConnect();
                });
            }else{
                doConnect();
            }
        };
	}

    /**
     * 获取网络选择信息
     * @method getNetSelectInfo
     */
	function getNetSelectInfo() {
		return service.getNetSelectInfo();
	}

    /**
     * 搜网结果中的状态转换为对应的语言项
     * @method getNetworkStatus
     * @param {String} status
     * @return {String}
     */
	function getNetworkStatus(status) {
		if ("0" == status){		
			return "unknown";
		}else if ("1" == status){
			return "available";
		}else if ("2" == status){
			return "current";
		}else if ("3" == status){
			return "forbidden";
		}
	}

    /**
     * 网络类型转换
     * @method getNetworkType
     * @param {String} type
     * @return {String}
     */
	function getNetworkType(type)
	{
		if ("0" == type){
			return "2G";
		}else if ("2" == type){
			return "3G";
		}else if("7" == type){
            return "4G";
        }else{
			return "auto";
		}
	}
    function refreshConnectionStatus(vm){
        var info = service.getConnectionInfo();
        vm.canConnect(getCanConnectNetWork());
        vm.connectStatus(info.connectStatus);
        vm.checkEnable();
    }
    function doConnect(){
        showLoading('connecting');
        $("#btnConnect").attr("trans","connecting").translate();
        service.connect({}, function(data) {
            if(data.result){
                successOverlay("connect_success_info");
                $("#homebtn").attr("trans","disconnect").translate();
            } else {
                errorOverlay();
                $("#homebtn").attr("trans","connect").translate();
            }
        });
    }
    function getCanConnectNetWork(){
        var status = service.getStatusInfo();
        if (status.simStatus != "modem_init_complete") {
            return false;
        }

        if (checkConnectedStatus(status.connectStatus)) {
            if (config.AP_STATION_SUPPORT) {                
                if (status.ap_station_enable) {
                    var result = service.getConnectionMode();
                    if (result.connectionMode == "auto_dial") {
                        return false;
                    }
                }
            }
            return true;
        }

        //如果已联网，但是没有信号，断网按钮需要可以用
        if (status.signalImg == "0") {
            return false;
        }
        var networkTypeTmp = status.networkType.toLowerCase();
        if (networkTypeTmp == '' || networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service') {
            return false;
        }
        if("ppp_connecting"==status.connectStatus || "ppp_disconnecting"==status.connectStatus){
            return false;
        }
        if (config.AP_STATION_SUPPORT) {
            //var ap = service.getAPStationBasic()

            if (status.connectWifiStatus == "connect") {
                if (status.ap_station_mode == "wifi_pref") {
                    return false;
                }
            }
        }

        return true;
    }
    /**
     * 初始化选网功能view model
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new NetSelectVM();
		ko.applyBindings(vm, container[0]);
        $('#frmNetSelect').validate({
            submitHandler : function() {
                vm.connectHandler();
            }
        });
        refreshConnectionStatus(vm);
        addInterval(function(){refreshConnectionStatus(vm);},1000);
		//addInterval( vm.checkEnable, 1000);
	}

	return {
		init : init
	};
});