/**
 * 流量提醒模块
 * @module TrafficAlert
 * @class TrafficAlert
 */
define(['jquery', 'knockout', 'service', 'status/statusBar'], function($, ko, service, status) {
	/**
	 * 获取流量提醒数据
	 * @method getTrafficAlertInfo
	 */
	function getTrafficAlertInfo(){
		return service.getTrafficAlertInfo();
	}
	/**
	 * 流量提醒ViewModel
	 * @class TrafficVM
	 */
	function TrafficVM(){
		var self = this;
		var info = getTrafficAlertInfo();
		self.dataLimitChecked = ko.observable(info.dataLimitChecked == '0' ? '0' : '1');
		self.dataLimitTypeChecked = ko.observable(info.dataLimitTypeChecked == '0' ? '0' : '1');
		var dataMonth = info.limitDataMonth.split("_");
	//	self.limitDataMonth = ko.observable(dataMonth[0] || 0);
		if(dataMonth[1] == '1'){
            dataMonth[0] = dataMonth[0]*1024*1024;
        }else if(dataMonth[1] == '1024'){
            dataMonth[0] = dataMonth[0]*1024*1024*1024;
        }else{
            dataMonth[0] = dataMonth[0]*1024*1024*1024*1024;
        }
		var data_plan = transUnit(parseInt(dataMonth[0],10),false);
        var dataPlanInfo = getDataInfo(data_plan);
        var d_plan = dataPlanInfo.data;
        var unit_plan = dataPlanInfo.unit;
		self.limitDataMonth = ko.observable(roundToTwoDecimalNumber(d_plan) || 0);
        if(unit_plan == 'GB'){
            self.selectedDataUnit = ko.observable('1024');
			self.limitDataMonth(d_plan);
        }else if(unit_plan == 'TB'){
            self.selectedDataUnit = ko.observable('1048576');
			self.limitDataMonth(d_plan);
        }else{
            self.selectedDataUnit = ko.observable('1');
			self.limitDataMonth(d_plan);
        }
	//	self.selectedDataUnit = ko.observable(dataMonth[1] || 1);
		self.alertDataReach = ko.observable(info.alertDataReach || 0);
		self.limitTimeMonth = ko.observable(info.limitTimeMonth || 0);
		self.alertTimeReach = ko.observable(info.alertTimeReach || 0);
		self.save = function(){
			showLoading();
			service.setTrafficAlertInfo({
				dataLimitChecked: self.dataLimitChecked(),
				dataLimitTypeChecked: self.dataLimitTypeChecked(),
				limitDataMonth: self.limitDataMonth() + "_" + self.selectedDataUnit(),
				alertDataReach: self.alertDataReach(),
				limitTimeMonth: self.limitTimeMonth(),
				alertTimeReach: self.alertTimeReach()
			}, function(data){
				if(data.result == 'success'){
                    status.setTrafficAlertPopuped(false);
					successOverlay();
				} else {
					errorOverlay();
				}
			}, function(data){
				errorOverlay();
			});
		};
	}
	/**
	 * 流量提醒初始化函数
	 * @method init
	 */
	function init(){
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new TrafficVM();
		ko.applyBindings(vm, container[0]);
		$('#trafficAlertForm').validate({
			submitHandler : function() {
				vm.save();
			},
			rules : {
				limitDataMonth : {
					range_data_usage2 : [ 1, 10000 ],
					point_data_usage : true
				},
				limitTimeMonth : {
					range_data_usage2 : [ 1, 10000 ],
					point_data_usage : true
				},
				alertDataReach : {
					digits : true,
					range : [ 1, 100 ]
				},
				alertTimeReach : {
					digits : true,
					range : [ 1, 100 ]
				}
			},
            errorPlacement : function(error, element) {
				if (element.attr("name") == "limitDataMonth") {
					error.insertAfter("#dataUnit");
				} else if (element.attr("name") == "alertDataReach") {
					error.insertAfter("#traffic_data_percent");
				} else if (element.attr("name") == "limitTimeMonth") {
					error.insertAfter("#hours");
				} else if (element.attr("name") == "alertTimeReach") {
					error.insertAfter("#traffic_time_percent");
				} else {
					error.insertAfter(element);
				}
			}
		});
		$.validator.addMethod("range_data_usage2", function (value, element, param) {
		if(value.substring(value.length-1) == '.'|| value.substring(0,1) == '0' || value.substring(0,1) == '.'){
			return false;
		} else {
			return this.optional(element) || ( value >= param[0] && value <= param[1] );
		}
		});
		$.validator.addMethod("point_data_usage", function (value, element, param) {
			if(value.split('.')[1] && value.split('.')[1].length > 2){
				return false;
			} else {
				return true;
			}
		});
	}
	
	return {
		init: init
	};
});