/**
 * AP Station模块
 * @module AP Station
 * @class AP Station
 */

define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'status/statusBar'],

    function ($, ko, config, service, _, status) {
        var isWifi = false;
        var searchID = -1;
        var addID = -1;
        var ssidSelect;
        var editAPindex=-1;
        /**
         * AP Station ViewModel
         * @class apModel
         */
        function apModel() {
            var self = this;

            var securityModes = _.map(config.AUTH_MODES_ALL, function (item) {
                return new Option(item.name, item.value);
            });

            var encryptTypeModes = _.map(config.ENCRYPT_TYPE_MODES, function (item) {
                return new Option(item.name, item.value);
            });

            var keyIDModes = _.map(config.KEY_ID_MODES, function (item) {
                return new Option(item.name, item.value);
            });

            var basicInfo = service.getWifiBasic();
            self.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
            self.hasMultiSSID = config.HAS_MULTI_SSID;
            self.isUfi = ko.observable(config.DEVICE.toLowerCase().indexOf("ufi") !=-1);
            self.isSupportApDailPref = config.AP_DIAL_PREF_SUPPORT;
            self.origin_wifi_enable = basicInfo.wifi_enable;
            self.wifi_enable = ko.observable(basicInfo.wifi_enable);
            self.isShowSSIDInfoDiv = ko.observable(false);
            if(config.WIFI_SWITCH_SUPPORT) {
                if(basicInfo.wifi_enable == "1") {
                    self.isShowSSIDInfoDiv(true);
                } else {
                    self.isShowSSIDInfoDiv(false);
                }
            } else {
                self.isShowSSIDInfoDiv(true);//如果不支持软开关，整个SSID信息块显示
            }
            self.multi_ssid_enable = ko.observable(basicInfo.multi_ssid_enable);

            self.page = {list:1, add:2, addlist:3, edit:4};
            var info = service.getAPStationBasic();
            self.pageState = ko.observable(self.page.list);
            self.origin_ap_station_enable = info.ap_station_enable;
            self.ap_station_enable = ko.observable(info.ap_station_enable);
			self.ap_station_enable_show = ko.observable(info.ap_station_enable);
            self.origin_ap_station_mode = info.ap_station_mode;
            self.ap_station_mode = ko.observable(info.ap_station_mode);
            self.apSearchList = ko.observable([]);
            self.apAddList = ko.observable([]);
            self.profileName = ko.observable();
            self.ssid = ko.observable();
            self.modes = securityModes;
            self.authMode = ko.observable();
            self.encryptType = ko.observableArray(encryptTypeModes);
            self.selectedencryptType = ko.observable('NONE');
            self.keyIDMode = ko.observableArray(keyIDModes);
            self.signal = ko.observable("0");
            self.keyID = ko.observable("0");
            self.password = ko.observable();
            self.showPassword = ko.observable(false);
            self.encryptType_WPA = ko.observable("TKIPCCMP");

            /**
             * 设置AP station参数
             * @event clear
             *
             */
            self.apply = function () {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                var dirverCount = 0;
                function checkWifiDirver(data) {
                    service.getWpsInfo({},function(val){
                        if (val.radioFlag=='0' || val.radioFlag=='1') {
                            self.callback(data, true);
                        } else {
                            if (dirverCount <= 20) {
                                dirverCount = dirverCount + 1;
                                addTimeout(function(){
                                    checkWifiDirver(data);
                                }, 2000);
                            } else {
                                self.callback(data, true);
                            }
                        }
                    })
                }

                function setBasic(){
                    showLoading();
                    var para = {};
                    para.ap_station_enable = self.ap_station_enable();
                    para.ap_station_mode = self.ap_station_mode();
                    service.setAPStationBasic(para, function (data) {
                        setTimeout(function(){
                            checkWifiDirver(data);
                        },2000);
                    });
                }

                if (self.origin_ap_station_enable == "0" && self.ap_station_enable() == "1") {
                    var info = service.getWifiBasic();
                    var wifiInfo = service.getWifiAdvance();

                    var callback = {
                        ok:function(){
                            setBasic();
                        },
                        no:  function(){
                            self.ap_station_enable(self.origin_ap_station_enable);
                        }
                    };
                    //if(info.multi_ssid_enable=='1'&&wifiInfo.wifiBand=='a'){
                    //    showConfirm("ap_alert_mssid_5GHz", callback);
                    //}else if(info.multi_ssid_enable!='1'&&wifiInfo.wifiBand=='a'){
                    //    showConfirm("ap_alert_5GHz", callback);
                    //}else
                    if(info.multi_ssid_enable=='1'&&wifiInfo.wifiBand!='a'){
                        showConfirm("ap_station_enable_confirm", callback);
                    }else{
                        setBasic();
                    }
                } else {
                    setBasic();
                }
            };

            function mySmallFun(a,b){
                var str = "";
                if(b == ""){
                    str = a;
                }else{
                    str = a +";" + b;
                }
                return str;
            }

            function wifi_profile_sort(tempWifiProfile, wifi_profile_num,isSort){
                var wifiProfileArr = tempWifiProfile.split(";");
                switch(parseInt(wifi_profile_num/5, 10)){
                    case 0:
                        wifi_profile = tempWifiProfile;
                        wifi_profile1 = "";
                        wifi_profile2 = "";
                        wifi_profile3 = "";
                        wifi_profile4 = "";
                        wifi_profile5 = "";
                        break;
                    case 1:
                        wifi_profile = myConcat(0, 4, wifiProfileArr);
                        wifi_profile1 = myConcat(5, 9, wifiProfileArr);
                        wifi_profile2 = "";
                        wifi_profile3 = "";
                        wifi_profile4 = "";
                        wifi_profile5 = "";
                        break;
                    case 2:
                        wifi_profile = myConcat(0, 4, wifiProfileArr);
                        wifi_profile1 = myConcat(5, 9, wifiProfileArr);
                        wifi_profile2 = myConcat(10, 14, wifiProfileArr);
                        wifi_profile3 = "";
                        wifi_profile4 = "";
                        wifi_profile5 = "";
                        break;
                    case 3:
                        wifi_profile = myConcat(0, 4, wifiProfileArr);
                        wifi_profile1 = myConcat(5, 9, wifiProfileArr);
                        wifi_profile2 = myConcat(10, 14, wifiProfileArr);
                        wifi_profile3 = myConcat(15, 19, wifiProfileArr);
                        wifi_profile4 = "";
                        wifi_profile5 = "";
                        break;
                    case 4:
                        wifi_profile = myConcat(0, 4, wifiProfileArr);
                        wifi_profile1 = myConcat(5, 9, wifiProfileArr);
                        wifi_profile2 = myConcat(10, 14, wifiProfileArr);
                        wifi_profile3 = myConcat(15, 19, wifiProfileArr);
                        wifi_profile4 = myConcat(20, 24, wifiProfileArr);
                        wifi_profile5 = "";
                        break;
                    case 5:
                    case 6:
                        wifi_profile = myConcat(0, 4, wifiProfileArr);
                        wifi_profile1 = myConcat(5, 9, wifiProfileArr);
                        wifi_profile2 = myConcat(10, 14, wifiProfileArr);
                        wifi_profile3 = myConcat(15, 19, wifiProfileArr);
                        wifi_profile4 = myConcat(20, 24, wifiProfileArr);
                        wifi_profile5 = myConcat(25, 29, wifiProfileArr);
                        break;
                }

                function myConcat(i, j, arr){
                    var str = "";
                    for(var k = i; k <= j; k++){
                        if(arr[k]){
                            if(k == i){
                                str+= arr[k];
                            }else{
                                str+=(";" + arr[k]);
                            }
                        }
                    }
                    return str;
                }
                var params = {};
                params.wifi_profile = wifi_profile;
                params.wifi_profile1 = wifi_profile1;
                params.wifi_profile2 = wifi_profile2;
                params.wifi_profile3 = wifi_profile3;
                params.wifi_profile4 = wifi_profile4;
                params.wifi_profile5 = wifi_profile5;
                params.wifi_profile_num = wifi_profile_num;
                if(isSort){
                }else{
                    params.wisprFlag = 1;
                }

                return params;

            }

            /**
             * SoftBank Spot密码显示事件
             *
             * @event showPasswordHandler
             */
            self.showPasswordHandler_sbm = function () {
                $("label[class='error']", "#frmSoftbankWifiSpot").hide();
                var checkbox = $("#showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showPassword(true);
                } else {
                    self.showPassword(false);
                }
            };

            /**
             * 获取搜到的热点列表
             * @method getSearchHotspot
             *
             */
            self.getSearchHotspot = function () {
                var count = 0;

                function search() {
                    var result = service.getSearchHotspotList();
                    if (result.scan_finish) {
                        self.apSearchList(fixHotspotList(result.hotspotList));
                        $("#scanList").translate();
                        hideLoading();
                    } else {
                        if (count <= 60) {
                            count = count + 1;
                            addTimeout(search, 1000);
                        } else {
                            hideLoading();
                            showAlert("ap_station_search_hotspot_fail");
                        }
                    }
                }

                showLoading('internet_wifi_scanning');
                service.searchHotspot({}, function (data) {
                    if (data && data.result == "success") {
                        search();
                    } else {
                        hideLoading();
                        showAlert("ap_station_search_hotspot_fail");
                    }
                });
            };

            self.updateSearchAPList = function(){
                service.getSearchHotspotListWithoutScanFinish({},function(result){
                    self.apSearchList(fixHotspotList(result.hotspotList));
                    $("#scanList").translate();
                });
            };


            /**
             * 刷新搜到的热点列表
             * @event searchHotspot
             *
             */
            self.searchHotspot = function () {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                self.getSearchHotspot();
            };

            /**
             * 打开添加页面
             * @event openAddPage
             *
             */
            self.openAddPage = function () {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                self.clear();
                self.pageState(self.page.add);
            };

            /**
             * 打开基本设置页面
             * @event openListPage
             *
             */
            self.openListPage = function () {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                self.clear();
                self.pageState(self.page.list);
                self.updateSearchAPList();
            };

            /**
             * 打开已添加热点列表页面
             * @event openAddListPage
             *
             */
            self.openAddListPage = function () {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                self.clear();
                self.getAddHotspot();
                self.pageState(self.page.addlist);

            };

            /**
             * 打开已添加热点编辑页面
             * @event openAddListEditPage
             *
             */
            openAddListEditPage = function (obj) {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                var index = obj.id.slice(14);
                editAPindex = index;
                var aplist = self.apAddList();
                var item = aplist[index];
                self.profileName(item.profileName);
                self.ssid(item.ssid);
                self.signal(item.signal);
                self.authMode(item.authMode);
                self.password(item.password);
                if (item.authMode == "WPAPSK" || item.authMode == "WPA2PSK" || item.authMode == "WPAPSKWPA2PSK") {
                    self.encryptType_WPA(item.encryptType);
                } else {
                    self.selectedencryptType(item.encryptType);
                }
                self.keyID(item.keyID);
                ssidSelect = item.ssid;
                self.pageState(self.page.edit);
            };

            /**
             * 清除编辑页面的信息
             * @event clear
             *
             */
            self.clear = function () {
                self.ssid("");
                self.authMode("OPEN");
                self.password("");
                self.selectedencryptType("NONE");
                self.encryptType_WPA("TKIPCCMP");
                self.keyID("0");
            };

            /**
             * 密码显示事件
             *
             * @event showPasswordHandler
             */
            self.showPasswordHandler = function () {
                $("#pwdWepKey").parent().find(".error").hide();
                $("#pwdWPAKey").parent().find(".error").hide();
                var checkbox = $("#showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showPassword(true);
                } else {
                    self.showPassword(false);
                }
            };

            /**
            * 获取添加的热点列表
            * @method getAddHotspot
                *
                */
            self.getAddHotspot = function() {
                var apList = service.getHotspotList();
                self.apAddList(fixHotspotList(apList.hotspotList));
                $("#addList").translate();
            };

            /**
             * 用户热点排序
             * @event wifiSpotSortNext
             *
             */
            wifiSpotSortNext = function (str) {
                hideLoading();
                var infor = service.getHotspotListSort();
                var allWifiProfile = infor.wifi_profile;
                allWifiProfile = mySmallFun(allWifiProfile, infor.wifi_profile1);
                allWifiProfile = mySmallFun(allWifiProfile, infor.wifi_profile2);
                allWifiProfile = mySmallFun(allWifiProfile, infor.wifi_profile3);
                allWifiProfile = mySmallFun(allWifiProfile, infor.wifi_profile4);
                allWifiProfile = mySmallFun(allWifiProfile, infor.wifi_profile5);
                wifi_profile_num = parseInt(infor.wifi_profile_num, 10);

                var connectIndex = -1;
                if($("#addList :radio[name='addListRadio']:checked").length==1){
                    connectIndex = $("#addList :radio[name='addListRadio']:checked").attr('id').slice(12);
                }

                var currentCheckedIndex = parseInt(connectIndex, 10);
                if(str == "next"){
                    allWifiProfile = changeOrderInGroup(allWifiProfile, currentCheckedIndex, "next");
                }else{
                    allWifiProfile = changeOrderInGroup(allWifiProfile, currentCheckedIndex, "previous");
                }
                var params = wifi_profile_sort(allWifiProfile, wifi_profile_num,true);
                service.setHotspotListSpan(params, function(data) {
                    if (data.result == "success") {
                        self.getAddHotspot();
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };

            function changeOrderInGroup(profiles, index, sort){
                var tempArr = profiles.split(";");
                var tempObj = "";
                if(sort == "previous"){
                    tempObj = tempArr[index];
                    tempArr[index] =tempArr[index-1];
                    tempArr[index-1] = tempObj;
                }else{
                    tempObj = tempArr[index];
                    tempArr[index] = tempArr[index+1];
                    tempArr[index+1] = tempObj;
                }
                var result= tempArr.join(";");
                return result;
            }

            /**
             * 添加热点
             * @event addHotspot
             *
             */
            self.addHotspot = function () {
                if(radarScaningCheck()){
                    return;
                }

                self.getAddHotspot();
                var SSIDAdd = self.ssid();
                var CurrentApList = self.apAddList();
                var CurrentApListSSIDList = [];
                for(i=0;i<CurrentApList.length;i++){
                    CurrentApListSSIDList.push(CurrentApList[i].ssid);
                }

                for(var i=0;i<CurrentApListSSIDList.length;i++){
                     if(SSIDAdd == CurrentApListSSIDList[i]
                    && (self.pageState() != self.page.edit
                    || (self.pageState() == self.page.edit) && i!=editAPindex)){
                         showAlert("alert_exist_spot");
                         return;
                     }
                }

                if (wifiClosedCheck()) {
                    return;
                }
                if (self.authMode() == "802.1xEAP") {
                    return;
                }
                var infor = service.getAPStationBasic();
                var configAP_STATION_LIST_LENGTH = config.AP_STATION_LIST_LENGTH;
                if (self.pageState() == self.page.add && self.apAddList().length >= configAP_STATION_LIST_LENGTH) { //当超出10个AP时，先删除优先级最低的AP，再进行添加
                    showLoading();
                    var para = {};
                    var deleteIndex = self.apAddList().length-1;
                    var currentCheckedIndex = parseInt(deleteIndex, 10);
                    para.apList = self.apAddList();
                    for(var i=deleteIndex;i>=0;i--){
                        if(para.apList[currentCheckedIndex].connectStatus == "1"){
                           currentCheckedIndex = i-1;
                        }else{
                            break;
                        }
                    }
                    if(currentCheckedIndex<0){
                        currentCheckedIndex = 0;
                    }
                    para.profileName = para.apList[currentCheckedIndex].profileName;
                    service.deleteHotspot(para, function (data) {
                        if(data.result == "success"){
                            var para = {};
                            var profileName = "";
                            if(addID!=-1){
                                profileName = self.apAddList()[addID].profileName;
                            }
                            para.profileNameInit = profileName ;
                            if(self.pageState() == self.page.edit){
                                para.profileName = profileName;
                            }else{
                                para.profileName = RndNum(4);
                            }

                            para.ssid = self.ssid();
                            para.signal = self.signal();
                            para.authMode = self.authMode();
                            para.password = self.password();
                            para.saveAddFlag = self.pageState();
                            if (para.authMode == "WPAPSK" || para.authMode == "WPA2PSK" || para.authMode == "WPAPSKWPA2PSK") {
                                para.encryptType = self.encryptType_WPA();
                            } else if (para.authMode == "SHARED") {
                                para.encryptType = "WEP";
                            } else {
                                para.encryptType = self.selectedencryptType();
                            }
                            para.keyID = self.keyID();
                            self.getAddHotspot();
                            para.apList = self.apAddList();
                            service.saveHotspot(para, function (data) {
                                self.callback(data, true);
                            });
                        }else{
                            errorOverlay();
                        }
                    });
                }else{
                    showLoading();
                    var para = {};
                    var profileName = "";
                    if(addID!=-1){
                        profileName = self.apAddList()[addID].profileName;
                    }
                    para.profileNameInit = profileName;
                    if(self.pageState() == self.page.edit){
                        para.profileName = profileName;
                    }else{
                        para.profileName = RndNum(4);
                    }
                    para.ssid = self.ssid();
                    para.signal = self.signal();
                    para.authMode = self.authMode();
                    para.password = self.password();
                    para.saveAddFlag = self.pageState();
                    if (para.authMode == "WPAPSK" || para.authMode == "WPA2PSK" || para.authMode == "WPAPSKWPA2PSK") {
                        para.encryptType = self.encryptType_WPA();
                    } else if (para.authMode == "SHARED") {
                        para.encryptType = "WEP";
                    } else {
                        para.encryptType = self.selectedencryptType();
                    }
                    para.keyID = self.keyID();
                    self.getAddHotspot();
                    para.apList = self.apAddList();
                    service.saveHotspot(para, function (data) {
                        self.callback(data, true);
                    });
                }
            };

            /*apSearchList中热点Connect功能
            * */
            self.addHotspot_for_scanList = function(actionAP){
                service.getAPStationBasic({},function(infor){
                    var configAP_STATION_LIST_LENGTH = config.AP_STATION_LIST_LENGTH;
                    if (self.apAddList().length >= configAP_STATION_LIST_LENGTH) {  //超出上限：先删除，后添加，再连接
                        showLoading();
                        var para = {};
                        var deleteIndex = self.apAddList().length-1;
                        var currentCheckedIndex = parseInt(deleteIndex, 10);
                        para.apList = self.apAddList();

                        if(currentCheckedIndex<0){
                            currentCheckedIndex = 0;
                        }
                        para.profileName = para.apList[currentCheckedIndex].profileName;
                        service.deleteHotspot(para, function (data) {
                            if(data.result == "success"){
                                var para = {};
                                var profileName = "";
                                if(addID!=-1){
                                    profileName = self.apAddList()[addID].profileName;
                                }
                                para.profileNameInit = profileName ;
                                para.profileName = RndNum(4);
                                para.ssid = actionAP.ssid;
                                para.signal = actionAP.signal;
                                para.authMode = actionAP.authMode;
                                para.password = inputContext;
                                para.saveAddFlag = '2';
                                if (para.authMode == "WPAPSK" || para.authMode == "WPA2PSK" || para.authMode == "WPAPSKWPA2PSK") {
                                    para.encryptType = actionAP.encryptType;
                                } else if (para.authMode == "SHARED") {
                                    para.encryptType = "WEP";
                                } else {
                                    para.encryptType = actionAP.encryptType;
                                }
                                para.keyID = (typeof currentKeyID == "undefined")? self.keyID() : currentKeyID;
                                self.getAddHotspot();
                                para.apList = self.apAddList();
                                service.saveHotspot(para, function (data) {
                                    self.connectHotspot(actionAP);
                                });
                            }else{
                                errorOverlay();
                            }
                        });
                    }else{       //未出上限：先添加，再连接
                        var para = {};
                        var profileName = "";
                        if(addID!=-1){
                            profileName = self.apAddList()[addID].profileName;
                        }
                        para.profileNameInit = profileName ;
                        para.profileName = RndNum(4);
                        para.ssid = actionAP.ssid;
                        para.signal = actionAP.signal;
                        para.authMode = actionAP.authMode;
                        para.password = inputContext;
                        para.saveAddFlag = '2';
                        if (para.authMode == "WPAPSK" || para.authMode == "WPA2PSK" || para.authMode == "WPAPSKWPA2PSK") {
                            para.encryptType = actionAP.encryptType;
                        } else if (para.authMode == "SHARED") {
                            para.encryptType = "WEP";
                        } else {
                            para.encryptType = actionAP.encryptType;
                        }
                        para.keyID = (typeof currentKeyID == "undefined")? self.keyID() : currentKeyID;
                        self.getAddHotspot();
                        para.apList = self.apAddList();
                        service.saveHotspot(para, function (data) {
                            self.connectHotspot(actionAP);
                        });
                    }
                });
            };

            /**
             * 删除热点
             * @event deleteHotspot
             *
             */
            deleteHotspot = function () {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                showConfirm("confirm_data_delete", function () {
                    var para = {};

                    var deleteIndex = -1;
                    if($("#addList :radio[name='addListRadio']:checked").length==1){
                        deleteIndex = $("#addList :radio[name='addListRadio']:checked").attr('id').slice(12);
                    }
                    var currentCheckedIndex = parseInt(deleteIndex, 10);
                    self.getAddHotspot();
                    para.apList = self.apAddList();
                    para.profileName = para.apList[currentCheckedIndex].profileName;
                    var apdisconnectFlag = true;
                    if(para.apList[currentCheckedIndex].connectStatus == "1"){
                        apdisconnectFlag = false;
                        showAlert("ap_station_update_fail");
                    }
                    if(apdisconnectFlag == true){
                        showLoading();
                        service.deleteHotspot(para, function (data) {
                            self.getAddHotspot();
                            self.callback(data, false);
                        });
                    }
                });
            };

            /**
             * 计算并设置当前连接和按钮的状态
             * @method computeConnectStatus
             *
             */
            self.computeButtonStatus = function () {
                //对AddList列表的按钮控制
                addID = -1;
                if(self.apAddList().length>0){
                    if($("#addList :radio[name='addListRadio']:checked").length==1){
                        addID = $("#addList :radio[name='addListRadio']:checked").attr('id').slice(12);
                    }else{
                        addID = -1;
                    }
                }
                if(addID == -1){
                    $('#addListDiv input[type="button"]').removeAttr('enabled').attr('disabled','true');
                }else{
                    $('#addListDiv input[type="button"]').removeAttr('enabled').attr('disabled','true');
                    $('#addListBtnEdit'+addID).removeAttr('disabled').attr('enabled','true');
                    $('#addListBtnDel'+addID).removeAttr('disabled').attr('enabled','true');
                    if($("#addList :radio[name='addListRadio']").length>1){
                        if(addID==0){
                            $('#btnPrevious').removeAttr('disabled').attr('enabled','true');
                        }else if(addID==$("#addList :radio[name='addListRadio']").length-1){
                            $('#btnnext_step').removeAttr('disabled').attr('enabled','true');
                        }else{
                            $('#btnnext_step').removeAttr('disabled').attr('enabled','true');
                            $('#btnPrevious').removeAttr('disabled').attr('enabled','true');
                        }
                    }
                }
                $('#addCancel').removeAttr('disabled').attr('enabled','true');
            };


            /**
             * 断开连接
             * @event 断开连接
             *
             */
            self.disconnectHotspot = function () {
                showLoading('disconnecting');
                service.disconnectHotspot({}, function (data) {
                    self.callback(data, true);
                })
            };

            /**
             * 连接热点
             * @event connectHotspot
             *
             */
            self.connectHotspot = function (actionAP) {
                if(radarScaningCheck()){
                    return;
                }

                if (wifiClosedCheck()) {
                    return;
                }
                self.getAddHotspot();
                var addIndex = -1;
                for(var i=0;i<self.apAddList().length;i++){
                    if(actionAP.ssid == self.apAddList()[i].ssid  && actionAP.authMode == self.apAddList()[i].authMode && actionAP.encryptType == self.apAddList()[i].encryptType){
                        addIndex = i;
                        break;
                    }
                }
                var addAPList = "";
                var profileName = "";
                if(addIndex!=-1){
                    addAPList = self.apAddList()[addIndex];
                }
                profileName = addAPList.profileName;

                function connect() {
                    showLoading("connecting");
                    var para = {};
                    para.EX_SSID1 = addAPList.ssid;
                    para.EX_AuthMode = addAPList.authMode;
                    para.EX_EncrypType = addAPList.encryptType;
                    para.EX_DefaultKeyID = addAPList.keyID;
                    para.EX_WEPKEY = addAPList.password;
                    para.EX_WPAPSK1 = addAPList.password;
                    para.EX_wifi_profile = addAPList.profileName;

                    service.connectHotspot(para, function (data) {
                        if (data && data.result == "success") {
                            //有时会出现取得的状态不是最新的，所以延迟检测状态
                            addTimeout(checkWifiStatus, 3000);
                        } else {
                            hideLoading();
                            errorOverlay();
                        }
                    });
                }

                var count = 0;
                function checkWifiStatus() {
                    count = count + 1;
                    if (count > 60) {
                        hideLoading();
                        errorOverlay();
                        return;
                    }

                    var status = service.getStatusInfo();
                    if (status.connectWifiStatus == "connecting" || status.connectWifiStatus == "disconnect" ) {
                        addTimeout(checkWifiStatus, 1000);
                    } else if (status.connectWifiStatus == "connect") {
                        self.updateSearchAPList();
                        successOverlay();
                    } else {
                        hideLoading();
                        errorOverlay();
                    }
                }

                if(addIndex == -1){
                    errorOverlay();
                }else{
                    var status = service.getStatusInfo();
                    if (status.connectStatus == "ppp_connecting" || checkConnectedStatus(status.connectStatus)) {
                        showConfirm("ap_station_connect_change_alert", function () {
                            showLoading('connecting');
                            service.disconnect({}, function (data) {
                                if (data.result) {
                                    connect();
                                } else {
                                    errorOverlay();
                                }
                            })
                        });
                    } else {
                        connect();
                    }
                }
            };

            /**
             * 和服务器交互时的回调
             * @event callback
             *
             */
            self.callback = function (data, isInitPage) {
                if (data) {
                    if (isInitPage) {
                        self.openListPage();
                        init(self);
                        $("#apList").translate();
                    }
                    if (data.result == "success") {
                        successOverlay();
                    } else if (data.result == "spot_connecting" || data.result == "spot_connected") {
                        showAlert("ap_station_update_fail");
                    } else {
                        errorOverlay();
                    }
                } else {
                    errorOverlay();
                }
            };

            self.checkSettings = function (ssid) {
                var wifi_dfs_status = service.getStatusInfo().wifi_dfs_status;
                if(wifi_dfs_status == '1'){
                    showAlert('cannot_set_when_radar_scaning');
                    return true;
                }

                var status = service.getWpsInfo();
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return true;
                }

                return false;
            };

            self.setMultiSSIDSwitch = function () {
                if (self.checkSettings("switch")) {
                    return;
                }

                var dirverCount = 0;
                function checkWifiDirver() {
                    service.getWpsInfo({},function(data){
                        if (data.radioFlag=='0' || data.radioFlag=='1') {
                            successOverlay();
                            clearTimer();
                            clearValidateMsg();
                            init(self);
                        } else {
                            if (dirverCount <= 20) {
                                dirverCount = dirverCount + 1;
                                addTimeout(function(){
                                    checkWifiDirver();
                                }, 2000);
                            } else {
                                successOverlay();
                                clearTimer();
                                clearValidateMsg();
                                init(self);
                            }
                        }
                    })
                }

                var setSwitch = function () {
                    var setSwitchIn = function() {
                        showLoading();
                        var params = {};
                        params.m_ssid_enable = self.multi_ssid_enable();
                        if(config.WIFI_SWITCH_SUPPORT) {
                            params.wifiEnabled = self.wifi_enable();
                        }
                        service.setWifiBasicMultiSSIDSwitch(params, function (result) {
                            if (result.result == "success") {
                                setTimeout(function () {
                                    if (isWifi) {
                                        successOverlay();
                                        setTimeout(function () {
                                            window.location.reload();
                                        }, 1000);
                                    } else {
                                        setTimeout(function(){
                                            checkWifiDirver();
                                        },2000);
                                    }
                                }, isWifi ? 15000 : 0);
                            } else {
                                errorOverlay();
                            }
                        });
                    }
                    if(self.isUfi() && service.getStatusInfo().wifi_onoff_func_control == "1" && self.wifi_enable() == "0"){
                        showConfirm("wifi_off_alert", function () {
                            setSwitchIn();
                        });
                    }else{
                        setSwitchIn();
                    }
                };

                var checkAlertCloseAP = function(){
                    if (self.multi_ssid_enable() == "1" && self.wifi_enable() == "1") {
                        var info = service.getAPStationBasic();
                        if (config.AP_STATION_SUPPORT && info.ap_station_enable == "1") {
                            showConfirm("multi_ssid_enable_confirm", function () {
                                setSwitch();
                            });
                        } else {
                            setSwitch();
                        }
                    } else {
                        setSwitch();
                    }
                }

                if(self.origin_wifi_enable == "1" && self.wifi_enable() == "1" && config.HAS_MULTI_SSID){
                    showConfirm("wifi_disconnect_confirm", function () {
                        checkAlertCloseAP();
                    });
                } else {
                    checkAlertCloseAP();
                }
            };
         }

        /**
         * 检测wifi是否关闭，关闭时提示
         * @method callback
         *
         */
        function wifiClosedCheck() {
            var info = service.getWpsInfo();
            if (info.radioFlag == "0") {
                showAlert('wps_wifi_off');
                return true;
            }

            if (info.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }
        }

        /**
         * 检测5G Radar是否在Scaning
         * @method callback
         *
         */
        function radarScaningCheck() {
            var wifi_dfs_status = service.getStatusInfo().wifi_dfs_status;
            if(wifi_dfs_status == '1'){
                showAlert('cannot_set_when_radar_scaning');
                return true;
            }
        }

        /**
         * 处理热点列表内容，以便在表格显示
         * @method callback
         *
         */
        function fixHotspotList(list) {
            var fixedList = [];
            for (var i = 0; i < list.length; i++) {
                var imageUrl = "";
                if (list[i].connectStatus == "1") {
                    if (list[i].authMode.toLowerCase() == "open" && list[i].encryptType.toLowerCase() == "none") {
                        imageUrl = "img/wifi_connected.png";
                    } else {
                        imageUrl = "img/wifi_lock_connected.png";
                    }
                } else {
                    if (list[i].authMode.toLowerCase() == "open" && list[i].encryptType.toLowerCase() == "none") {
                        imageUrl = "img/wifi_signal_" + list[i].signal + ".png";
                    } else {
                        imageUrl = "img/wifi_lock_signal_" + list[i].signal + ".png";
                    }
                }
                list[i].imgSignal = imageUrl;
                if(list[i].authMode == "802.1xEAP"){
                    list[i].authMode_show = "802.1xEAP";
                }else{
                    list[i].authMode_show = $.i18n.prop("ap_station_security_mode_" + list[i].authMode );
					if (list[i].authMode.toLowerCase() == "open" && list[i].encryptType.toLowerCase() == "wep" || list[i].authMode.toLowerCase() == "shared") {
						list[i].authMode_show = $.i18n.prop("ap_station_security_mode_WEP");
					} 
                }
                list[i].index = i;
            }
            return list;
        }

        function checkConnectedDevice(){
            service.getParams({nv: 'user_ip_addr'}, function (dataIp) {
                service.getParams({nv: 'station_list'}, function (dataList) {
                    isWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
                });
            });
        }

        /*随机生成指定位数的随机数
        * */
        function RndNum(n){
            var rnd="";
            for(var i=0;i<n;i++){
                rnd+=Math.floor(Math.random()*10);
            }
            return rnd;
        }

        /*检查连接AP时输入的热点是否正确
        * */
        function checkPassword(pwd,actionAP){
            var flag = true;
            if($.trim(pwd)==""){
                flag = "login_password_required";
            } else if (actionAP.authMode == "WPAPSK" || actionAP.authMode == "WPA2PSK" || actionAP.authMode == "WPAPSKWPA2PSK") {
                    var result = /^([0-9A-Fa-f]{8,64}|[0-9a-zA-Z!#\(\)\-\.\/=@\^_\{|\}~ ]{8,63})$/.test(pwd);
                    if(result == false){
                        flag = 'wifi_password_check';
                    }
            } else if (actionAP.authMode == "SHARED" || actionAP.encryptType == 'WEP') {
                    var result =/^([0-9A-Fa-f]{10}|[0-9A-Fa-f]{26}|[0-9a-zA-Z!#\(\)\+\-\.\/%=\?@\^_\{|\}~ ]{5}|[0-9a-zA-Z!#\(\)\+\-\.\/%=\?@\^_\{|\}~ ]{13})$/.test(pwd);
                    if(result == false){
                        flag = 'wifi_wep_password_check';
                    }
            }
            return flag;
        }

        /**
         * 初始化ViewModel并进行绑定
         * @method init
         */
        function init(vm) {
            if (vm){
                var info = service.getAPStationBasic();
                vm.origin_ap_station_enable = info.ap_station_enable;
                vm.ap_station_enable(info.ap_station_enable);
				vm.ap_station_enable_show(info.ap_station_enable);
                var basicInfo = service.getWifiBasic();
                vm.wifi_enable(basicInfo.wifi_enable);
                vm.isShowSSIDInfoDiv(false);
                if(config.WIFI_SWITCH_SUPPORT) {
                    if(basicInfo.wifi_enable == "1") {
                        vm.isShowSSIDInfoDiv(true);
                    } else {
                        vm.isShowSSIDInfoDiv(false);
                    }
                } else {
                    vm.isShowSSIDInfoDiv(true);//如果不支持软开关，整个SSID信息块显示
                }
                vm.multi_ssid_enable(basicInfo.multi_ssid_enable);
            }else{
                var container = $('#container')[0];
                ko.cleanNode(container);
                vm = new apModel();
                ko.applyBindings(vm, container);
                addTimeout(function(){
                    checkConnectedDevice();
                }, 600);

                $("#apList").translate();

                $('#frmWifiSwitch').validate({
                    submitHandler:function () {
                        vm.setMultiSSIDSwitch();
                    }
                });

                $('#frmAdd').validate({
                    submitHandler:function(){
                        vm.addHotspot();
                    },
                    rules:{
                        txtSSID:'ap_ssid',
                        pwdWepKey:'wifi_wep_password_check',
                        txtWepKey:'wifi_wep_password_check',
                        pwdWPAKey:'wifi_password_check',
                        txtWPAKey:'wifi_password_check'
                    },
                    errorPlacement: function(error, element) {
                        if(element.attr("name") == "pwdWepKey"||element.attr("name") == "txtWepKey") {
                            error.insertAfter("#lblshowWEPPassword");
                        }else if(element.attr("name") == "pwdWPAKey"||element.attr("name") == "txtWPAKey") {
                            error.insertAfter("#lblshowWPAPassword");
                        }else{
                            error.insertAfter(element);
                        }
                    }
                });

                connectAction = function(obj){
                    if(radarScaningCheck()){
                        return;
                    }

                    if (wifiClosedCheck()) {
                        return;
                    }

                    showLoading('connecting');
                    service.disconnectHotspot({}, function (data) {
                        if (data.result == "success") {
                            var index = obj.id.slice(14);
                            var actionAP = vm.apSearchList()[index];
                            vm.getAddHotspot();
                            var addAPList = vm.apAddList();
                            var needAddFlag = true;
                            var AddIndex = -1;
                            $.each(addAPList,function(i,n){
                                if(n.ssid==actionAP.ssid && n.authMode == actionAP.authMode && n.encryptType == actionAP.encryptType){
                                    needAddFlag = false;
                                    AddIndex = i;
                                    return false;
                                }
                            });
                            if(needAddFlag){     //未在已添加热点列表中
                                if(!(actionAP.authMode == "OPEN" && actionAP.encryptType =="NONE")){
                                    var select = '';
                                    if(actionAP.authMode == "SHARED" || actionAP.encryptType =="WEP") {
                                        select = '<div class="margin-bottom-10"><label for="current_key_id" style="padding-left: 3px;" data-trans="ap_station_wep_default_key"></label>&nbsp;<select class="form-control" id="current_key_id" name="current_key_id">' +
                                            '<option value="0" data-trans="ap_station_wep_key_0"></option>' +
                                            '<option value="1" data-trans="ap_station_wep_key_1"></option>' +
                                            '<option value="2" data-trans="ap_station_wep_key_2"></option>' +
                                            '<option value="3" data-trans="ap_station_wep_key_3"></option>' +
                                            '</select></div>';
                                    }

                                    var temp = "valueUpdate:'keypress'";
                                    temp = select + '<div><label for="current_pin_sbm" style="padding-left: 14px;" data-trans="password"></label>&nbsp;<input class="form-control" id="current_pin_sbm" name="current_pin_sbm" type="text" data-bind='+temp+'></div>';
                                    var msg = {};
                                    $.extend(msg, {
                                        title : 'enter_password',
                                        img:'',
                                        msg : temp
                                    });
                                    showConfirm_sbm(msg,function(){
                                        var flag = checkPassword(inputContext,actionAP);
                                        if(flag == true){
                                            vm.addHotspot_for_scanList(actionAP);
                                        }else{
                                            showAlert(flag);
                                        }

                                    });
                                }else{
                                    vm.addHotspot_for_scanList(actionAP);
                                }

                            }else{  //已在已添加热点列表中
								addTimeout(function(){
									vm.connectHotspot(actionAP);
								}, 1000);
                            }
                        }else {
                            errorOverlay();
                        }
                    })
                };

                disconnectAction = function(obj){
                    if(radarScaningCheck()){
                        return;
                    }

                    if (wifiClosedCheck()) {
                        return;
                    }

                    vm.disconnectHotspot();
                };

                if(vm.ap_station_enable()==1){
                    vm.updateSearchAPList();
                }

                function refreshPage(initPage,vm){
                    $('#addList').translate();
                    vm.computeButtonStatus();

                    service.getSearchHotspotListWithoutScanFinish({},function(result){
                        var list = fixHotspotList(result.hotspotList);
                        if($('#scanList img').length == list.length){
                            for(var i=0; i<list.length;i++){
                                $( $('#scanList img')[i]).attr('src',list[i].imgSignal);
                            }
                        }

                        if (vm.apSearchList().length != list.length) {
                            vm.apSearchList(list);
                            $('#scanList').translate();
                        } else {
                            for (var i = 0; i < list.length; i++) {
                                var item1 = _.clone(list[i]);
                                var item2 = _.clone(vm.apSearchList()[i]);
                                delete item1.signal;
                                delete item1.imgSignal;
                                delete item2.signal;
                                delete item2.imgSignal;
                                if (!(_.isEqual(item1, item2))) {
                                    vm.apSearchList(list);
                                    $('#scanList').translate();
                                    break;
                                }
                            }
                        }
                    });
                }
                refreshPage(true,vm);
                clearTimer();
                addInterval(function () {
                    refreshPage(false,vm);
                }, 1000);
            }
        }

        /* Station IP校验相关函数
         * */
        $.validator.addMethod("subnetmask_check", function (value, element, param) {
            var result = validateNetmask(value);
            return this.optional(element) || result;
        });

        $.validator.addMethod("gateWay_check", function (value, element, param) {
            var result = validate_gateWay_check();
            return result;
        });

        $.validator.addMethod("prefer_dns_manual_check", function (value, element, param) {
            var result = validate_prefer_dns_manual_check();
            return result;
        });

        $.validator.addMethod("standby_dns_manual_check", function (value, element, param) {
            var result = validate_standby_dns_manual_check();
            return result;
        });

        var regExp = /^((1?\d?\d|(2([0-4]\d|5[0-5])))\.){3}(1?\d?\d|(2([0-4]\d|5[0-5])))$/;
        function validate_lanip_check(){
            if(regExp.test($("#sta_static_ip_addr").val()) == false){
                return false;
            }
            return true;
        }

        //from 4.0
        function validateNetmask(netmask) {
            var array = new Array();
            array = netmask.split(".");

            if (array.length != 4)
            {
                return false;
            }

            array[0] = parseInt(array[0], 10);
            array[1] = parseInt(array[1], 10);
            array[2] = parseInt(array[2], 10);
            array[3] = parseInt(array[3], 10);

            if (array[3] != 0)
            {
                if (array[2] != 255 || array[1] != 255 || array[0] != 255)
                {
                    return false;
                }
                else
                {
                    if (!isNetmaskIPValid(array[3]))
                    {
                        return false;
                    }
                }
            }

            if (array[2] != 0)
            {
                if (array[1] != 255 || array[0] != 255)
                {
                    return false;
                }
                else
                {
                    if (!isNetmaskIPValid(array[2]))
                    {
                        return false;
                    }
                }
            }

            if (array[1] != 0)
            {
                if (array[0] != 255)
                {
                    return false;
                }
                else
                {
                    if (!isNetmaskIPValid(array[1]))
                    {
                        return false;
                    }
                }
            }
            if(array[0]!=255)
            {
                return false;
            }
            if ( "0.0.0.0" == netmask || "255.255.255.255" == netmask)
            {
                return false;
            }

            return true;
        }
        function isNetmaskIPValid(ip) {
            if (ip == 255 || ip == 254 || ip == 252 || ip == 248
                || ip == 240 || ip == 224 || ip == 192 || ip == 128 || ip == 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        function validate_gateWay_check(){
            if(regExp.test($("#sta_static_ip_gw").val()) == false || (myConcat($("#sta_static_ip_addr").val(), $("#sta_static_ip_mask").val()) !== myConcat($("#sta_static_ip_gw").val(), $("#sta_static_ip_mask").val()))){
                return false;
            }
            return true;
        }
        function validate_prefer_dns_manual_check(){
            if($.trim($("#sta_static_ip_dns1").val()) == ""){
                return true;
            }
            else if(regExp.test($("#sta_static_ip_dns1").val()) == false){
                return false;
            }
            return true;
        }
        function validate_standby_dns_manual_check(){
            if($.trim($("#sta_static_ip_dns2").val()) == ""){
                return true;
            }
            else if($.trim($("#sta_static_ip_dns2").val())!= "" && !regExp.test($("#sta_static_ip_dns2").val())){
                return false;
            }
            return true;
        }

        function myConcat(ip1,ip2){
            var result = [];
            var iplArr = ip1.split(".");
            var ip2Arr = ip2.split(".");
            for(var i = 0; i < iplArr.length;i++){
                result[i] = (iplArr[i] & ip2Arr[i]);
            }
            return result.join(".");
        }

        return {
            init:init
        }
    });
