/**
 * 关机模块
 * @module restart
 * @class restart
 */

define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

	function ($, ko, config, service, _) {
		/**
		 * RestartVM
		 * @class RestartVM
		 */
		function ShutdownVM() {
			var self = this;
			/**
			 * 关机
			 * @event shutdown
			 */
			self.shutdown = function () {

				showConfirm("shutdown_confirm", function () {
					showLoading("processing");
					service.shutdown({}, function (data) {
						if (data && data.result == "success") {
							successOverlay();
						} else {
							errorOverlay();
						}
					}, $.noop);
				});
			}
		}

		/**
		 * 初始化 ViewModel，并进行绑定
		 * @method init
		 */
		function init() {
			var vm = new ShutdownVM();
			ko.applyBindings(vm, $('#container')[0]);

			$('#frmShutdown').validate({
				submitHandler:function () {
					vm.shutdown();
				}
			});
		}

		return {
			init:init
		}
	});
