#!bin/sh

wan_if=`cfg get current_wan_interface`

static_rule_init()
{
    for index in `seq 0 9`
    do
        echo "index:"$index
        static_route_rule=$(cfg get static_route_rule_$index)
        echo "static_route_rule:"$static_route_rule
        if [ -n "$static_route_rule" ]; then
            type=`echo $static_route_rule | awk -F ',' '{print $1}'`
            if [ "$type" = "0" ]; then
                ip_addr=`echo $static_route_rule | awk -F ',' '{print $2}'`
                if [ -z $ip_addr ]; then
                    echo "ip addr is empty, please check it!"
                else
                    route add -host $ip_addr dev $wan_if
                fi
            elif [ "$type" = "1" ]; then
                ip_addr=`echo $static_route_rule | awk -F ',' '{print $2}'`
                netmask=`echo $static_route_rule | awk -F ',' '{print $3}'`
                if [ -n "$ip_addr" -a -n "$netmask" ]; then
                    route add -net $ip_addr netmask $netmask dev $wan_if
                fi
            fi
        fi
    done
}

add_static_rule()
{
    if [ "$1" = "0" ]; then
        if [ -z "$2" ]; then
            echo "ip addr is empty, please check it!"
        else
            route add -host $2 $wan_if
        fi
    elif [ "$1" = "1" ]; then
        if [ -n "$2" -a -n "$3" ]; then
            route add -net $2 netmask $3 dev $wan_if
        else
            echo "input param fmt error"
        fi
    fi
}

del_static_rule()
{
    if [ "$1" = "0" ]; then
        if [ -z "$2" ]; then
            echo "ip addr is empty, please check it!"
        else
            route del -host $2 $wan_if
        fi
    elif [ "$1" = "1" ]; then
        if [ -n "$2" ]&&[ -n "$3" ]; then
            route del -net $2 netmask $3 dev $wan_if
        else
            echo "input param fmt error"
        fi
    fi
}


if [ "$1" = "add" ]; then
    add_static_rule $2 $3 $4
elif [ "$1" = "del" ]; then
    del_static_rule $2 $3 $4
elif [ "$1" = "init" ]; then
    static_rule_init
else
    echo "error input param"
fi