function pageInit() {
    util.showLoading();
    var data = service.getBasicStatus();
    util.translate(data.Language);
    if (!util.isLoggedIn()) {
        return;
    }
    if (!util.isSIMCardOK()) {
        return;
    }
    $("body").show();
    $("#imgSignal").attr("src", showEVDOsts(data));
    $("#imgBattery").attr("src", showBatteryStatus(data));
    $("#spanSSID").text(data.SSID1);
    var auth = showAuthMode(data, true);
    $("#spanSSIDSecurity").text(auth.encryption);
    if (auth.noEncrypt) {
        $("#liSSIDKey").hide();
    } else {
        $("#spanSSIDkey").text(auth.password);
        $("#ssidKeyName").text(auth.keyName);
    }
    if (data.m_ssid_enable == "1") {
        $("#spanSSID2").text(data.m_SSID);
        var m_auth = showAuthMode(data, false);
        $("#spanSSID2Security").text(m_auth.encryption);
        if (m_auth.noEncrypt) {
            $("#liSSID2Key").hide();
        } else {
            $("#spanSSID2key").text(m_auth.password);
            $("#ssid2KeyName").text(m_auth.keyName);
        }
    } else {
        $("#liSSID2").hide();
        $("#liSSID2Security").hide();
        $("#liSSID2Key").hide();
    }
    $("#spanVersion").text(data.wa_inner_version);
    util.hideLoading();

    window.setInterval("refreshInfo()", 1000);
}

function refreshInfo(){
    var data = service.getBasicStatus();
    $("#imgSignal").attr("src", showEVDOsts(data));
    var oldImg = $("#imgBattery").attr("src").toLowerCase();
    var newImg = showBatteryStatus(data).toLowerCase();
    if (oldImg != newImg) {
        $("#imgBattery").attr("src", newImg);
    }
}

function showBatteryStatus(data) {
    var src = "";
    if ("1" == data.battery_charging) {
        src = "img/battery_charging.gif";
    }
    else if ("0" == data.battery_charging) {
        if ("1" == data.battery_pers) {
            src = "img/battery_one.png";
        }
        else if ("2" == data.battery_pers) {
            src = "img/battery_two.png";
        }
        else if ("3" == data.battery_pers) {
            src = "img/battery_three.png";
        }
        else if ("4" == data.battery_pers) {
            src = "img/battery_full.png";
        }
        else if ("5" == data.battery_pers || "0" == data.battery_pers) {
            src = "img/battery_out.png";
        }
    }
    return src;

}

function showEVDOsts(data) {
    var signal = parseInt(data.signalbar);
    var network_type = data.network_type.toLowerCase();
    var modem_main_state = data.modem_main_state;
    if (( "" == $.trim(network_type) ) || ( "no service" == network_type) || ( "limited service" == network_type) || "modem_sim_undetected" == modem_main_state || "modem_waitpin" == modem_main_state || "modem_waitpuk" == modem_main_state) {
        return "img/4.png";
    }
    var src;
    switch (signal) {
        case 0:
            src = "img/4.png";
            break;
        case 1:
            src = "img/5.png";
            break;
        case 2:
            src = "img/6.png";
            break;
        case 3:
            src = "img/7.png";
            break;
        case 4:
            src = "img/8.png";
            break;
        case 5:
            src = "img/9.png";
            break;
        default:
            src = "img/4.png";
    }
    return src;
}

function showAuthMode(data, isSSID1) {
    var encryptType;
    var encryption;
    if (isSSID1) {
        encryptType = data.AuthMode;
        encryption = data.EncrypType;
    } else {
        encryptType = data.m_AuthMode;
        encryption = data.m_EncrypType;
    }
    var authMode;
    var password;
    var keyName;
    if ((encryptType == "OPEN") && (encryption == "NONE")) {
        authMode = $.i18n.prop('Encryption_Mode_NO');
        return {noEncrypt:true, encryption:authMode, password:password};
    }
    else {
        if (encryptType == "OPEN") {
            authMode = "OPEN WEP";
        }
        else if (encryptType == "SHARED") {
            authMode = "SHARED";
        }
        else if (encryptType == "WPAPSK") {
            authMode = "WPA-PSK";
        }
        else if (encryptType == "WPA2PSK") {
            authMode = "WPA2-PSK";
        }
        else if (encryptType == "WPAPSKWPA2PSK") {
            authMode = "WPA-PSK/WPA2-PSK";
        }
        else {
            authMode = $.i18n.prop("Unknown");
        }
    }

    if (encryptType == "OPEN" || encryptType == "SHARED") {
        var index = parseInt(data.DefaultKeyID, 10) + 1;
        password = data["Key" + String(index) + "Str1"];
        keyName = $.i18n.prop("Network_Key");
    } else {
        password = data.WPAPSK1;
        keyName = $.i18n.prop("WPA_Key");
    }
    return {noEncrypt:false, keyName:keyName, encryption:authMode, password:password};
}



