#!/bin/sh
# zte_debug.sh
# create by zhangzhen10130148 2017.3.22

logpath="/logfs"
conf_file="/logfs/debug_conf/TBox.debug"
system_status_log="/logfs/system_status"

cfg set zte_debug_done="0"
#==============compress and uncompress debug_conf folder============================================
compress_password=`cfg get compress_password`
if [ "$compress_password" = "" ] ; then
   echo "compress_password is NULL, set the default compress_password 20170417"
   compress_password="20170417"
fi

if [ "$1" = "compress" ] ; then
    if [ -d "$logpath/debug_conf" ] ;then
	    cd $logpath
		tar -zcvf - debug_conf|openssl des3 -salt -k $compress_password | dd of=debug_conf.des3
	else
	    echo "no debug_conf folder"
    fi	
    cfg set zte_debug_done="1"
    cfg save
	exit
fi


rm -rf $logpath/debug_conf

cd $logpath
dd if=debug_conf.des3 |openssl des3 -d -k $compress_password |tar zxf -

if [ ! -d "$logpath/debug_conf" ] ; then
    echo "uncompress fail,exit"
    cfg set zte_debug_done="1"
    cfg save
	exit
fi
#==========reset_compress_password=======================================================================
reset_compress_password_option=`cat $conf_file |grep reset_compress_password=`
if [ -n "$reset_compress_password_option" ] ; then
	compress_password=${reset_compress_password_option#*=}
    cfg set compress_password=$compress_password
	cfg save
fi
#=============set syslog level==========================================================================
syslog_mode_option=`cat $conf_file |grep syslog_mode=`
if [ -n "$syslog_mode_option" ] ; then
	syslog_mode=${syslog_mode_option#*=}
	if [ "$syslog_mode" = 0 ] ; then
		syslog_path=`cfg get syslog_path`
		syslog_size=`cfg get syslog_size`
		syslog_level=`cfg get syslog_level`
		
		syslog_level_option=`cat $conf_file |grep syslog_level=`
		if [ -n "$syslog_level_option" ] ; then
		syslog_level=${syslog_level_option#*=}
		fi

		syslog_size_option=`cat $conf_file |grep syslog_size=`
		if [ -n "$syslog_size_option" ] ; then
			syslog_size=${syslog_size_option#*=}
		fi
		
		sh /usr/zte/zte_conf/scripts/zte_syslog.sh -L -o $syslog_path -l $syslog_level -s $syslog_size &
		
		syslog_comp_option=`cat $conf_file |grep syslog_comp_switch=`
		if [ -n "$syslog_comp_option" ] ; then
			syslog_comp_file_num_option=`cat $conf_file |grep syslog_comp_file_num=`
			if [ -n "$syslog_comp_file_num_option" ] ; then	
				syslog_comp_file_num=${syslog_comp_file_num_option#*=}
				 cfg set logcomp_file_num=$syslog_comp_file_num
				cfg save
			fi	

			syslog_comp_switch=${syslog_comp_option#*=}
			if [ "$syslog_comp_switch" = "on" ] ; then
				killall -9 zte_topsw_logcomp
				zte_topsw_logcomp &
			fi
		fi
	elif [ "$syslog_mode" = 1 ] ; then
		killall syslogd
		client_ipaddr=`arp -n | awk 'NR==1 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
		if [ "$client_ipaddr" == "" ] ; then
			client_ipaddr="192.168.225.153"
		fi
		sleep 6 && syslogd -R $client_ipaddr &
	fi
fi	
#============set over wifi qxdm log==========================================================================
over_wifi_qxdm_option=`cat $conf_file |grep over_wifi_qxdm_switch=`
if [ -n "$over_wifi_qxdm_option" ] ; then
	over_wifi_qxdm=${over_wifi_qxdm_option#*=}
	if [ "$over_wifi_qxdm" = "on" ] ; then
	    port="2500"	
	
		client_ipaddr_option=`cat $conf_file |grep over_wifi_qxdm_client_ipaddr=`
		if [ -n "$client_ipaddr_option" ] ; then
		    client_ipaddr=${client_ipaddr_option#*=}
		else
			client_ipaddr=`arp -n | awk 'NR==1 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
			if [ "$client_ipaddr" == "" ] ; then
				client_ipaddr="192.168.225.153"
			fi
		fi
	    port_option=`cat $conf_file |grep over_wifi_qxdm_port=`
		if [ -n "$port_option" ] ; then
		    port=${port_option#*=}
		fi
	
		sh /usr/zte/zte_conf/scripts/diaglog_set.sh $client_ipaddr $port &
	elif [ "$over_wifi_qxdm" = "off" ] ; then
		killall -9 diag_socket_log 
	fi

fi
#============set on device qxdm log==========================================================================
qxdm_log_option=`cat $conf_file |grep on_device_qxdm_switch=`
if [ -n "$qxdm_log_option" ] ; then
	on_device_qxdm_switch=${qxdm_log_option#*=}
	if [ "$on_device_qxdm_switch" = "on" ] ; then
		qxdm_log_size=10
		qxdm_log_file_num=2
		if [ ! -d "/logfs/qxdm" ] ; then
			mkdir $logpath/qxdm
		fi
        qxdm_log_size_option=`cat $conf_file |grep on_device_qxdm_size=`
		if [ -n "$qxdm_log_size_option" ] ; then
			qxdm_log_size=${qxdm_log_size_option#*=}
		fi
		
        qxdm_log_file_num_option=`cat $conf_file |grep on_device_qxdm_file_num=`
		if [ -n "$qxdm_log_file_num_option" ] ; then
			qxdm_log_file_num=${qxdm_log_file_num_option#*=}
		fi
		
		if [ -f "$logpath/debug_conf/Diag.cfg" ] ; then
			cp $logpath/debug_conf/Diag.cfg $logpath/qxdm

			#killall zte_topsw_logcomp
			killall -9 diag_socket_log 
			killall diag_mdlog 
			sleep 3
			
			diag_mdlog -o /logfs/qxdm/qxdm_log -n $qxdm_log_file_num -s $qxdm_log_size &
			
			#sleep 1
			#zte_topsw_logcomp &
		else
			echo "please put the Diag.cfg file in the debug_conf folder"
		fi
				
	elif [ "$on_device_qxdm_switch" = "off" ] ; then
		killall diag_mdlog 
		rm -rf /logfs/qxdm/qxdm_log
	fi
fi
#==========reboot=========================================================================================
reboot_option=`cat $conf_file |grep reboot=`
if [ -n "$reboot_option" ] ; then
	reboot_enable=${reboot_option#*=}
	if [ "$reboot_enable" = "on" ] ; then
		echo "reboot"
	fi
fi
#=========command========================================================================================
command_option=`cat $conf_file |grep command=`
if [ -n "$command_option" ] ; then
	cmd=${command_option#*=}
#    echo ${cmd}|awk '{run=$0;system(run)}'
fi
#=========mcu log level set========================================================================================
mcu_log_switch_option=`cat $conf_file |grep mcu_log_switch=`
if [ -n "$mcu_log_switch_option" ] ; then
	mcu_log_switch=${mcu_log_switch_option#*=}
    if [ "$mcu_log_switch" = "on" ] ; then
		zte_topsw_mcutest 603 01000000
		mculog_level_option=`cat $conf_file |grep mculog_level=`
		if [ -n "$mculog_level_option" ] ; then
			mculog_level=${mculog_level_option#*=}
			if [ "$mculog_level" = "5" ] ; then
				zte_topsw_mcutest 605 05000000
			elif [ "$mculog_level" = "6" ] ; then	
			    zte_topsw_mcutest 605 06000000
			elif [ "$mculog_level" = "7" ] ; then	
			    zte_topsw_mcutest 605 07000000
			elif [ "$mculog_level" = "8" ] ; then	
			    zte_topsw_mcutest 605 08000000
			elif [ "$mculog_level" = "9" ] ; then	
			    zte_topsw_mcutest 605 09000000
			elif [ "$mculog_level" = "10" ] ; then	
			    zte_topsw_mcutest 605 10000000
			else
			    zte_topsw_mcutest 605 $mculog_level
            fi			
		fi
	elif [ "$mcu_log_switch" = "off" ] ; then
		zte_topsw_mcutest 603 00000000
	fi
fi
#========get device run status log========================================================================

echo "======lsmod=====" > $system_status_log
lsmod >> $system_status_log

echo "======free=====" >> $system_status_log
free >> $system_status_log

echo "======df -h=====" >> $system_status_log
df -h>> $system_status_log

echo "======du -s / -h -d 5 -x=====" >> $system_status_log
du -s / -h -d 5 -x >> $system_status_log

echo "======du -s /dev -h -d 5 -x =====" >> $system_status_log
du -s /dev -h -d 5 -x >> $system_status_log

echo "======du -s /dev/shm -h -d 5=====" >> $system_status_log
du -s /dev/shm -h -d 5 -x >> $system_status_log

echo "======du -s /usr -h -d 5 -x=====" >> $system_status_log
du -s /usr -h -d 5 -x >> $system_status_log

echo "======du -s /cache -h -d 5=====" >> $system_status_log
du -s /cache -h -d 5 -x >> $system_status_log

echo "======du -s /usr/zte_web -h -d 5 -x=====" >> $system_status_log
du -s /usr/zte_web -h -d 5 -x >> $system_status_log

echo "======du -s /usr/wlan_backups -h -d 5 -x=====" >> $system_status_log
du -s /usr/wlan_backups -h -d 5 -x >> $system_status_log

echo "======du -s /firmware -h -d 5 -x=====" >> $system_status_log
du -s /firmware -h -d 5 -x >> $system_status_log

echo "======mount=====" >> $system_status_log
mount >> $system_status_log

echo "======ps=====" >> $system_status_log
ps >> $system_status_log

echo "======ifconfig=====" >> $system_status_log
ifconfig>> $system_status_log

echo "======ifconfig -a=====" >> $system_status_log
ifconfig -a>> $system_status_log

echo "======ip route=====" >> $system_status_log
ip route>> $system_status_log

echo "======ip -6 route=====" >> $system_status_log
ip -6 route>> $system_status_log

echo "======route -n=====" >> $system_status_log
route -n>> $system_status_log

echo "======iptables -L=====" >> $system_status_log
iptables -L>> $system_status_log

echo "======iptables -t filter -vnL=====" >> $system_status_log
iptables -t filter -vnL>> $system_status_log

echo "======iptables -t nat -vnL=====" >> $system_status_log
iptables -t nat -vnL>> $system_status_log

echo "======iptables -t mangle -vnL=====" >> $system_status_log
iptables -t mangle -vnL>> $system_status_log

echo "======ip6tables -t filter -vnL=====" >> $system_status_log
ip6tables -t filter -vnL>> $system_status_log


echo "======ip6tables -t mangle -vnL=====" >> $system_status_log
ip6tables -t mangle -vnL>> $system_status_log

echo "======ebtables -L=====" >> $system_status_log
ebtables -L>> $system_status_log

echo "======cat /proc/net/ip_conntrack | wc -l=====" >> $system_status_log
cat /proc/net/ip_conntrack | wc -l>> $system_status_log

echo "======cat /proc/net/ip_conntrack=====" >> $system_status_log
cat /proc/net/ip_conntrack>> $system_status_log

echo "======conntrack -L=====" >> $system_status_log
conntrack -L>> $system_status_log

echo "======netstat -a -e -n -p=====" >> $system_status_log
netstat -a -e -n -p>> $system_status_log

echo "======brctl show=====" >> $system_status_log
brctl show>> $system_status_log

echo "======cfg show=====" >> $system_status_log
cfg show>> $system_status_log

echo "======cat /proc/sys/net/ipv4/ip_forward=====" >> $system_status_log
cat /proc/sys/net/ipv4/ip_forward>> $system_status_log

echo "======cat /proc/sys/net/ipv6/conf/all/forwarding=====" >> $system_status_log
cat /proc/sys/net/ipv6/conf/all/forwarding>> $system_status_log

echo "======arp -a -n=====" >> $system_status_log
arp -a -n>> $system_status_log

echo "======arp -a -n | wc -l=====" >> $system_status_log
arp -a -n | wc -l>> $system_status_log

echo "======date=====" >> $system_status_log
date >> $system_status_log

dmesg > $logpath/dmesg

cfg set zte_debug_done="1"
cfg save
