#!/bin/sh
# ===========================================================
# rj45_mode_switch.sh
# create by zhangwentao187783 20130313

CABLE_INTERFACE="eth0"
BRIDGE_INTERFACE="bridge0"
LAN_IPADDR_FOR_CURRENT=`cfg get router_mode_gateway`  
IP_ACQUIRE=`cfg get opms_wan_mode`
WAN_LAN_AUTO_MODE=`cfg get opms_wan_auto_mode`
pppoe_dial_mode=`cfg get pppoe_dial_mode`
action_link=`cfg get pppoe_dial_action_link`
vlan_enable=`cfg get cpe_vlan_enable`

#DNS_RESOLV_FILE="/etc_rw/ztembb/resolv.conf"
#DNS_RESOLV_FILE_STATIC="/etc_rw/ztembb/resolv.conf-static"
DNS_RESOLV_FILE="/etc/resolv.conf"
DNS_RESOLV_FILE_STATIC="/etc/resolv.conf-static"

file_system_readonly=`cfg get file_read_only_flag`
if [ "$file_system_readonly" = "1" ] ; then
    echo "$0:read only file system"
    DNS_RESOLV_FILE="/var/run/resolv.conf"
    DNS_RESOLV_FILE_STATIC="/var/run/resolv.conf"
fi

if [ "$vlan_enable" == "1" ] ; then
	interface_name=`cfg get cpe_wan_lan_name`
	if [ "$interface_name" == "" ] ; then
		CABLE_INTERFACE="eth0.2"
	else
		CABLE_INTERFACE="$interface_name"
    fi	
fi

pre_clear_work()
{
# in lan mode, do not delete the default route
	if [ "PPP" = "$IP_ACQUIRE" ];then
		echo "NOW IS PPP MODE,DO NOTHING ...RETURN"	
		return
	elif [ "AUTO" = "$IP_ACQUIRE" -a "AUTO_LTE_GATEWAY" = "$WAN_LAN_AUTO_MODE" ];then
		echo
	else
		ip route del default
		ip route del default
		ip route del default
	fi

	killall pppoecd
	killall pppoecd
	killall -9 udhcpc
	killall -9 udhcpc
	
	brctl delif $BRIDGE_INTERFACE $CABLE_INTERFACE
	ifconfig $CABLE_INTERFACE 0.0.0.0
	ifconfig $CABLE_INTERFACE up
	#ifconfig $BRIDGE_INTERFACE $LAN_IPADDR_FOR_CURRENT up
	#cfg set lan_ipaddr_for_current=$LAN_IPADDR_FOR_CURRENT    

	#killall -9 dnsmasq
	#dnsmasq -C /tmp/dnsmasq.conf
}

run_pppoe()
{
    killall pppoecd
	cfg set ppp_status=ppp_disconnected
	cfg set wan_ipaddr=""
	router_msg network_down
	echo "pppoe dial"
	
	if [ "$action_link" == "connect" ];then	
		pppoe_user=`cfg get pppoe_username`
		pppoe_pass=`cfg get pppoe_password`  
		
		if [ "$pppoe_dial_mode" == "auto_dial" ]; then
			echo "pppoe_dial_mode auto_dial"
			pppoecd $CABLE_INTERFACE -u $pppoe_user -p $pppoe_pass -N 2 -k -d &
		elif [ "$pppoe_dial_mode" == "manual_dial" ]; then
			echo "pppoe_dial_mode manual_dial"
			pppoecd $CABLE_INTERFACE -u $pppoe_user -p $pppoe_pass -N 2 -d &
		else
			echo "pppoe_dial_mode unknown"
		fi  
	elif [ "$action_link" == "disconnect" ] ;then
		echo "pppoed-down : --disconencted--"
		sleep 2
		cfg set ppp_staus=ppp_disconnected	
	else
		echo "pppoe unknow action_link"	
	fi
}
run_dhcp()
{
	cfg set dhcp_wan_status=
	udhcpc -i $CABLE_INTERFACE -s /usr/zte/zte_conf/scripts/udhcpc-rj45.sh -p /tmp/udchpc_rj45_dhcp.pid &
	cfg set static_wan_status=
}
run_static()
{
	lan_ip=`cfg get static_wan_ipaddr`
	lan_netmask=`cfg get static_wan_netmask`
	lan_gw=`cfg get static_wan_gateway`
	dns_p=`cfg get static_wan_primary_dns`
	dns_s=`cfg get static_wan_secondary_dns`
	ifconfig $CABLE_INTERFACE $lan_ip netmask $lan_netmask up
	route add default gw $lan_gw dev $CABLE_INTERFACE
	echo "" > $DNS_RESOLV_FILE_STATIC
    if [ -n "$dns_p" ];then
    	echo "nameserver" $dns_p >> $DNS_RESOLV_FILE_STATIC	
    fi
    if [ -n "$dns_s" ];then
    	echo "nameserver" $dns_s >> $DNS_RESOLV_FILE_STATIC
    fi
	
	cp -fr $DNS_RESOLV_FILE_STATIC $DNS_RESOLV_FILE
	
	cfg set dhcp_wan_status=
	result=$(ifconfig $CABLE_INTERFACE | grep $lan_ip)
	echo "result:$result"
	if [ "$result" == "" ]; then
		cfg set static_wan_status=0
	else
		cfg set static_wan_status=1
	fi
	
	router_msg network_up
	
#	cfg set cable_dial_status=static_connected
}
run_lan_only()
{
	brctl addif $BRIDGE_INTERFACE $CABLE_INTERFACE
	ifconfig $CABLE_INTERFACE 0.0.0.0
	ifconfig $CABLE_INTERFACE up
}

pre_clear_auto_dhcp_work()
{
	killall -9 pppoecd
	killall -9 pppoecd
}

#if [ "AUTO" = "$IP_ACQUIRE" -a "AUTO_DHCP" = "$WAN_LAN_AUTO_MODE" ]; then
#	pre_clear_auto_dhcp_work
#	router_msg network_up
#else
#	pre_clear_work
#fi

pre_clear_work
	
if [ "DHCP" = "$IP_ACQUIRE" ];then
	run_dhcp
elif [ "STATIC" = "$IP_ACQUIRE" ];then
	run_static
elif [ "PPPOE" = "$IP_ACQUIRE" ];then
	run_pppoe
elif [ "PPP" = "$IP_ACQUIRE" ];then
#	run_lan_only
	echo "PPP do nothing"
elif [ "AUTO" = "$IP_ACQUIRE" ];then
	if [ "AUTO_PPPOE" = "$WAN_LAN_AUTO_MODE" ];then
		run_pppoe
	elif [ "AUTO_DHCP" = "$WAN_LAN_AUTO_MODE" ];then
		run_dhcp
		echo "AUTO_DHCP"
	elif [ "AUTO_LTE_GATEWAY" = "$WAN_LAN_AUTO_MODE" ];then
		run_lan_only
	else
		echo "some err happen"
	fi
else
  echo "some err happen"    
fi
