#!/bin/sh
# Copyright (c) 2014, The Linux Foundation. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of The Linux Foundation nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# find_partitions        init.d script to dynamically find partitions
#

FindAndMountUBI () {
   partition=$1
   dir=$2

   mtd_block_number=`cat $mtd_file | grep -i $partition | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   echo "MTD : Detected block device : $dir for $partition"
   mkdir -p $dir

   ubiattach -m $mtd_block_number -d 1 /dev/ubi_ctrl
   device=/dev/ubi1_0
   while [ 1 ]
    do
        if [ -c $device ]
        then
            mount -t ubifs -o ro /dev/ubi1_0 $dir -o bulk_read
            break
        else
            sleep 0.010
        fi
    done
}

FindAndMountVolumeUBI () {
   volume_name=$1
   dir=$2
   if [ ! -d $dir ]
   then
       mkdir -p $dir
   fi
   mount -t ubifs ubi0:$volume_name $dir -o bulk_read
}

mtd_file=/proc/mtd

fstype="UBI"
# eval FindAndMountVolume${fstype} usrfs /data

eval FindAndMount${fstype} modem /firmware
mount -t ubifs ubi0:fwfs /lib/firmware -o bulk_read
mount -t ubifs -o ro ubi0:ztedata /usr/zte_web -o bulk_read

#mount zterw partition as ubifs filesystem
mtd_num=`cat /proc/mtd | grep "zterw" | awk -F ':' '{print $1}' | awk -F 'mtd' '{print $2}'`
mtd_zterw=`cat /proc/mtd | grep "zterw" | awk -F ':' '{print $1}'`
ubiattach -m $mtd_num -d 3 /dev/ubi_ctrl
device=/dev/ubi3_0
if [ -c $device ]
then
echo "zterw ubiattach success."
else
echo "zterw ubiattach fail."
ubiformat -y /dev/$mtd_zterw
ubiattach -m $mtd_num -d 3 /dev/ubi_ctrl
fi
sleep 2

mount -t ubifs ubi3:etcrwfs /etc_rw -o bulk_read
if [ -d /etc_rw/restore  ]  &&  [ ! -f /etc_rw/WriteRestoreFlag  ]
then
echo "etc_rw fs check success."
else
 ubirmvol /dev/ubi3 -N etcrwfs
 ubimkvol /dev/ubi3 -s 24MiB -N etcrwfs
 mount -t ubifs ubi3:etcrwfs /etc_rw
 touch /etc_rw/WriteRestoreFlag
 cp -rfv /usr/etc_rw/* /etc_rw/
 rm -rf /etc_rw/WriteRestoreFlag 
fi

mount -t ubifs ubi3:cachefs /cache -o bulk_read
if [ -d /cache/restore  ]  &&  [ ! -f /cache/WriteRestoreFlag  ]
then
echo "cache fs check success."
else
 ubirmvol /dev/ubi3 -N cachefs
 ubimkvol /dev/ubi3 -s 36MiB -N cachefs
 mount -t ubifs ubi3:cachefs /cache
 touch /cache/WriteRestoreFlag
 cp -rfv /usr/cachefs/* /cache/
 rm -rf /cache/WriteRestoreFlag 
fi

mount -t ubifs ubi3:logfs /logfs -o bulk_read
if [ -d /logfs/restore  ]  &&  [ ! -f /logfs/WriteRestoreFlag  ]
then
echo "log fs check success."
else
 ubirmvol /dev/ubi3 -N logfs
 ubimkvol /dev/ubi3 -s 60MiB -N logfs
 mount -t ubifs ubi3:logfs /logfs
 touch /logfs/WriteRestoreFlag
 cp -rfv /usr/logfs/* /logfs/
 rm -rf /logfs/WriteRestoreFlag 
fi

# mtd_num=`cat /proc/mtd | grep "ztefile" | awk -F ':' '{print $1}' | awk -F 'mtd' '{print $2}'`
# ubiattach -m $mtd_num /dev/ubi_ctrl
# for ubidev_num in /dev/ubi[0-99]_*; do
# 	volname=`ubinfo $ubidev_num | grep Name\: | awk '{print $2}'`
# 	if [ "$volname" = "ztefile" ]; then
# 		# mount -t ubifs $ubidev_num /mnt -o bulk_read
# 		# echo "Mounting of $ubidev_num (ztefile) on /mnt done"
# 		echo "ztefile ubifs volume has been discovered as $ubidev_num, skip making volume."
# 		break
# 	fi
# done
# if [ "$volname" != "ztefile" ]; then
# 	echo "Making ztefile ubifs volume on $ubidev_num ..."
# 	# for ubidev_num in /dev/ubi[0-99]; do
# 	#	echo "Testing existence of $ubidev_num."
# 	# done
# 	for ubidev_num in `ls /dev/ubi[0-99] | sort -n`; do
# 		echo "Testing existence of $ubidev_num."
# 	done
# 	ubimkvol -m -N ztefile $ubidev_num
# 	echo "ztefile ubifs volume has been formated."
# fi

mtd_num=`cat /proc/mtd | grep "ztefile" | awk -F ':' '{print $1}' | awk -F 'mtd' '{print $2}'`
mtd_ztefile=`cat /proc/mtd | grep "ztefile" | awk -F ':' '{print $1}'`
magic=`od -x /dev/$mtd_ztefile -N 4|head -n 1`
echo "print ztefile partition the first 4 bytes values"
echo $magic
count=0
device=/dev/ubi2_0
if [ x"$magic" != x"0000000 4255 2349" ]
then
	echo "ztefile partition is empty,start making ztefile ubifs volume and mount it"
	ubiformat -y /dev/$mtd_ztefile
	ubiattach -m $mtd_num -d 2 /dev/ubi_ctrl
	sleep 2
	ubimkvol /dev/ubi2 -m -N ztefile
	mount -t ubifs /dev/ubi2_0 /usr/wlan_backups -o bulk_read
	echo "making ztefile ubifs volume and mount it on /usr/wlan_backups done"
else
	echo "ztefile partition is not empty,mount it on /usr/wlan_backups directly"
	ubiattach -m $mtd_num -d 2 /dev/ubi_ctrl
	while [ $count -lt 25 ]
	do
		if [ -c $device ]
		then
			mount -t ubifs /dev/ubi2_0 /usr/wlan_backups -o bulk_read 
			echo "mount ztefile ubifs volume on /usr/wlan_backups done"
			break
		fi
		sleep 0.2
		let count+=1
	done
fi

exit 0
