#!/bin/sh 
## 
# added by gaofei @2016.11.24
# 

wan_mode=`cfg get opms_wan_mode`
ppp_status=`cfg get ppp_status`
wan_ip=`cfg get wan_ipaddr`
userflowEnable=`cfg get userflowEnable`
protocol_ip_port_speedlimit_enable=`cfg get protocol_ip_port_speedlimit_enable`
device_speed_limit_upload=`cfg get upload_width_manual`
device_speed_limit_download=`cfg get download_width_manual`
userspeedlimit_count=`cfg get userspeedlimit_count`
gw=`cfg get lan_ipaddr`
mask=`cfg get lan_netmask`
lan_network_segment=`ipcalc $gw $mask -mbpn | grep NETWORK | awk -F '=' '{print $2}'`
lan_network_segment_bits=`ipcalc $gw $mask -mbpn | grep PREFIX | awk -F '=' '{print $2}'`
station_mac_ssid1=`cfg get station_mac_ssid1`
guest_ssid_enable=`cfg get guest_ssid_router_enable`
width_enable=`cfg get router_bw_switch`
tc_traffic_enable=`cfg get tc_traffic_enable`
#lan_network_segment="192.168.0.0"
#lan_network_segment_bits=24
cfg set online_limit_usr_num="0"
min=10

guest_ssid_enable=`cfg get guest_ssid_router_enable`
if [ "$guest_ssid_enable" = "1" ] ; then
	guest_gw=`cfg get guest_lan_ipaddr`
	guest_netmask=`cfg get guest_lan_netmask`
	guest_lan_network_segment=`ipcalc $guest_gw $guest_netmask -mbpn | grep NETWORK | awk -F '=' '{print $2}'`
	guest_lan_network_segment_bits=`ipcalc $guest_gw $guest_netmask -mbpn | grep PREFIX | awk -F '=' '{print $2}'`
fi
station_mac_ssid2=`cfg get station_mac_ssid2`

lan_if='bridge0'
lan1_if='bridge1'
wan_if=`cfg get current_wan_interface`

if [ "$width_enable" = "" ] ;then
	width_enable="0"
fi

if [ "$userspeedlimit_count" = "" ] ;then
	userspeedlimit_count="0"
fi

if [ "$userflowEnable" = "" ] ;then
	userflowEnable="0"
fi

# Remove SFE when enable speed limit
if [ "$protocol_ip_port_speedlimit_enable" != "1" ] ; then
	if [ "$width_enable" -ne "1" -a "$userspeedlimit_count" -lt "1" ]; then
		echo "speed limit is disabled, so we need to clear iptable and tc rules"
		if [ "$wan_mode" = "PPP" ] ; then
			if [ "$userflowEnable" -ne "1" ] ; then
				echo "userflowEnable=$userflowEnable,so we need to enable SFE"
				modprobe shortcut_fe
				modprobe shortcut_fe_ipv6
				modprobe shortcut_fe_cm
			fi
		else
			echo "wan_mode=$wan_mode,so we need to enable SFE"
			modprobe shortcut_fe
			modprobe shortcut_fe_ipv6
			modprobe shortcut_fe_cm
		fi
		
		iptables -t mangle -F SPEEDLIMIT_DOWNLOAD_CHAIN
		iptables -t mangle -F SPEEDLIMIT_UPLOAD_CHAIN
		tc qdisc delete dev $lan_if root handle 1:0 htb
		tc qdisc delete dev bridge1 root handle 1:0 htb
		tc qdisc delete dev rmnet_data0 root handle 1:0 htb
		tc qdisc delete dev eth0.2 root handle 1:0 htb
		exit
	else
		echo "NOTICE: speed-limit is enabled, SFE need to be removed!"
		rmmod shortcut-fe-cm
		rmmod shortcut-fe
		rmmod shortcut-fe-ipv6
	fi
else
	# Remove SFE when enable speed limit
	if [ "$protocol_ip_port_speedlimit_enable" == "1" ] ; then
		if [ $tc_traffic_enable -ne 1 ]; then
			echo "speed limit is disabled, so we need to enable SFE,clear iptable and tc rules"
			modprobe shortcut_fe
			modprobe shortcut_fe_ipv6
			modprobe shortcut_fe_cm
			iptables -t mangle -F SPEEDLIMIT_DOWNLOAD_CHAIN
			iptables -t mangle -F SPEEDLIMIT_UPLOAD_CHAIN
			tc qdisc delete dev $lan_if root handle 1:0 htb
			tc qdisc delete dev $wan_if root handle 1:0 htb
			exit
		else
			if [ "$device_speed_limit_upload" = "" -a "$device_speed_limit_download" = "" ]; then
				echo "speed limit is enable,but no upload/download total speed, so we need to enable fastnat,clear iptable and tc rules"
				modprobe shortcut_fe
				modprobe shortcut_fe_ipv6
				modprobe shortcut_fe_cm
				iptables -t mangle -F SPEEDLIMIT_DOWNLOAD_CHAIN
				iptables -t mangle -F SPEEDLIMIT_UPLOAD_CHAIN
				tc qdisc delete dev $lan_if root handle 1:0 htb
				tc qdisc delete dev $wan_if root handle 1:0 htb
				exit
			fi
			echo "NOTICE: speed-limit is enabled, SFE need to be removed!"
			userspeedlimit_count="16"
			rmmod shortcut-fe-cm
			rmmod shortcut-fe
			rmmod shortcut-fe-ipv6
		fi
	fi
fi	

#added by gaofei for speedlimit @2016.11.25 begin
#download
iptables -t mangle -F SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -D POSTROUTING -j SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -D POSTROUTING -j SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -X SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -N SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -I POSTROUTING 1 -j SPEEDLIMIT_DOWNLOAD_CHAIN
#upload
iptables -t mangle -F SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -D PREROUTING -j SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -D PREROUTING -j SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -X SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -N SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -I PREROUTING 1 -j SPEEDLIMIT_UPLOAD_CHAIN
#added by gaofei for speedlimit @2016.11.25 end

#-------------------------------------download------------------------------------------
if [ "$protocol_ip_port_speedlimit_enable" != "1" ] ; then
	echo "set download speed limit parameter"
	if [ "$width_enable" -ne "1" ]; then
		device_speed_limit_download="1000000" # 1000000kbit=1000mbit
	fi
fi
echo "device_speed_limit_download = $device_speed_limit_download" 
#flush download qdisc
tc qdisc delete dev $lan_if root handle 1:0 htb
#ʼ
tc qdisc add dev $lan_if root handle 1:0 htb default 1
tc class add dev $lan_if parent 1:0 classid 1:1 htb rate 1000000kbit
tc qdisc add dev $lan_if parent 1:1 handle 10: sfq perturb 10
##-----##
#Ĭ1:100
tc class add dev $lan_if parent 1:1 classid 1:100 htb rate "$device_speed_limit_download"kbit
tc qdisc add dev $lan_if parent 1:100 handle 100: sfq perturb 10
iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if ! -s $gw -d $lan_network_segment/$lan_network_segment_bits -j RETURN
iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if ! -s $gw -d $lan_network_segment/$lan_network_segment_bits -j MARK --set-mark 100
tc filter add dev $lan_if parent 1:0 protocol ip handle 100 fw classid 1:100

if [ "$guest_ssid_enable" = "1" ] ; then
	#flush download qdisc
	tc qdisc delete dev $lan1_if root handle 1:0 htb
	#ʼ
	tc qdisc add dev $lan1_if root handle 1:0 htb default 100
	tc class add dev $lan1_if parent 1:0 classid 1:1 htb rate "$device_speed_limit_download"kbit
	tc qdisc add dev $lan1_if parent 1:1 handle 10: sfq perturb 10
	##-----##
	#Ĭ1:100
	tc class add dev $lan1_if parent 1:1 classid 1:100 htb rate "$device_speed_limit_download"kbit
	tc qdisc add dev $lan1_if parent 1:100 handle 100: sfq perturb 10
	iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan1_if ! -s $guest_gw -d $guest_lan_network_segment/$guest_lan_network_segment_bits -j RETURN
	iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan1_if ! -s $guest_gw -d $guest_lan_network_segment/$guest_lan_network_segment_bits -j MARK --set-mark 100
	tc filter add dev $lan1_if parent 1:0 protocol ip handle 100 fw classid 1:100
else
	#flush download qdisc
	tc qdisc delete dev $lan1_if root handle 1:0 htb
	if [ "$guest_lan_network_segment" != "" -a "$guest_lan_network_segment_bits" != "" ] ; then
		iptables -t mangle -D SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan1_if ! -s $guest_gw -d $guest_lan_network_segment/$guest_lan_network_segment_bits -j RETURN
		iptables -t mangle -D SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan1_if ! -s $guest_gw -d $guest_lan_network_segment/$guest_lan_network_segment_bits -j MARK --set-mark 100
	fi
fi

#Ծĳû
i=0
while [ $i -lt $userspeedlimit_count ]
do
	echo "i = [$i]"
	userspeedlimit=`cfg get userspeedlimit_$i`
	if [ "$userspeedlimit" != "" ]; then
		if [ "$protocol_ip_port_speedlimit_enable" != "1" ] ; then
			mac=`echo $userspeedlimit | cut -d "," -f 1`
			ip=`echo $userspeedlimit | cut -d "," -f 2`
			
			num=`arp -n | grep -i $mac | wc -l`
			if [ "$num" = "0" ] ; then
				i=`expr $i + 1`
				continue
			fi
			
			for k in `seq 1 $num`
			do  
				if [ "$k" = "1" ] ; then
					ip=`arp -n | grep -i $mac | awk 'NR==1 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
					interface=`arp -n | grep -i $mac | awk 'NR==1 {print $7}'`
				elif [ "$k" = "2" ] ; then 
					ip=`arp -n | grep -i $mac | awk 'NR==2 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
					interface=`arp -n | grep -i $mac | awk 'NR==2 {print $7}'`
				elif [ "$k" = "3" ] ; then 
					ip=`arp -n | grep -i $mac | awk 'NR==3 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
					interface=`arp -n | grep -i $mac | awk 'NR==3 {print $7}'`
				fi	
				flag=`arping -c 2 -I $interface $ip | grep Received | awk '{print $2}'`
				
				if [ "$interface" = "bridge0" ] ; then
					tmp_gw=$gw
				elif [ "$interface" = "bridge1" ] ; then
					tmp_gw=$guest_gw
				fi
				
				if [ "$flag" -ge "1" ] ; then
					lan_if=$interface
					echo "find mac[$mac] ip[$ip] lan_if[$lan_if]"
					break
				fi
			done  
			
			if [ "$flag" -lt "1" ] ; then
				i=`expr $i + 1`
				continue
			fi
		
			upload_speed=`echo $userspeedlimit | cut -d "," -f 3`
			download_speed=`echo $userspeedlimit | cut -d "," -f 4`
			if [ "$download_speed" -gt "$device_speed_limit_download" ] ; then
				download_speed=$device_speed_limit_download
			fi
			
			echo "[userspeedlimit, mac, ip, up, down] = [$userspeedlimit, $mac, $ip, $upload_speed, $download_speed]"
			
			j=`expr $i + 1`
			tc class add dev $lan_if parent 1:1 classid 1:1$j htb rate "$download_speed"kbit
			tc qdisc add dev $lan_if parent 1:1$j handle 1$j: sfq perturb 10
			iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if ! -s $tmp_gw -d $ip/32 -j RETURN
			iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if ! -s $tmp_gw -d $ip/32 -j MARK --set-mark 1$j
			tc filter add dev $lan_if parent 1:0 protocol ip handle 1$j fw classid 1:1$j
		else
			ip_start=`echo $userspeedlimit | cut -d "," -f 1`
			ip_end=`echo $userspeedlimit | cut -d "," -f 2`
			port_start=`echo $userspeedlimit | cut -d "," -f 3`
			port_end=`echo $userspeedlimit | cut -d "," -f 4`
			protocol=`echo $userspeedlimit | cut -d "," -f 5`
			priority=`echo $userspeedlimit | cut -d "," -f 6`
			upload_speed_min=`echo $userspeedlimit | cut -d "," -f 7`
			upload_speed_max=`echo $userspeedlimit | cut -d "," -f 8`
			download_speed_min=`echo $userspeedlimit | cut -d "," -f 9`
			download_speed_max=`echo $userspeedlimit | cut -d "," -f 10`
			status=`echo $userspeedlimit | cut -d "," -f 11`
			echo "[userspeedlimit, ip_start, ip_end, port_start, port_end, protocol, priority, upload_speed_min,        
				   upload_speed_max, download_speed_min, download_speed_max, status] = [$userspeedlimit, $ip_start, $ip_end, $port_start, 
				   $port_end, $protocol, $priority, $upload_speed_min, $upload_speed_max, $download_speed_min, $download_speed_max, $status]"
			
			if [ $status -ne 1 ]; then
				echo "userspeedlimit $i status is disable"
				i=`expr $i + 1`
				continue
			fi		
			
			j=`expr $i + 1`
			echo "j is [$j]"
			
			#if [ $download_speed_min < $min ]; then
			if [ `expr $download_speed_min \> $min` -eq 0 ]; then
				echo "download_speed_min is $download_speed_min"
				download_speed_min=$min   # 10kbit
			fi
			echo "download_speed_min is $download_speed_min"
			
			if [ $download_speed_max -gt $device_speed_limit_download ]||[ "$download_speed_max" = "" ]; then
				download_speed_max=$device_speed_limit_download   # device_speed_limit_download
			fi
			echo "download_speed_max is $download_speed_max"

			tc class add dev $lan_if parent 1:1 classid 1:1$j htb rate "$download_speed_min"kbit ceil "$download_speed_max"kbit
			tc qdisc add dev $lan_if parent 1:1$j handle 1$j: sfq perturb 10
			
			if [ $protocol -eq 0 ]; then	
				echo "protocol is $protocol"
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p tcp --sport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p tcp --sport $port_start:$port_end -j MARK --set-mark 1$j
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p udp --sport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p udp --sport $port_start:$port_end -j MARK --set-mark 1$j
			fi
			if [ $protocol -eq 1 ]; then
				echo "protocol is $protocol"		
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p tcp --sport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p tcp --sport $port_start:$port_end -j MARK --set-mark 1$j
			fi
			if [ $protocol -eq 2 ]; then
				echo "protocol is $protocol"
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p udp --sport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -m iprange --dst-range $ip_start-$ip_end -p udp --sport $port_start:$port_end -j MARK --set-mark 1$j
			fi
			tc filter add dev $lan_if parent 1:0 prio $priority protocol ip handle 1$j fw classid 1:1$j	
		fi
	fi	
	i=`expr $i + 1`
done

#-------------------------------------upload------------------------------------------
if [ "$protocol_ip_port_speedlimit_enable" != "1" ] ; then
	echo "set upload speed limit parameter"
	if [ "$width_enable" -ne "1" ]; then
		device_speed_limit_upload="1000000" # 1000000kbit=1000mbit
	fi
fi
echo "device_speed_limit_upload = $device_speed_limit_upload" 
#flush upload qdisc
tc qdisc delete dev $wan_if root handle 1:0 htb
#ʼϴ
tc qdisc add dev $wan_if root handle 1:0 htb default 1
tc class add dev $wan_if parent 1:0 classid 1:1 htb rate 1000000kbit
tc qdisc add dev $wan_if parent 1:1 handle 10: sfq perturb 10
##-----##
#Ĭ1:100
tc class add dev $wan_if parent 1:1 classid 1:100 htb rate "$device_speed_limit_upload"kbit
tc qdisc add dev $wan_if parent 1:100 handle 100: sfq perturb 10
iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $lan_network_segment/$lan_network_segment_bits ! -d $gw -j RETURN
iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $lan_network_segment/$lan_network_segment_bits ! -d $gw -j MARK --set-mark 100
if [ "$guest_ssid_enable" = "1" ] ; then
	iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $guest_lan_network_segment/$guest_lan_network_segment_bits ! -d $guest_gw -j RETURN
	iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $guest_lan_network_segment/$guest_lan_network_segment_bits ! -d $guest_gw -j MARK --set-mark 100
else
	if [ "$guest_lan_network_segment" != "" -a "$guest_lan_network_segment_bits" != "" ] ; then
		iptables -t mangle -D SPEEDLIMIT_UPLOAD_CHAIN -s $guest_lan_network_segment/$guest_lan_network_segment_bits ! -d $guest_gw -j RETURN
		iptables -t mangle -D SPEEDLIMIT_UPLOAD_CHAIN -s $guest_lan_network_segment/$guest_lan_network_segment_bits ! -d $guest_gw -j MARK --set-mark 100
	fi
fi
tc filter add dev $wan_if parent 1:0 protocol ip handle 100 fw classid 1:100
#Ծĳû
i=0
while [ $i -lt $userspeedlimit_count ]
do
	echo "i = [$i]"
	userspeedlimit=`cfg get userspeedlimit_$i`
	if [ "$userspeedlimit" != "" ] ; then
		if [ "$protocol_ip_port_speedlimit_enable" != "1" ] ; then
			mac=`echo $userspeedlimit | cut -d "," -f 1`
			ip=`echo $userspeedlimit | cut -d "," -f 2`
			
			num=`arp -n | grep -i $mac | wc -l`
			if [ "$num" = "0" ] ; then
				i=`expr $i + 1`
				continue
			fi
			for k in `seq 1 $num`
			do  
				if [ "$k" = "1" ] ; then
					ip=`arp -n | grep -i $mac | awk 'NR==1 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
					interface=`arp -n | grep -i $mac | awk 'NR==1 {print $7}'`
				elif [ "$k" = "2" ] ; then 
					ip=`arp -n | grep -i $mac | awk 'NR==2 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
					interface=`arp -n | grep -i $mac | awk 'NR==2 {print $7}'`
				elif [ "$k" = "3" ] ; then 
					ip=`arp -n | grep -i $mac | awk 'NR==3 {print $2}' | sed -e 's/(//g'|sed -e 's/)//g'`
					interface=`arp -n | grep -i $mac | awk 'NR==3 {print $7}'`
				fi	
				flag=`arping -c 2 -I $interface $ip | grep Received | awk '{print $2}'`
				
				if [ "$interface" = "bridge0" ] ; then
					tmp_gw=$gw
				elif [ "$interface" = "bridge1" ] ; then
					tmp_gw=$guest_gw
				fi
				if [ "$flag" -ge "1" ] ; then
					echo "find mac[$mac] ip[$ip] wan_if[$wan_if]"
					num=`cfg get online_limit_usr_num`
					num=`expr $num + 1`
					cfg set online_limit_usr_num=$num
					break
				fi
			done  
			if [ "$flag" -lt "1" ] ; then
				i=`expr $i + 1`
				continue
			fi
			
			upload_speed=`echo $userspeedlimit | cut -d "," -f 3`
			download_speed=`echo $userspeedlimit | cut -d "," -f 4`
			if [ "$upload_speed" -gt "$device_speed_limit_upload" ] ; then
				upload_speed=$device_speed_limit_upload
			fi
			
			j=`expr $i + 1`
			tc class add dev $wan_if parent 1:1 classid 1:1$j htb rate "$upload_speed"kbit
			tc qdisc add dev $wan_if parent 1:1$j handle 1$j: sfq perturb 10
			iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $ip/32 ! -d $tmp_gw -m mac --mac-source $mac -j RETURN
			iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $ip/32 ! -d $tmp_gw -m mac --mac-source $mac -j MARK --set-mark 1$j
			tc filter add dev $wan_if parent 1:0 protocol ip handle 1$j fw classid 1:1$j
	    else
			ip_start=`echo $userspeedlimit | cut -d "," -f 1`
			ip_end=`echo $userspeedlimit | cut -d "," -f 2`
			port_start=`echo $userspeedlimit | cut -d "," -f 3`
			port_end=`echo $userspeedlimit | cut -d "," -f 4`
			protocol=`echo $userspeedlimit | cut -d "," -f 5`
			priority=`echo $userspeedlimit | cut -d "," -f 6`
			upload_speed_min=`echo $userspeedlimit | cut -d "," -f 7`
			upload_speed_max=`echo $userspeedlimit | cut -d "," -f 8`
			download_speed_min=`echo $userspeedlimit | cut -d "," -f 9`
			download_speed_max=`echo $userspeedlimit | cut -d "," -f 10`
			status=`echo $userspeedlimit | cut -d "," -f 11`
			echo "[userspeedlimit, ip_start, ip_end, port_start, port_end, protocol, priority, upload_speed_min,        
					upload_speed_max, download_speed_min, download_speed_max, status] = [$userspeedlimit, $ip_start, $ip_end, $port_start, 
			$port_end, $protocol, $priority, $upload_speed_min, $upload_speed_max, $download_speed_min, $download_speed_max, $status]"
			
			if [ $status -ne 1 ]; then
				echo "userspeedlimit $i status is disable"
				i=`expr $i + 1`
				continue
			fi	
		
			j=`expr $i + 1`
			echo "j is [$j]"
			
			#if (($upload_speed_min < $min)); then
			if [ `expr $upload_speed_min \> $min` -eq 0 ]; then
				echo "upload_speed_min is $upload_speed_min"
				upload_speed_min=$min   # 10kbit
			fi
			echo "upload_speed_min is $upload_speed_min"
					
			if [ $upload_speed_max -gt $device_speed_limit_upload ]||[ "$upload_speed_max" = "" ]; then
				upload_speed_max=$device_speed_limit_upload   # device_speed_limit_upload
			fi
			echo "upload_speed_max is $upload_speed_max"
		
			tc class add dev $wan_if parent 1:1 classid 1:1$j htb rate "$upload_speed_min"kbit ceil "$upload_speed_max"kbit
			tc qdisc add dev $wan_if parent 1:1$j handle 1$j: sfq perturb 10
				
			if [ $protocol -eq 0 ]; then
				echo "protocol is $protocol"		
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p tcp --dport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p tcp --dport $port_start:$port_end -j MARK --set-mark 1$j
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p udp --dport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p udp --dport $port_start:$port_end -j MARK --set-mark 1$j
			fi
			if [ $protocol -eq 1 ]; then
				echo "protocol is $protocol"		
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p tcp --dport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p tcp --dport $port_start:$port_end -j MARK --set-mark 1$j
			fi
			if [ $protocol -eq 2 ]; then
				echo "protocol is $protocol"		
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p udp --dport $port_start:$port_end -j RETURN
				iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -m iprange --src-range $ip_start-$ip_end -p udp --dport $port_start:$port_end -j MARK --set-mark 1$j
			fi
			tc filter add dev $wan_if parent 1:0 prio $priority protocol ip handle 1$j fw classid 1:1$j   
		fi	
	fi
	i=`expr $i + 1`
done

if [ "$protocol_ip_port_speedlimit_enable" != "1" ] ; then
	online_limit_usr_num=`cfg get online_limit_usr_num`
	if [ "$online_limit_usr_num" -eq "0" -a "$width_enable" -ne "1" ] ;then
		if [ "$wan_mode" = "PPP" ] ; then
			if [ "$userflowEnable" -ne "1" ] ; then
				echo "userflowEnable=$userflowEnable,online_limit_usr_num=$online_limit_usr_num so we need to enable SFE"
				modprobe shortcut_fe
				modprobe shortcut_fe_ipv6
				modprobe shortcut_fe_cm
			fi
		else
			echo "wan_mode=$wan_mode,so we need to enable SFE"
			modprobe shortcut_fe
			modprobe shortcut_fe_ipv6
			modprobe shortcut_fe_cm
		fi
		iptables -t mangle -F SPEEDLIMIT_DOWNLOAD_CHAIN
		iptables -t mangle -F SPEEDLIMIT_UPLOAD_CHAIN
		tc qdisc delete dev $lan_if root handle 1:0 htb
		tc qdisc delete dev bridge1 root handle 1:0 htb
		tc qdisc delete dev rmnet_data0 root handle 1:0 htb
		tc qdisc delete dev eth0.2 root handle 1:0 htb
	fi	
fi

