/**
 * HOME模块
 * @module Home
 * @class Home
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'status/statusBar' ],

function($, ko, config, service, _, statusBar) {
    /**
     * 获取网络、SIM、WIFI等状态
     * @method getStatusInfo
     */
    var getStatusInfo = function () {
        return service.getStatusInfo();
    };
    var macDevice = [];
    /**
	 * connection information ViewModel
	 * 
	 * @class connectInfoVM
	 */
	function connectInfoVM() {
		var self = this;
		/*var info = service.getConnectionInfo();*/
        var statusInfo= getStatusInfo();
	    self.connectStatus = ko.observable(statusInfo.connectStatus);
        self.connect_Status = ko.observable('');
        var ssid = service.getWifiBasic().SSID;
        self.wifi_ssid = ko.observable($.i18n.prop("wifi_name")+" " +ssid);
        var pin_status_text = parseInt(statusInfo.pinStatus)==1?$.i18n.prop("enable"):$.i18n.prop("disable");
        self.sim_pin_status = ko.observable($.i18n.prop("sim_pin_status")+" "+pin_status_text);
		if (checkConnectedStatus(statusInfo.connectStatus)) {
			self.speedTime = ko.observable(transUnit(parseInt(statusInfo.data_counter.currentReceived, 10) + parseInt(statusInfo.data_counter.currentSent, 10), false)+" / "+transSecond2Time(statusInfo.data_counter.currentConnectedTime));
            var networkTypeTmp = statusInfo.networkType.toLowerCase();
            var type_2g = ["GSM", "GPRS", "EDGE"];
            var type_3g = ["UMTS", "WCDMA"];
            var type_h = ["HSUPA", "HSPA+","HSDPA"];
            var type_4g = ["LTE"];
            if($.inArray(statusInfo.networkType.toUpperCase(),type_h)!= -1){
                self.connect_Status($.i18n.prop("h_connected"));
            }else if($.inArray(statusInfo.networkType.toUpperCase(),type_4g)!= -1){
                self.connect_Status($.i18n.prop("4g_connected"));
            }else if($.inArray(statusInfo.networkType.toUpperCase(),type_3g)!= -1){
                self.connect_Status($.i18n.prop("3g_connected"));
            }else if($.inArray(statusInfo.networkType.toUpperCase(),type_2g)!= -1){
                self.connect_Status($.i18n.prop("2g_connected"));
            }else if (networkTypeTmp == ''||networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service'||networkTypeTmp == 'limited service' || networkTypeTmp == 'no service') {
                if(networkTypeTmp==""||networkTypeTmp=="limited service"){
                    networkTypeTmp = "limited_service";
                }else if(networkTypeTmp=="no service"){
                    networkTypeTmp = "no_service";
                }
                self.connect_Status($.i18n.prop("network_type_" + networkTypeTmp));
            }
		} else {
			self.speedTime=ko.observable("0MB / "+transSecond2Time(0));
            if(statusInfo.connectStatus == 'ppp_disconnected'){
                self.connect_Status($.i18n.prop("disconnected"));
            } else if(self.connectStatus() == 'ppp_connecting'){
                self.connect_Status($.i18n.prop("connecting"));
            } else {
                self.connect_Status($.i18n.prop("disconnecting"));
            }
		}
        var smsInfo = service.getSmsCapability();
        self.messageInfo = ko.observable(statusInfo.smsUnreadCount+" / "+(smsInfo.nvUsed+smsInfo.simUsed));
        self.hasWifi = ko.observable(config.HAS_WIFI);
		self.transText = ko.dependentObservable(function() {
			if (checkConnectedStatus(self.connectStatus())) {
                $("#homebtn").attr("class","homebtn_connect");
                return "disconnect";
			}else if(checkConnectingStatus(self.connectStatus())){
                return "connecting";
            }else if(checkDisconnectingStatus(self.connectStatus())){
                return "disconnecting";
            }else{
                $("#homebtn").attr("class","homebtn_disconnect");
                return "connect";
			}
		});
		
		self.canConnect = ko.observable(getCanConnectNetWork());
        self.connectStatusText = ko.dependentObservable(function() {
            self.canConnect();
            if (checkConnectedStatus(self.connectStatus())) {
                $("#homebtn").attr("class","homebtn_connect");
                return $.i18n.prop("disconnect");
            }else if(checkConnectingStatus(self.connectStatus())){
                return $.i18n.prop("connecting");
            }else if(checkDisconnectingStatus(self.connectStatus())){
                return $.i18n.prop("disconnecting");
            }else{
                $("#homebtn").attr("class","homebtn_disconnect");
                return $.i18n.prop("connect");
            }
		});

        self.imagePath = ko.observable("img/4.png");
        self.wifiStatusImg = ko.observable(getWifiStatusImg(statusInfo.wifiStatus,statusInfo.attachedDevices.length));
        self.wifiText = ko.observable($.i18n.prop("wifi_devices_connected"));
        //var devices = service.getCurrentlyAttachedDevicesInfo();
        var dev = fixAttachedDevicesInfo([]);
        self.deviceInfo = ko.observable(dev);
self.supportQrCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
		self.qrcode_ssid1 = ko.observable(getRQCodeImage(true));
		
        function getRQCodeImage(isSSID1) {
            if (self.supportQrCode()) {
                var timestamp = new Date().getTime();
                if (isSSID1) {
                    return './img/qrcode_ssid_wifikey.png?_=' + timestamp;
                } else if (config.HAS_MULTI_SSID) {
                    return './img/qrcode_multi_ssid_wifikey.png?_=' + timestamp;
                } else {
                    return './img/menu_normal1.png';
                }
            } else {
                return './img/menu_normal1.png';
            }
        }
		
        self.batteryText = ko.observable("");
		/**
		 * 响应连接按钮事件
		 * 
		 * @event connectHandler
		 */
		self.connectHandler = function() {
			if (checkConnectedStatus(self.connectStatus())) {
                showLoading('disconnecting');
                $("#homebtn").attr("trans","disconnecting").translate();
				service.disconnect({}, function(data) {
					if(data.result){
						successOverlay("disconnect_success_info");
					} else {
						errorOverlay();
					}
				});
			} else {
                if(service.getStatusInfo().roamingStatus && service.getStatusInfo().roamMode == "off") {
                    showAlert("dial_roam_info");
                }
                else {
                    self.connect();
                }
			}
		};

        self.connect = function() {
            var statusInfo = getStatusInfo();
            /*var trafficResult = statusBar.getTrafficResult(statusInfo);
            if(statusInfo.limitVolumeEnable && trafficResult.showConfirm){
                var confirmMsg = null;
                if(trafficResult.usedPercent > 100){
                    confirmMsg = {msg: 'traffic_beyond_connect_msg'};
                    statusBar.setTrafficAlertPopuped(true);
                } else {
                    confirmMsg = {msg: 'traffic_limit_connect_msg', params: [trafficResult.limitPercent]};
                    statusBar.setTrafficAlert100Popuped(false);
                }
                showConfirm(confirmMsg, function(){
                    doConnect();
                });
            }else{
                doConnect();
            }*/
            doConnect();
        };

	}
    /**
     * 把wifi用户添加到黑名单
     * @param index
     * @constructor
     */
    BlockClick = function(index){
        showLoading();
        var macList = "";
        var result = service.getMacFilterInfo();
        macList = result.wifi_mac_black_list;

        if(macDevice[index].macAddress!=result.client_mac_address){
            if(typeof macList !== 'undefined' && macList.length<=0){
                macList = macDevice[index].macAddress;
            }else{
                macList = macDevice[index].macAddress+";"+macList;
            }
            var params = {};
            params.macfilteringMode = 2;
            params.macList = macList;
            service.setMacFilter(params, function(result) {
                if (result.result == "success") {
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        }else{
            showAlert("wifi_block_self_notification");
        }
    }
    /**
     * 从黑名单中移除wifi用户对应的MAC地址
     * @param index
     * @constructor
     */
    UnBlockClick = function(index){
        showLoading();
        var macList = "";
        var newMacList=[];
        var result = service.getMacFilterInfo();
        macList = result.wifi_mac_black_list;
        var blackMacList = macList.split(";");
        var mac = macDevice[index].macAddress;
        for(var i=0;i<blackMacList.length;i++){
            if(mac!=blackMacList[i]){
                newMacList.push(blackMacList[i]);
            }
        }

        var params = {};
        params.macfilteringMode = 2;
        params.macList = newMacList.join(";");
        service.setMacFilter(params, function(result) {
            if (result.result == "success") {
                successOverlay();
            } else {
                errorOverlay();
            }
        });
    }

    /**
     * 根据wifi状态获取wifi的图片资源
     * @method getWifiStatusImg
     */
    function getWifiStatusImg(status, deviceSize) {
        if (status) {
            if (deviceSize == 0) {
                return "img/wifi_0.png";
            } else {
                return "img/wifi_" + deviceSize + ".png";
            }
        } else {
            return "img/wifi_0.png";
        }
    }
    /**
     * 将电量转化为对应图片
     * @method convertBatteryPers
     * @param vm
     * @param status
     */
    function convertBatteryPers(pers, status) {
        var txt = ""
        if ("0" == status) {
            txt = pers+"% Left";
        } else {
            if(parseInt(pers)<100){
                txt = "Charging "+parseInt(pers)+"% complete";
            }else{
                txt = "Charging complete";
            }
        }
        return txt;
    }
    //设置联网状态图片
    function setImagePath(self,statusInfo){
        if(statusInfo.signalImg=="1"){
            self.imagePath("img/5.png");
        }else if(statusInfo.signalImg=="2"){
            self.imagePath("img/6.png");
        }else if(statusInfo.signalImg=="3"){
            self.imagePath("img/7.png");
        }else if(statusInfo.signalImg=="4"){
            self.imagePath("img/8.png");
        }else if(statusInfo.signalImg=="5"){
            self.imagePath("img/9.png");
        }else {
            self.imagePath("img/4.png");
        }

    }
    //设置联网状态文字
    function setConnectedStatus(self,statusInfo){
        if(checkConnectedStatus(statusInfo.connectStatus)){
            var type_2g = ["GSM", "GPRS", "EDGE"];
            var type_3g = ["UMTS", "WCDMA"];
            var type_h = ["HSUPA", "HSPA", "HSPA+", "DC-HSPA+","HSDPA"];
            var type_4g = ["LTE"];
            var networkTypeTmp = statusInfo.networkType.toLowerCase();
            if($.inArray(statusInfo.networkType.toUpperCase(),type_h)!= -1){
                self.connect_Status($.i18n.prop("h_connected"));
            }else if($.inArray(statusInfo.networkType.toUpperCase(),type_4g)!= -1){
                self.connect_Status($.i18n.prop("4g_connected"));
            }else if($.inArray(statusInfo.networkType.toUpperCase(),type_3g)!= -1){
                self.connect_Status($.i18n.prop("3g_connected"));
            }else if($.inArray(statusInfo.networkType.toUpperCase(),type_2g)!= -1){
                self.connect_Status($.i18n.prop("2g_connected"));
            }else if (networkTypeTmp == ''||networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service'||networkTypeTmp == 'limited service' || networkTypeTmp == 'no service') {
                if(networkTypeTmp==""||networkTypeTmp=="limited service"){
                    networkTypeTmp = "limited_service";
                }else if(networkTypeTmp=="no service"){
                    networkTypeTmp = "no_service";
                }
                self.connect_Status($.i18n.prop("network_type_" + networkTypeTmp));
            }else{
                self.connect_Status($.i18n.prop("connected"));
            }
        }else{
            if(statusInfo.connectStatus == 'ppp_disconnected'){
                self.connect_Status($.i18n.prop("disconnected"));
            } else if(statusInfo.connectStatus == 'ppp_connecting'){
                self.connect_Status($.i18n.prop("connecting"));
            } else {
                self.connect_Status($.i18n.prop("disconnecting"));
            }
        }
    }
    //设置短信信息
    function setMessageInfo(self){
        var statusInfo = getStatusInfo();
        service.getSmsCapability({}, function(smsInfo){
			self.messageInfo (statusInfo.smsUnreadCount+" / "+(smsInfo.nvUsed+smsInfo.simUsed));
		});        
    }
    //设置wifi图片和电池电量
    function setWifiImage(self,info){
        self.wifiStatusImg(getWifiStatusImg(info.wifiStatus, info.attachedDevices.length));
        self.batteryText(convertBatteryPers(info.battery_value, info.batteryStatus));
    }
    function doConnect(){
        showLoading('connecting');
        $("#homebtn").attr("trans","connecting").translate();
        service.connect({}, function(data) {
            if(data.result){
                successOverlay("connect_success_info");
            } else {
                errorOverlay();
            }
        });
    }

    function fixAttachedDevicesInfo(devices) {
        var emptyInfo = {
            macAddress:"",
            ipAddress:"",
            hostName:"",
            timeConnected:""
        };
        var deviceNum = 0;
        if (devices) {
            deviceNum = devices.length;
        } else {
            devices = [];
        }
        /*var emptyLen = config.MAX_STATION_NUMBER - deviceNum;
        for (var i = 0; i < emptyLen; i++) {
            devices.push(emptyInfo);
        } */
        return devices;
    }

    function getCanConnectNetWork(){
        var status = getStatusInfo();
        if (status.simStatus != "modem_init_complete") {
            return false;
        }
        
        if (checkConnectedStatus(status.connectStatus)) {
            if (config.AP_STATION_SUPPORT) {                
                if (status.ap_station_enable) {
                    var result = service.getConnectionMode();
                    if (result.connectionMode == "auto_dial") {
                        return false;
                    }
                }
            }
            return true;
        }
	
	//如果已联网，但是没有信号，断网按钮需要可以用
        if (status.signalImg == "0") {
            return false;
        }
        var networkTypeTmp = status.networkType.toLowerCase();
        if (networkTypeTmp == '' || networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service'||networkTypeTmp == 'limited service' || networkTypeTmp == 'no service') {
            return false;
        }
        if("ppp_connecting"==status.connectStatus || "ppp_disconnecting"==status.connectStatus){
            return false;
        }
        if (config.AP_STATION_SUPPORT) { 
            if (status.connectWifiStatus == "connect") {
                if (status.ap_station_mode == "wifi_pref") {
                    return false;
                }
            }
        }

        return true;
    }
    function getCurUserIpAddress(){
        var result = service.getCurUserIpAddress();
        return result.user_ip_addr;
    }
    function refreshHomeData(vm){
        var info = getStatusInfo();
        vm.connectStatus(info.connectStatus);
        if (checkConnectedStatus(info.connectStatus)) {
            vm.speedTime(transUnit(parseInt(info.data_counter.currentReceived, 10) + parseInt(info.data_counter.currentSent, 10), false)+" / "+transSecond2Time(info.data_counter.currentConnectedTime));
        } else {
            vm.speedTime("0MB / "+transSecond2Time(0));
        }
        refreshAttachedDevicesInfo(vm);
        setImagePath(vm,info);
        setConnectedStatus(vm,info);
        setWifiImage(vm,info);
        vm.canConnect(getCanConnectNetWork());
        var pin_status_text = parseInt(info.pinStatus)==1?$.i18n.prop("enable"):$.i18n.prop("disable");
        vm.sim_pin_status($.i18n.prop("sim_pin_status")+ " " + pin_status_text);
    }

    function refreshAttachedDevicesInfo(self) {
        service.getCurrentlyAttachedDevicesInfo({}, function (devices) {
            var dev = fixAttachedDevicesInfo(devices.attachedDevices);
            service.getMacFilterInfo({}, function(result){
				var macList = result.wifi_mac_black_list;
				if(macList!="" && typeof macList !== 'undefined'){
					var blackMacList = macList.split(";");
					for(var i=0;i<blackMacList.length;i++){
						if(blackMacList[i]!=""){
							for(var j=0;j<dev.length;j++){
								if(blackMacList[i]==dev[j].macAddress){
									 dev.splice(j,1);
								}
							}
							var tempInfo = {
								macAddress:blackMacList[i],
								ipAddress:"",
								hostName:"N/A",
								timeConnected:""
							};
							dev.push(tempInfo);
						}
					}
				}
				self.deviceInfo(dev);
				macDevice = dev;
			});
        });
    }

    function initRedirectPath(){
        function redirectNoConPath(){
            var curentHref = window.location.href;
            window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + "#home";
        }

        var info = service.getStatusInfo();
        var curentHref = window.location.href;
        if(window.location.href.indexOf("?no_connect") != -1){
            if(service.getEthernetConnect().is_rj45_connected){
                showPromptNoImg("pppoe_error_jump_login",function(){
                    window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + (config.hasRJ45?"#ethernet_settings":"#home");
                });

            } else {
                if(info.simStatus == "modem_sim_undetected"){
                    showPromptNoImg("no_simcard_jump",function(){
                        redirectNoConPath();
                    });
                } else if(info.simStatus == "modem_sim_destroy" || info.simStatus == "modem_destroy") {
                    showPromptNoImg("invalid_simcard_jump",function(){
                        redirectNoConPath();
                    });
                }else if(info.simStatus == "modem_imsi_waitnck"  || info.simStatus == "modem_waitpin"|| info.simStatus == "modem_waitpuk") {
                    showPromptNoImg("locked_simcard_jump_login",function(){
                        redirectNoConPath();
                    });
                } else {
                    if(info.ppp_dial_conn_fail_counter == '0' || info.ppp_dial_conn_fail_counter == ''){
                        showPromptNoImg("no_connect_jump_login",function(){
                            redirectNoConPath();
                        });
                    } else {
                        showPromptNoImg("connect_failed_jump_login",function(){
                            redirectNoConPath();
                        });
                    }
                }
            }
        } else if(window.location.href.indexOf("?flow_beyond") != -1){
            showPromptNoImg("flow_beyond_jump_login",function(){
                service.setRedirectOff();
                window.location.href = curentHref.slice(0,curentHref.indexOf("?flow_beyond")) + "#traffic_alert";
            });
        } else if(window.location.href.indexOf("?fota_upgrade") != -1){
            showPromptNoImg("fota_upgrade_jump_login",function(){
                service.setRedirectOff();
                window.location.href = curentHref.slice(0,curentHref.indexOf("?fota_upgrade")) + "#ota_update";

            });
        }
    }

    /**
	 * 初始化vm
	 * 
	 * @method init
	 */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);

		var connectionVM = new connectInfoVM();
		ko.applyBindings(connectionVM, container);
        initRedirectPath();

		$('#frmHome').validate({
			submitHandler : function() {
				connectionVM.connectHandler();
			}
		});

        refreshHomeData(connectionVM);
		addInterval(function() {
            refreshHomeData(connectionVM);
        }, 1000);
        setInterval(function(){
            setMessageInfo(connectionVM);
        },1500);
	}

    return {
        init:init,
        refreshAttachedDevicesInfo:refreshAttachedDevicesInfo,
        BlockClick:BlockClick,
        UnBlockClick:UnBlockClick,
	initRedirectPath:initRedirectPath
    };
});