var loginStatus = {login:"loggedIn", logout:"loggedOut" };

function pageInit() {
    util.showLoading();
    util.translate();
    var result = service.getLoginStatus();
    updatePageByLoginStatus(result.status);
    util.hideLoading();
}

function linkToPcView() {
    if (util.showConfirm($.i18n.prop("confirm_to_pcview"))) {
        util.changePageByUrl("../index.html");
    }
}

function updatePageByLoginStatus(status) {
    if (status == loginStatus.logout) {
        $("#btnLogout").button().parent().hide();
        $("#preQuickSetting").attr("href", "javascript:linkToStatus('setup')");
        $("#preToStatus").attr("href", "javascript:linkToStatus('status')");
    } else {
        $("#btnLogout").button().parent().show();
        $("#preQuickSetting").attr("href", "setup.html");
        $("#preToStatus").attr("href", "status.html");
    }
}

function linkToStatus(page) {
    util.setCookie("page", page, 24);
    util.changePageByUrl("login.html");
}

function logout() {
    if (util.showConfirm($.i18n.prop("confirm_logout"))) {
        util.showLoading();
        service.logout({}, function (result) {
            if (result.result) {
                updatePageByLoginStatus(loginStatus.logout);
            } else {
                util.showAlert($.i18n.prop("logout_fail"));
            }
            util.hideLoading();
        });
    }
}

function initLanguage() {
    var info = service.GetLanguage();
    var lang = info.Language;
    $("#selLang").val(lang);
    $("#selLang").selectmenu("refresh");
    util.translate("mobile", lang);
    bindChangeLanguageHandler();
}

function bindChangeLanguageHandler() {
    $("#selLang").bind("change", function (event, ui) {
        var lang = $("#selLang").val()
        service.SetLanguage(function () {
            util.translate("mobile", lang);
        }, lang);
    });
}
