/**
 * login 模块
 * @module login
 * @class login
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'config/menu', "logout" ],
    function ($, ko, config, service, _, menu, logout) {

        var pageState = {LOGIN:0, WAIT_PIN:1, WAIT_PUK:2, PUK_LOCKED:3, LOGGEDIN:4, LOADING:5};
        var timer = startLoginStatusInterval();
        var loginLockTimer = 0;
        /**
         * 获取网络、SIM、WIFI等状态
         * @method getStatusInfo
         */
        var getStatusInfo = function () {
            return service.getStatusInfo();
        };
        function startLoginStatusInterval() {
            return setInterval(function () {
                var info = service.getStatusInfo();
                if (!info.isLoggedIn) {
                    gotoLogin();
                    return;
                }
                lastLoginStatus = service.getStatusInfo().isLoggedIn ? "1" : "0";
            }, 1000);
        }

        /**
         * loginViewModel
         * @class loginVM
         */
        function loginVM() {
            var self = this;
	    self.adImages = config.AD_IMAGES;
            var type_2g = ["GSM", "GPRS", "EDGE"];
            var type_3g = ["UMTS", "WCDMA"];
            var type_h = ["HSUPA", "HSPA+","HSDPA"];
            var type_4g = ["LTE"];
            var statusInfo= getStatusInfo();
            var data = service.getLoginData();
            var loginStatus = service.getLoginStatus();
            self.password = ko.observable();
            self.PIN = ko.observable();
            self.PUK = ko.observable();
            self.newPIN = ko.observable();
            self.confirmPIN = ko.observable();
            self.pinNumber = ko.observable(data.pinnumber);
            self.pukNumber = ko.observable(data.puknumber);
            self.showEntrance = ko.observable(false);
            self.sharePathInvalid = ko.observable(false);
            self.loginCount = ko.observable(0);
            self.loginSecuritySupport = ko.observable(config.LOGIN_SECURITY_SUPPORT);

            var ssid = service.getWifiBasic().SSID;
            self.wifi_ssid = ko.observable($.i18n.prop("wifi_name")+" " +ssid);
            var pin_status_text = parseInt(statusInfo.pinStatus)==1?$.i18n.prop("enable"):$.i18n.prop("disable");
            self.sim_pin_status = ko.observable($.i18n.prop("sim_pin_status")+" "+pin_status_text);
            self.connect_Status = ko.observable('');
            if (checkConnectedStatus(statusInfo.connectStatus)) {
                self.speedTime = ko.observable(transUnit(parseInt(statusInfo.data_counter.currentReceived, 10) + parseInt(statusInfo.data_counter.currentSent, 10), false)+" / "+transSecond2Time(statusInfo.data_counter.currentConnectedTime));
                var networkTypeTmp = statusInfo.networkType.toLowerCase();
                if($.inArray(statusInfo.networkType.toUpperCase(),type_h)!= -1){
                    self.connect_Status($.i18n.prop("h_connected"));
                }else if($.inArray(statusInfo.networkType.toUpperCase(),type_4g)!= -1){
                    self.connect_Status($.i18n.prop("4g_connected"));
                }else if($.inArray(statusInfo.networkType.toUpperCase(),type_4g)!= -1){
                    self.connect_Status($.i18n.prop("3g_connected"));
                }else if($.inArray(statusInfo.networkType.toUpperCase(),type_2g)!= -1){
                    self.connect_Status($.i18n.prop("2g_connected"));
                }else if (networkTypeTmp == ''||networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service'||networkTypeTmp == 'limited service' || networkTypeTmp == 'no service') {
                    if(networkTypeTmp==""||networkTypeTmp=="limited service"){
                        networkTypeTmp = "limited_service";
                    }else if(networkTypeTmp=="no service"){
                        networkTypeTmp = "no_service";
                    }
                    self.connect_Status($.i18n.prop("network_type_" + networkTypeTmp));
                }
            } else {
                self.speedTime=ko.observable("0MB / "+transSecond2Time(0));
                var simstatus = statusInfo.simStatus == "modem_sim_undetected" || statusInfo.simStatus == "modem_sim_destroy";
                var pinstatus = statusInfo.simStatus == "modem_waitpin";
                var pukstatus = statusInfo.simStatus == "modem_waitpuk";
                var netlockstatus = statusInfo.simStatus == "modem_imsi_waitnck";
                if(simstatus){
                    self.connect_Status($.i18n.prop("no_sim"));
                }else if(pinstatus){
                    self.connect_Status($.i18n.prop("pin_lock"));
                }else if(pukstatus){
                    self.connect_Status($.i18n.prop("puk_lock"));
                }else if(netlockstatus){
                    self.connect_Status($.i18n.prop("network_lock"));
                }else{
                    if(statusInfo.connectStatus == 'ppp_disconnected'){
                        self.connect_Status($.i18n.prop("disconnected"));
                    } else if(statusInfo.connectStatus == 'ppp_connecting'){
                        self.connect_Status($.i18n.prop("connecting"));
                    } else {
                        self.connect_Status($.i18n.prop("disconnecting"));
                    }
                }
            }
            var smsInfo = service.getSmsCapability();
            self.messageInfo = ko.observable(statusInfo.smsUnreadCount+" / "+(smsInfo.nvUsed+smsInfo.simUsed));
            self.imagePath = ko.observable("img/4.png");
            self.wifiStatusImg = ko.observable(getWifiStatusImg(statusInfo.wifiStatus,statusInfo.attachedDevices.length));
            self.wifiText = ko.observable($.i18n.prop("wifi_devices_connected"));
	    self.batteryText = ko.observable("");
            self.leftSeconds = ko.observable(0);
            self.accountLocked = ko.computed(function () {
                return self.loginCount() == config.MAX_LOGIN_COUNT && self.leftSeconds() != '-1';
            });
            self.uiLoginTimer = ko.observable(300);
            self.leftUnlockTime = ko.computed(function () {
                self.leftSeconds();
                var formatted = transSecond2Time(self.uiLoginTimer());
                return formatted.substring(formatted.indexOf(':') + 1, formatted.length);
            });

            if(config.SD_CARD_SUPPORT){
                service.getSDConfiguration({}, function (data) {
                    self.showEntrance(data.sd_status == "1" && data.share_status == "1" && data.sd_mode == "0");
                    if(self.showEntrance()){
                        service.checkFileExists({
                            path: data.share_file
                        }, function (data1) {
                            if (data1.status == 'exist') {
                                self.sharePathInvalid(false);
                            } else {
                                self.sharePathInvalid(true);
                            }
                        });
                    }
                });
            }

            var state = computePageState(loginStatus, data);
            self.pageState = ko.observable(state);
            if (state == pageState.LOADING) {
                addTimeout(refreshPage, 500);
            }
            setFocus();
            $("#txtPwd").live("keyup",function(){
                if($.trim($("#txtPwd").val()).length>0){
                    $("#txtRequire").addClass("hide");
                    $("#txtRequire").html("");
                }else{
                    $("#txtRequire").removeClass("hide");
                    $("#txtRequire").html("required");
                }
            });
            /**
             * login 事件处理
             * @event login
             */
            self.login = function () {
                self.password($("#txtPwd").val());
                if($.trim(self.password())==""){
                    $("#txtRequire").removeClass("hide");
                    $("#txtRequire").html("required");
                    $("#txtPwd").focus();
                    return;
                }

                if(config.LOGIN_SECURITY_SUPPORT && self.accountLocked()){
                    showAlert("password_error_account_lock_time", function () {
                        setFocus();
                    });
                    return false;
                }
                self.pageState(pageState.LOADING);
                self.checkLoginData(function () {
                    setTimeout(function () {
                        self.loginAct();
                    }, config.LOGIN_SECURITY_SUPPORT && self.accountLocked() ? self.uiLoginTimer() * 1000 : 0);
                });
            };
            self.loginAct = function () {
                window.clearInterval(timer);

                service.login({
                    password:self.password()
                }, function (data) {
                    setTimeout(function () {
                        timer = startLoginStatusInterval();
                    }, 1300);
                    if (data.result) {
                        self.pageState(pageState.LOGGEDIN);
                        if(config.LOGIN_SECURITY_SUPPORT){
                            self.loginCount(0);
                            self.uiLoginTimer(300);
                            clearInterval(loginLockTimer);
                        }
                        if (config.UPGRADE_TYPE == "FOTA" || config.UPGRADE_TYPE == "OTA") {
                            var state = service.getNewVersionState();
                            if (state.hasNewVersion) {
                                config.HAS_OTA_NEW_VERSION = true;
                            } else {
                                var upgradeState = {};
                                upgradeState = service.getCurrentUpgradeState();
                                if (upgradeState.current_upgrade_state == 'upgrade_pack_redownload') {
                                    config.HAS_OTA_NEW_VERSION = true;
                                }
                            }
                        }
                        var curentHref = window.location.href;
						if(window.location.href.indexOf("?no_connect") != -1){
                            var info = service.getStatusInfo();
                            if(service.getEthernetConnect().is_rj45_connected){
                                window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + "#ethernet_settings";
                            } else {
                                window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + "#home";
                            }
						} else if(window.location.href.indexOf("?flow_beyond") != -1){
							window.location.href = curentHref.slice(0,curentHref.indexOf("?flow_beyond")) + "#traffic_alert";
						} else if(window.location.href.indexOf("?fota_upgrade") != -1){
							window.location.href = curentHref.slice(0,curentHref.indexOf("?fota_upgrade")) + "#ota_update";
						} else {
                        window.location.hash = "#home";
						}
                        menu.rebuild();
                        logout.init();
                    } else {
                        self.password("");
                        if(config.LOGIN_SECURITY_SUPPORT){
                            self.checkLoginData(function(){
                                if (self.loginCount() == config.MAX_LOGIN_COUNT) {
                                    showAlert("password_error_five_times", function () {
                                        $("#txtPwd").val("");
                                        setFocus();
                                    });
                                    self.startLoginLockInterval();
                                } else {
									if(!isNaN(self.loginCount())){
                                    showAlert({msg: 'password_error_left', params: [config.MAX_LOGIN_COUNT - self.loginCount()]}, function () {
                                        $("#txtPwd").val("");
                                        setFocus();
                                    });
									}
                                }
                            });
                        }else {
                            showAlert("password_error", function () {
                                $("#txtPwd").val("");
                                setFocus();
                            });
                        }
                        self.pageState(pageState.LOGIN);
                    }
                });
            };

            /**
             * 启动倒计时定时器。
             * @method startLoginLockInterval
             */
            self.startLoginLockInterval = function () {
                loginLockTimer = setInterval(function () {
                    service.getLoginData({}, function (data) {
                        if (data.login_lock_time <= 0 || data.psw_fail_num_str == 5) {
                            self.loginCount(0);
                            clearInterval(loginLockTimer);
                        }
                        if(self.leftSeconds() != data.login_lock_time){
                            self.leftSeconds(data.login_lock_time);
                            self.uiLoginTimer(data.login_lock_time);
                        } else {
                            self.uiLoginTimer(self.uiLoginTimer() > 0 ? self.uiLoginTimer() - 1 : 0);
                        }
                    });
                }, 1000);
            };

            self.checkLoginData = function(cb){
                service.getLoginData({}, function(r){
                    var failTimes = parseInt(r.psw_fail_num_str, 10);
                    self.loginCount(config.MAX_LOGIN_COUNT - failTimes);
                    self.leftSeconds(r.login_lock_time);
                    self.uiLoginTimer(r.login_lock_time);
                    if($.isFunction(cb)){
                        cb();
                    } else if (self.loginCount() == config.MAX_LOGIN_COUNT) {
                        self.startLoginLockInterval();
                    }
                });
            };

            self.checkLoginData();

            /**
             * 验证输入PIN事件处理
             *
             * @event enterPIN
             */
            self.enterPIN = function () {
                self.pageState(pageState.LOADING);
                var pin = self.PIN();
                service.enterPIN({
                    PinNumber:pin
                }, function (data) {
                    if (!data.result) {
                        showAlert("pin_error", function () {
                            refreshPage();
                        });
                        self.PIN('');
                    } else {
                        refreshPage();
                    }
                });
            };

            /**
             * 输入PUK设置新PIN事件处理
             *
             * @event enterPUK
             */
            self.enterPUK = function () {
                self.pageState(pageState.LOADING);
                var newPIN = self.newPIN();
                var confirmPIN = self.confirmPIN();
                var params = {};
                params.PinNumber = newPIN;
                params.PUKNumber = self.PUK();
                service.enterPUK(params, function (data) {
                    if (!data.result) {
                        showAlert("puk_error", function () {
                            refreshPage();
                        });
                        self.PUK('');
                        self.newPIN('');
                        self.confirmPIN('');
                    } else {
                        refreshPage();
                    }
                });
            };
            /**
             * 刷新页面状态
             *
             * @method refreshPage
             */
            function refreshPage() {
                var data = service.getLoginData();
                var loginStatus = service.getLoginStatus();
                var state = computePageState(loginStatus, data);
                if (state == pageState.LOADING) {
                    addTimeout(refreshPage, 500);
                } else {
                    self.pageState(state);
                    if(state==0){
                        $("#container").css({'margin-top':'0px', 'margin-bottom':'0px'});
                    }
                    self.pinNumber(data.pinnumber);
                    self.pukNumber(data.puknumber);
                }
                setFocus();
            }

            function setFocus(){
                setTimeout(function () {
                    var txtPwd = $('#txtPwd:visible');
                    var txtPIN = $('#txtPIN:visible');
                    var txtPUK = $('#txtPUK:visible');
                    if (txtPwd.length > 0) {
                        txtPwd.focus();
                    } else if (txtPIN.length > 0) {
                        txtPIN.focus();
                    } else if (txtPUK.length > 0) {
                        txtPUK.focus();
                    }
                }, 100);
            }

            /**
             * 根据登录状态和SIM卡状态设置页面状态
             * @method computePageState
             */
            function computePageState(loginStatus, data) {
                //PX-880 先登录再进行PIN验证，由于router设计原因，登录后，PIN验证不在登录页面进行，和数据卡的验证保持一致。
                if (config.LOGIN_THEN_CHECK_PIN) {
                    return checkPinAfterLogin(loginStatus, data);
                } else {
                    return loginAfterCheckPin(loginStatus, data);
                }
            }

            function checkPinAfterLogin(loginStatus, data) {
                if (loginStatus.status == "loggedIn") {
                    if (state == "modem_waitpin") {
                        return pageState.WAIT_PIN;
                    } else if ((state == "modem_waitpuk" || data.pinnumber == 0) && (data.puknumber != 0)) {
                        return pageState.WAIT_PUK;
                    } else if ((data.puknumber == 0 || state == "modem_sim_destroy")
                        && state != "modem_sim_undetected" && state != "modem_undetected") {
                        return pageState.PUK_LOCKED;
                    } else {
                        return pageState.LOGGEDIN;
                    }
                } else {
                    var state = data.modem_main_state;
                    if ($.inArray(state, config.TEMPORARY_MODEM_MAIN_STATE) != -1) {
                        return pageState.LOADING;
                    } else {
                        return pageState.LOGIN;
                    }
                }
            }

            function loginAfterCheckPin(loginStatus, data) {
                if (loginStatus.status == "loggedIn") {
                    return pageState.LOGGEDIN;
                } else {
                    var state = data.modem_main_state;
                    if ($.inArray(state, config.TEMPORARY_MODEM_MAIN_STATE) != -1) {
                        return pageState.LOADING;
                    } else if (state == "modem_waitpin") {
                        return pageState.WAIT_PIN;
                    } else if ((state == "modem_waitpuk" || data.pinnumber == 0) && (data.puknumber != 0)) {
                        return pageState.WAIT_PUK;
                    } else if ((data.puknumber == 0 || state == "modem_sim_destroy")
                        && state != "modem_sim_undetected" && state != "modem_undetected") {
                        return pageState.PUK_LOCKED;
                    } else {
                        return pageState.LOGIN;
                    }
                }
            }
        }
        function refreshHomeData(vm){
            var info = getStatusInfo();
            if (checkConnectedStatus(info.connectStatus)) {
                vm.speedTime(transUnit(parseInt(info.data_counter.currentReceived, 10) + parseInt(info.data_counter.currentSent, 10), false)+" / "+transSecond2Time(info.data_counter.currentConnectedTime));
            } else {
                vm.speedTime("0MB / "+transSecond2Time(0));
            }
            setImagePath(vm,info);
            setConnectedStatus(vm,info);
            setWifiImage(vm,info);
            var pin_status_text = parseInt(info.pinStatus)==1?$.i18n.prop("enable"):$.i18n.prop("disable");
            vm.sim_pin_status($.i18n.prop("sim_pin_status")+" "+pin_status_text);
        }
        /**
         * 根据wifi状态获取wifi的图片资源
         * @method getWifiStatusImg
         */
        function getWifiStatusImg(status, deviceSize) {
            if (status) {
                if (deviceSize == 0) {
                    return "img/wifi_0.png";
                } else {
                    return "img/wifi_" + deviceSize + ".png";
                }
            } else {
                return "img/wifi_0.png";
            }
        }
        /**
         * 将电量转化为对应图片
         * @method convertBatteryPers
         * @param vm
         * @param status
         */
        function convertBatteryPers(pers, status) {
            var txt = ""
            if ("0" == status) {
                txt = pers+"% Left";
            } else {
                if(parseInt(pers)<100){
                    txt = "Charging "+parseInt(pers)+"% complete";
                }else{
                    txt = "Charging complete";
                }
            }
            return txt;
        }
        //设置联网状态图片
        function setImagePath(self,statusInfo){
            if(statusInfo.signalImg=="1"){
                self.imagePath("img/5.png");
            }else if(statusInfo.signalImg=="2"){
                self.imagePath("img/6.png");
            }else if(statusInfo.signalImg=="3"){
                self.imagePath("img/7.png");
            }else if(statusInfo.signalImg=="4"){
                self.imagePath("img/8.png");
            }else if(statusInfo.signalImg=="5"){
                self.imagePath("img/9.png");
            }else {
                self.imagePath("img/4.png");
            }

        }
        //设置联网状态文字
        function setConnectedStatus(self,statusInfo){
            if(checkConnectedStatus(statusInfo.connectStatus)){
                var type_2g = ["GSM", "GPRS", "EDGE"];
                var type_3g = ["UMTS", "WCDMA"];
                var type_h = ["HSUPA", "HSPA", "HSPA+", "DC-HSPA+","HSDPA"];
                var type_4g = ["LTE"];
                var networkTypeTmp = statusInfo.networkType.toLowerCase();
                if($.inArray(statusInfo.networkType.toUpperCase(),type_h)!= -1){
                    self.connect_Status($.i18n.prop("h_connected"));
                }else if($.inArray(statusInfo.networkType.toUpperCase(),type_4g)!= -1){
                    self.connect_Status($.i18n.prop("4g_connected"));
                }else if($.inArray(statusInfo.networkType.toUpperCase(),type_3g)!= -1){
                    self.connect_Status($.i18n.prop("3g_connected"));
                }else if($.inArray(statusInfo.networkType.toUpperCase(),type_2g)!= -1){
                    self.connect_Status($.i18n.prop("2g_connected"));
                }else if (networkTypeTmp == ''||networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service'||networkTypeTmp == 'limited service' || networkTypeTmp == 'no service') {
                    if(networkTypeTmp==""||networkTypeTmp=="limited service"){
                        networkTypeTmp = "limited_service";
                    }else if(networkTypeTmp=="no service"){
                        networkTypeTmp = "no_service";
                    }
                    self.connect_Status($.i18n.prop("network_type_" + networkTypeTmp));
                }else{
                    self.connect_Status($.i18n.prop("connected"));
                }
            }else{
                var simstatus = statusInfo.simStatus == "modem_sim_undetected";
                var pukblock = statusInfo.simStatus == "modem_sim_destroy";
                var pinstatus = statusInfo.simStatus == "modem_waitpin";
                var pukstatus = statusInfo.simStatus == "modem_waitpuk";
                var netlockstatus = statusInfo.simStatus == "modem_imsi_waitnck";
                if(simstatus){
                    self.connect_Status($.i18n.prop("no_sim"));
                }else if(pukblock){
                    self.connect_Status($.i18n.prop("puk_block"));
                }else if(pinstatus){
                    self.connect_Status($.i18n.prop("pin_lock"));
                }else if(pukstatus){
                    self.connect_Status($.i18n.prop("puk_lock"));
                }else if(netlockstatus){
                    self.connect_Status($.i18n.prop("network_lock"));
                }else{
                    self.connect_Status($.i18n.prop("disconnected"));
                }

            }
        }
        //设置短信信息
        function setMessageInfo(self){
            var statusInfo = getStatusInfo();
            service.getSmsCapability({},function(smsInfo){
				self.messageInfo (statusInfo.smsUnreadCount+" / "+(smsInfo.nvUsed+smsInfo.simUsed));
			});            
        }
        //设置wifi图片和电池电量
        function setWifiImage(self,info){
            self.wifiStatusImg(getWifiStatusImg(info.wifiStatus, info.attachedDevices.length));
            self.batteryText(convertBatteryPers(info.battery_value, info.batteryStatus));
        }
        /**
         * 登录页背景高度自适应
         * @method resizeLoginPage
         */
        function resizeLoginPage() {
            if (window.location.hash != '#login') {
                return false;
            }
            var mainContainer = $("#mainContainer");
            var windowH = $(window).height();
            var statusH = $("#topStatus").outerHeight(true);
            var footerH = $("#footer").outerHeight(true);
            var containerHeight = windowH - statusH - mainContainer.height() - footerH;
            if (containerHeight > 0) {
                var h = windowH - statusH - footerH - 5;
                mainContainer.height(h + 'px');
                var container = $("#container");
                var margin = (h - container.height()) / 2;
                container.css({'margin-top':margin + 'px', 'margin-bottom':margin + 'px'});
            }
        }

        /**
         * 初始化ViewModel
         *
         * @method init
         */
        function init() {
            var info = service.getStatusInfo();
	    			if(window.location.href.indexOf("?no_connect") != -1){
                if(service.getEthernetConnect().is_rj45_connected){
                    showPromptNoImg("pppoe_error_jump");
                } else {
                    if(info.simStatus == "modem_sim_undetected"){
                        showPromptNoImg("no_simcard_jump");
                    } else if(info.simStatus == "modem_sim_destroy" || info.simStatus == "modem_destroy") {
                        showPromptNoImg("invalid_simcard_jump");
                    }else if(info.simStatus == "modem_imsi_waitnck"  || info.simStatus == "modem_waitpin"|| info.simStatus == "modem_waitpuk") {
                        showPromptNoImg("locked_simcard_jump");
                    } else {
                        if(info.ppp_dial_conn_fail_counter == '0' || info.ppp_dial_conn_fail_counter == ''){
                            showPromptNoImg("no_connect_jump");
                        } else {
                            showPromptNoImg("connect_failed_jump");
                        }
                    }
                }
			} else if(window.location.href.indexOf("?flow_beyond") != -1){
                showPromptNoImg("flow_beyond_jump",function(){
                    service.setRedirectOff();
                });
			} else if(window.location.href.indexOf("?fota_upgrade") != -1){
                showPromptNoImg("fota_upgrade_jump",function(){
                    service.setRedirectOff();
                });
			}
            if (info.isLoggedIn) {
                window.location.hash = '#home';
                return;
            }

            var container = $('#container')[0];
            ko.cleanNode(container);
            var vm = new loginVM();
            ko.applyBindings(vm, container);
            resizeLoginPage();
            refreshHomeData(vm);
            addInterval(function() {
                refreshHomeData(vm);
            }, 1000);
            setInterval(function(){
                setMessageInfo(vm);
            },1500);
            var throttleTimeout;
            $(window).bind('resize', function () {
                if ($.browser.msie) {
                    if (!throttleTimeout) {
                        throttleTimeout = setTimeout(function () {
                            resizeLoginPage();
                            throttleTimeout = null;
                        }, 50);
                    }
                } else {
                    resizeLoginPage();
                }
            });
            $('#frmPIN').validate({
                submitHandler:function () {
                    vm.enterPIN();
                },
                rules:{
                    txtPIN:"pin_check"
                }
            });
            $('#frmPUK').validate({
                submitHandler:function () {
                    vm.enterPUK();
                },
                rules:{
                    txtNewPIN:"pin_check",
                    txtConfirmPIN:{equalTo:"#txtNewPIN"},
                    txtPUK:"puk_check"
                }
            });

            $("#txtPwd").keyup(function(event){
                if(event.keyCode == 13){
                    vm.login();
                }
            });
            $("#btnLogin").bind("click",function(){
                vm.login();
            });
        }

        function gotoLogin() {
            if (window.location.hash != config.defaultRoute && _.indexOf(config.GUEST_HASH, window.location.hash) == -1) {
                if (!manualLogout && lastLoginStatus == "1") {
                    manualLogout = false;
                    lastLoginStatus = 'UNREAL';
                    showAlert('need_login_again', function () {
                        window.location = "index.html";
                    });
                }
                else if (lastLoginStatus == 'UNREAL') {
                    //do nothing, only popup need_login_again alert one time
                    return;
                }
                else {
                    window.location = "index.html";
                }

            }
        }

        return {
            init:init,
            gotoLogin:gotoLogin
        };
    });