# create by zhangzhen for ping client ip or domain
#!/bin/sh
ping_result_patch="/tmp/PingMessages"

ping_ip_domain=$1

ip_version=$2

if [ "$ping_ip_domain" == "" ] ; then
  echo "$0: no ping_ip_domain in, exit!"
  exit 1
fi

cfg set ping_reply=""
v4_received_num="0"
v6_received_num="0"
v4_ping_flag=""

if [ "$ip_version" = "4" ] ; then
	busybox ping -4 $ping_ip_domain -c 4 -s 1 > $ping_result_patch
	v4_received_num=`cat $ping_result_patch | grep -i received | awk '{print $4}'`
	if [ "$v4_received_num" = "" ] ; then
		v4_received_num="0"
		echo "Can't ping [$ping_ip_domain]" > $ping_result_patch
	fi
fi	

if [ "$ip_version" = "6" ] ; then
    busybox ping -6 $ping_ip_domain -c 4 -s 1 > $ping_result_patch  
    v6_received_num=`cat $ping_result_patch | grep -i received | awk '{print $4}'`	
	if [ "$v6_received_num" = "" ] ; then
		v6_received_num="0"
		echo "Can't ping [$ping_ip_domain]" > $ping_result_patch
	fi
fi

if [ "$ip_version" = "46" ] ; then
    echo "ping [$ping_ip_domain] through ipv4 network,result as follow:" > $ping_result_patch   
    busybox ping -4 $ping_ip_domain -c 4 -s 1 >> $ping_result_patch 
	v4_received_num=`cat $ping_result_patch | grep -i received | awk 'NR==1 {print $4}'`
	if [ "$v4_received_num" = "" ] ; then
		v4_received_num="0"
		v4_ping_flag="1"
		echo "Can't ping [$ping_ip_domain] through ipv4 network" >> $ping_result_patch
	fi
	echo " " >> $ping_result_patch   
    echo "ping [$ping_ip_domain] through ipv6 network,result as follow:" >> $ping_result_patch   	
    busybox ping -6 $ping_ip_domain -c 4 -s 1 >> $ping_result_patch
    if [ "$v4_ping_flag" = "1" ] ; then	
		v6_received_num=`cat $ping_result_patch | grep -i received | awk 'NR==1 {print $4}'`	
	else
        v6_received_num=`cat $ping_result_patch | grep -i received | awk 'NR==2 {print $4}'`	
	fi
	
	if [ "$v6_received_num" = "" ] ; then
		v6_received_num="0"
		echo "Can't ping [$ping_ip_domain] through ipv6 network" >> $ping_result_patch
	fi
fi

if [ "$v4_received_num" -gt 0 -o "$v6_received_num" -gt 0 ] ; then
    echo "can ping $ping_ip_domain"
	cfg set ping_reply="1"
else
    echo "cann't ping $ping_ip_domain"
	cfg set ping_reply="0"
fi
cfg save