#! /bin/sh --
PRIVATE_APN_IPV6_RANGE_0=`cfg get private_ipv6_range_0`
PRIVATE_APN_IPV6_RANGE_1=`cfg get private_ipv6_range_1`
PRIVATE_APN_IPV6_RANGE_2=`cfg get private_ipv6_range_2`
PRIVATE_APN_IPV6_RANGE_3=`cfg get private_ipv6_range_3`
PRIVATE_APN_IPV6_RANGE_4=`cfg get private_ipv6_range_4`

PRIVATE_APN_INTERFACE=`cfg get multi_pdns_wan_v4_dev_name_1`
PRIVATE_APN_V6INTERFACE=`cfg get multi_pdns_wan_v6_dev_name_1`
PRIVATE_APN_WAN_IP=`cfg get multi_pdns_wan_ipaddr_1`
PRIVATE_APN_WAN_IPV6=`cfg get multi_pdns_ipv6_wan_ipaddr_1`
PRIVATE_APN_PPP_STATUS=`cfg get multi_pdns_ppp_status_1`
prior_conf_del_path="/tmp/prior_conf_del.sh"

echo "%%%%%"

sh $prior_conf_del_path 
echo "#this sheel script just a temp scripts for mult apn" > $prior_conf_del_path

ip_range_set_v4()
{
	echo "enter ip_range_set_v4"
    PRIVATE_APN_IP_RANGE=$1
	if [ "$PRIVATE_APN_IP_RANGE" != "" ]; then
		ip_range=`echo ${PRIVATE_APN_IP_RANGE} | cut -d ',' -f 1`
		range_set_status=`echo ${PRIVATE_APN_IP_RANGE} | cut -d ',' -f 2`
		if [ "$range_set_status" == "1" ];then
			iptables -t mangle -A PREROUTING -m iprange --dst-range $ip_range -j MARK --set-mark 3
			if [ $? -ne 0 ]; then
				return $?
			fi
			echo iptables -t mangle -D PREROUTING -m iprange --dst-range $ip_range -j MARK --set-mark 3 >> $prior_conf_del_path
		fi
	fi
	return 0
}

ip_range_set_v6()
{    
	echo "enter ip_range_set_v6"
    PRIVATE_APN_IP_RANGE_V6=$1
	if [ "$PRIVATE_APN_IP_RANGE" != "" ]; then
		ip_range_v6=`echo ${PRIVATE_APN_IP_RANGE_V6} | cut -d ',' -f 1`
		range_set_status_v6=`echo ${PRIVATE_APN_IP_RANGE} | cut -d ',' -f 2`
		if [ "$range_set_status" == "1" ];then
			ip6tables -A PREROUTING -t mangle -m iprange --dst-range $ip_range_v6 -j MARK --set-mark 3
			if [ $? -ne 0 ]; then
				return $?
			fi
			echo ip6tables -t mangle -D PREROUTING -m iprange --dst-range $ip_range_v6 -j MARK --set-mark 3 >> $prior_conf_del_path
		fi
	fi
	return 0
}

set_private_v4()
{
	echo "enter set_private_v4"
	ipv4_range_valid="none"
	for i in `seq 0 4`
	do  
		rule="private_ip_range_"$i
		private_apn_ip_range=`cfg get ${rule}`
		if [ "" != "$private_apn_ip_range" ]; then
			ipv4_range_valid="yes"
		fi
	done  
	
	if [ "yes" = "$ipv4_range_valid" ]; then
		echo "get rules"
	else
		echo "no rules, exit"
		exit
	fi
	
	echo "set_private_v4, setup rules"

    echo ip rule delete fwmark 3 table 3 >> $prior_conf_del_path
	
	echo ip route delete table 3 via $PRIVATE_APN_WAN_IP dev $PRIVATE_APN_INTERFACE >> $prior_conf_del_path
	
	#echo iptables -t nat -D POSTROUTING -o $PRIVATE_APN_INTERFACE -j MASQUERADE >> $prior_conf_del_path

	ip route add table 3 via $PRIVATE_APN_WAN_IP dev $PRIVATE_APN_INTERFACE 
	
	if [ $? -ne 0 ]; then
		return $?
	fi
	
	ip rule add fwmark 3 table 3
	if [ $? -ne 0 ]; then
		return $?
	fi
	
	ip route flush cache
	if [ $? -ne 0 ]; then
		return $?
	fi
	iptables -t nat -D POSTROUTING -o $PRIVATE_APN_INTERFACE -j MASQUERADE 
	iptables -t nat -D POSTROUTING -o $PRIVATE_APN_INTERFACE -j MASQUERADE 
	iptables -t nat -A POSTROUTING -o $PRIVATE_APN_INTERFACE -j MASQUERADE 
	if [ $? -ne 0 ]; then
		return $?
	fi
    
	for i in `seq 0 4`
	do  
		rule="private_ip_range_"$i
		private_apn_ip_range=`cfg get ${rule}`
		ip_range_set_v4 $private_apn_ip_range
		if [ $? -ne 0 ];then
			return $?
		fi
	done  
	
	return 0
	
}

set_private_v6()
{
	echo "enter set_private_v6"
	if [ "$PRIVATE_APN_IPV6_RANGE" == "" ]; then
		return -1
	fi
	
	echo ip -6 rule delete fwmark 3 table 3 >> $prior_conf_del_path
	
	echo ip -6 route delete table 3 via $PRIVATE_APN_WAN_IPV6 dev $PRIVATE_APN_V6INTERFACE  >> $prior_conf_del_path
	
	echo ip6tables -D PREROUTING -t mangle -m iprange --dst-range $PRIVATE_APN_IPV6_RANGE -j MARK --set-mark 3 >> $prior_conf_del_path
	
#	echo iptables -t nat -D POSTROUTING -o $PRIVATE_APN_V6INTERFACE -j MASQUERADE >> $prior_conf_del_path
	
	ip -6 route add table 3 via $PRIVATE_APN_WAN_IPV6 dev $PRIVATE_APN_V6INTERFACE 
	if [ $? -ne 0 ]; then
		return $?
	fi
	
	ip -6 rule add fwmark 3 table 3 
	if [ $? -ne 0 ]; then
		return $?
	fi
	
	iptables -t nat -A POSTROUTING -o $PRIVATE_APN_V6INTERFACE -j MASQUERADE
	if [ $? -ne 0 ]; then
		return $?
	fi
	
	
	
	for i in `seq 0 4`
	do  
		rule="private_ip_range_"$i
		private_apn_ip_range=`cfg get ${rule}`
		ip_range_set_v4 $private_apn_ip_range
		if [ $? -ne 0 ];then
			return $?
		fi
	done  
	
	return 0
	
}

# just for test
#set_private_v4 

echo "enter main"
if [ "$PRIVATE_APN_PPP_STATUS" == "ppp_connected" ]; then
    set_private_v4
	if [ $? -ne 0 ];then
		return $?
	fi
elif [ "$PRIVATE_APN_PPP_STATUS" == "ipv6_connected" ]; then
    echo "ipv6_connected not make mult router" 
    return 1
#   set_private_v6
#   if [ $? -ne 0 ];then
#        return $?
#   fi
elif [ "$PRIVATE_APN_PPP_STATUS" == "ipv4_ipv6_connected" ]; then
    set_private_v4
#   set_private_v6
    if [ $? -ne 0 ];then
        return $?
    fi
elif [ "$PRIVATE_APN_PPP_STATUS" == "ppp_disconnected" ]; then
    echo ppp_diconnected!
	return 1
else
	echo unknow ppp_status!
	return 1
fi