/**
 */
define(['jquery', 'knockout', 'config/config', 'service' ],


    function($, ko, config, service) {
        var phonenumberTime;

		function prepaidnumberViewModel(){
            var self = this;
            var data = service.getHeaderInfo_Tel();
            self.prepaidnumber = ko.observable(verifyDeviceInfo_index(data.msisdn_Tel));
		}

        function verifyDeviceInfo_index(field) {
            if (field && field != "") {
                return $.i18n.prop("prepaidnumber_index")+" "+field;
            } else {
                return " ";
            }
        }
		
    	/**
    	 *
    	 * @method init
    	 */
        function init() {
            var container = $('#prepaidnumber');
            ko.cleanNode(container[0]);
            var vm = new prepaidnumberViewModel();
            ko.applyBindings(vm, container[0]);

            var prepaidnumber = setInterval(function () {
                service.getHeaderInfo_Tel({}, function (data) {
                    vm.prepaidnumber(verifyDeviceInfo_index(data.msisdn_Tel));
                    if(data.phonenumber && data.phonenumber != ""){
                        clearInterval(prepaidnumber);
                    };
                });
            }, 2000);

        }

        return {
            init : init
        };
    }
);
