/**
 * 联网设置模块
 * @module dial_setting
 * @class dial_setting
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'status/statusBar' ],

function($, ko, config, service, _,statusBar) {

    /**
     * 联网设置view model
     * @class DialVM
     */
	function DialVM() {
		var mode = service.getConnectionMode();
		var self = this;
        var info = service.getConnectionInfo();
		self.selectMode = ko.observable(mode.connectionMode);
        self.enableFlag = ko.observable(true);
        self.isAllowedRoaming = ko.observable(mode.isAllowedRoaming);
	var originalRoaming = mode.isAllowedRoaming;
        self.connectStatus = ko.observable(info.connectStatus);
        self.transText = ko.dependentObservable(function() {
            if (checkConnectedStatus(self.connectStatus())) {
                $("#btnConnect").attr("class","btnConnect_connect");
                return "disconnect";
            }else if(checkConnectingStatus(self.connectStatus())){
                return "connecting";
            }else if(checkDisconnectingStatus(self.connectStatus())){
                return "disconnecting";
            }else{
                $("#btnConnect").attr("class","btnConnect_disconnect");
                return "connect";
            }
        });
        self.canConnect = ko.observable(getCanConnectNetWork());
        self.connectStatusText = ko.dependentObservable(function() {
            self.canConnect();

            /*if (checkConnectedStatus(self.connectStatus())) {
             return $.i18n.prop("disconnect");
             } else {
             return $.i18n.prop("connect");
             }*/

            if (checkConnectedStatus(self.connectStatus())) {
                $("#btnConnect").attr("class","btnConnect_connect");
                return $.i18n.prop("disconnect");
            }else if(checkConnectingStatus(self.connectStatus())){
                return $.i18n.prop("connecting");
            }else if(checkDisconnectingStatus(self.connectStatus())){
                return $.i18n.prop("disconnecting");
            }else{
                $("#btnConnect").attr("class","btnConnect_disconnect");
                return $.i18n.prop("connect");
            }
        });
        self.setAllowedRoaming = function() {
            if(!$("#roamBtn").hasClass("disable")){
                var checkbox = $("#isAllowedRoaming:checked");
                if(checkbox && checkbox.length == 0 ){
                    self.isAllowedRoaming("on");
                }else{
                    self.isAllowedRoaming("off");
                }
            }
        };

        /**
         * 修改联网模式
         * @method save
         */
        self.save = function () {
            showLoading();
            var selectMode = self.selectMode();
            //当选择自动时，下发原先的勾选状态
            if (selectMode == 'auto_dial') {
                originalRoaming = self.isAllowedRoaming();
            } else {
                self.isAllowedRoaming(originalRoaming);
            }
            service.setConnectionMode({
                connectionMode: selectMode,
                isAllowedRoaming: self.isAllowedRoaming()
            }, function (result) {
                if (result.result == "success") {
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        };
        /**
         * 响应连接按钮事件
         *
         * @event connectHandler
         */
        self.connectHandler = function() {
            if (checkConnectedStatus(self.connectStatus())) {
                showLoading('disconnecting');
                $("#btnConnect").attr("trans","disconnecting").translate();
                service.disconnect({}, function(data) {
                    if(data.result){
                        successOverlay("disconnect_success_info");
                        $("#homebtn").attr("trans","connect").translate();
                    } else {
                        errorOverlay();
                        $("#homebtn").attr("trans","disconnect").translate();
                    }
                });
            } else {
                if(service.getStatusInfo().roamingStatus && service.getStatusInfo().roamMode == "off") {
                    showAlert("dial_roam_info");
                }
                else {
                    self.connect();
                }
            }
        };

        self.connect = function() {
            var statusInfo = service.getStatusInfo();
            var trafficResult = statusBar.getTrafficResult(statusInfo);
            if(statusInfo.limitVolumeEnable && trafficResult.showConfirm){
                var confirmMsg = null;
                if(trafficResult.usedPercent > 100){
                    confirmMsg = {msg: 'traffic_beyond_connect_msg'};
                    statusBar.setTrafficAlertPopuped(true);
                } else {
                    confirmMsg = {msg: 'traffic_limit_connect_msg', params: [trafficResult.limitPercent]};
                    statusBar.setTrafficAlert100Popuped(false);
                }
                showConfirm(confirmMsg, function(){
                    doConnect();
                });
            }else{
                doConnect();
            }
        };
        var checkbox = $(".checkboxToggle");
        self.checkEnable = function() {
            var status = service.getStatusInfo();

            if (checkConnectedStatus(status.connectStatus) || status.connectStatus == "ppp_connecting") {
                self.enableFlag(false);
                disableCheckbox(checkbox);
            }
            else {
                self.enableFlag(true);
                enableCheckbox(checkbox);
            }
        };

	}
    function refreshConnectionStatus(vm){
        var info = service.getConnectionInfo();
        vm.canConnect(getCanConnectNetWork());
        vm.connectStatus(info.connectStatus);
        vm.checkEnable();
    }
    function doConnect(){
        showLoading('connecting');
        $("#btnConnect").attr("trans","connecting").translate();
        service.connect({}, function(data) {
            if(data.result){
                successOverlay("connect_success_info");
                $("#homebtn").attr("trans","disconnect").translate();
            } else {
                errorOverlay();
                $("#homebtn").attr("trans","connect").translate();
            }
        });
    }
    function getCanConnectNetWork(){
        var status = service.getStatusInfo();
        if (status.simStatus != "modem_init_complete") {
            return false;
        }

        if (checkConnectedStatus(status.connectStatus)) {
            if (config.AP_STATION_SUPPORT) {               
                if (status.ap_station_enable) {
                    var result = service.getConnectionMode();
                    if (result.connectionMode == "auto_dial") {
                        return false;
                    }
                }
            }
            return true;
        }

        //如果已联网，但是没有信号，断网按钮需要可以用
        if (status.signalImg == "0") {
            return false;
        }
        var networkTypeTmp = status.networkType.toLowerCase();
        if (networkTypeTmp == '' || networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service') {
            return false;
        }
        if("ppp_connecting"==status.connectStatus || "ppp_disconnecting"==status.connectStatus){
            return false;
        }
        if (config.AP_STATION_SUPPORT) {
            //var ap = service.getAPStationBasic()

            if (status.connectWifiStatus == "connect") {
                if (status.ap_station_mode == "wifi_pref") {
                    return false;
                }
            }
        }

        return true;
    }
    /**
     * 联网设置初始化
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new DialVM();
		ko.applyBindings(vm, container[0]);
        $('#frmDialSetting').validate({
            submitHandler : function() {
                vm.connectHandler();
            }
        });
        //vm.checkEnable();
        refreshConnectionStatus(vm);
        //addInterval( vm.checkEnable, 1000);
        addInterval(function(){refreshConnectionStatus(vm);},1000);
	}
	
	return {
		init: init
	};
});