#!/bin/sh
# ===========================================================
# usage: tayga.sh
# just for tayga up call
clat_switch=$1
default_calt0conf="/tmp/tayga-default.conf"
current_calt0conf="/tmp/tayga.conf"
dynamic_pool="192.168.255.0/24"
data_dir="/var/db/tayga"
#clat_switch=`cfg get clat_ipv6_enable`
ip6_connection_status=`cfg get ppp_status`
ip6_wan_addr=`cfg get ipv6_wan_addr`
current_wan_interface=`cfg get current_wan_interface`

clat_interface="clat0"
#creat default_calt0conf
if [ ! -f "$default_calt0conf" ]
then
	echo tun-device $clat_interface >> $default_calt0conf
	echo ipv4-addr 192.168.255.1 >> $default_calt0conf
	echo prefix 2001:db8:1:ffff::/96 >> $default_calt0conf
	echo dynamic-pool 192.168.255.0/24 >> $default_calt0conf
	echo data-dir /var/db/tayga >> $default_calt0conf
fi
	
if [ "1" == "$clat_switch" ]
then
	if [ "ipv6_connected" != "$ip6_connection_status" ]
	then
		echo unexpected status
		exit
	fi
	
	while [ "ip6_wan_addr" == "::" ]
	do
		sleep 2
		ip6_connection_status=`cfg get ipv6_wan_addr`
	done
	#init interface clat0
	tayga --mktun -c $default_calt0conf
	ip link set $clat_interface up
	echo 1 > /proc/sys/net/ipv4/ip_forward
	
#check whether need to start clat	
#	current_hmcc=`cfg get hmcc`
#	current_hmnc=`cfg get hmnc`
#	current_mncmcc=${current_hmcc}${current_hmnc}
#	current_clat_mncmcc=`cfg get mccmnc_clat`
#	if [ "current_mncmcc" == "current_clat_mncmcc" ]
#	then
#		echo it is ok!
#	else 
#		echo it no ok so not need to start clat!
#		exit
#	fi
#print tayga paramter
	echo *****print clat parameter********
	clat_v4_addr="192.168.255.1"
	clat_v4_map_addr=`cfg get clat_v4_map_addr`
	if [ "" == "$clat_v4_map_addr" ]
	then
		clat_v4_map_addr="192.0.0.4"
	fi
	router_msg get_plat_prefix &	
	plat_prefix=`cfg get plat_prefix`
	if [ "" == "$plat_prefix" ]
	then
		echo no plat_prefix!! please check it
		exit
	fi	
#	clat_wan_prefix=`cfg get ipv6_wan_prefix_info`
	clat_wan_prefix=`cat /tmp/ipv6_addr_full.txt | cut -b 1-19`
#	plat_prefix=`cfg get plat_prefix`
	clat_v6_map_addr=${clat_wan_prefix}:0:ffff:${clat_v4_map_addr}
	echo clat_interfac=$clat_interface
	echo clat_v4_addr=$clat_v4_addr
#	echo $clat_v6_addr
#	echo $plat_prefix
#	echo $dynamic_pool
	echo data_dir=$data_dir
	echo clat_v4_map_addr=$clat_v4_map_addr
	echo clat_v6_map_addr=$clat_v6_map_addr

#creat tayga.conf
    echo ********creat tayga.conf*********
	rm -f $current_calt0conf
	echo tun-device $clat_interface >> $current_calt0conf
	echo ipv4-addr $clat_v4_addr >> $current_calt0conf
	echo prefix $plat_prefix >> $current_calt0conf
	echo data-dir $data_dir >> $current_calt0conf
	echo map $clat_v4_map_addr $clat_v6_map_addr >> $current_calt0conf

#configure tayga
	echo  *******configure tayga router**********
	ip addr flush dev $clat_interface
	ip addr add $clat_v4_map_addr dev $clat_interface
	ip route delete default dev $current_wan_interface
	clat_mtu=`cfg get mtu`
	busybox ifconfig $clat_interface mtu $clat_mtu
	ip -6 route add $clat_v6_map_addr dev $clat_interface
#	ip -6 neigh add proxy $clat_v6_map_addr 
	ip route add default dev $clat_interface
	iptables -t nat -D POSTROUTING -o $clat_interface -j MASQUERADE
	iptables -t nat -I POSTROUTING 1 -o $clat_interface -j MASQUERADE
	killall -SIGTERM tayga
	tayga -c $current_calt0conf
elif [ "0" == "$clat_switch" ]
then
	echo ****close clat*******
	killall -SIGTERM tayga
	iptables -t nat -D POSTROUTING -o $clat_interface  -j MASQUERADE
	iptables -t filter -D FORWARD -i $clat_interface -j ACCEPT
	iptables -t filter -D FORWARD -o $clat_interface -j ACCEPT
	iptables -t filter -D FORWARD -i $clat_interface -j ACCEPT
	iptables -t filter -D FORWARD -o $clat_interface -j ACCEPT
	ip addr flush dev $clat_interface
	ip route delete default dev $clat_interface
	ip -6 route delete $clat_v6_map_addr dev $clat_interface
#	iptables -t nat -D POSTROUTING  -o $clat_interfac -j MASQUERADE
    ifconfig $clat_interface down
	ip route add default dev $current_wan_interface
fi
	
	
	


