#!/bin/sh 
## 
# added by gaofei @2016.11.24
# 

wan_mode=`cfg get opms_wan_mode`
ppp_status=`cfg get ppp_status`
wan_ip=`cfg get wan_ipaddr`
device_speed_limit_upload=`cfg get upload_width_manual`
device_speed_limit_download=`cfg get download_width_manual`
userspeedlimit_count=`cfg get userspeedlimit_count`
gw=`cfg get lan_ipaddr`
mask=`cfg get lan_netmask`
lan_network_segment=`ipcalc $gw $mask -mbpn | grep NETWORK | awk -F '=' '{print $2}'`
lan_network_segment_bits=`ipcalc $gw $mask -mbpn | grep PREFIX | awk -F '=' '{print $2}'`
#lan_network_segment="192.168.0.0"
#lan_network_segment_bits=24

# QoS only work in 4G mode
if [ "$wan_mode" != "PPP" -o "$wan_ip" == "0.0.0.0" -o "$wan_ip" == "" ]; then
	echo "NOTICE: QoS NOT set for wan_mode=$wan_mode, ppp_status=$ppp_status, wan_ip=$wan_ip!"
	return
fi

lan_if='bridge0'
wan_if=`cfg get current_wan_interface`

# Remove SFE when enable speed limit
if [ "$device_speed_limit_upload" == "" -a "$device_speed_limit_download" == "" -a $userspeedlimit_count < 1 ]; then
	echo "speed limit is disabled, so we need to enable SFE"
	modprobe shortcut_fe
	modprobe shortcut_fe_ipv6
	modprobe shortcut_fe_cm
	exit
else
	echo "NOTICE: speed-limit is enabled, SFE need to be removed!"
	rmmod shortcut-fe-cm
	rmmod shortcut-fe
	rmmod shortcut-fe-ipv6
fi

#added by gaofei for speedlimit @2016.11.25 begin
#download
iptables -t mangle -F SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -D POSTROUTING -j SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -D POSTROUTING -j SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -X SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -N SPEEDLIMIT_DOWNLOAD_CHAIN
iptables -t mangle -I POSTROUTING 1 -j SPEEDLIMIT_DOWNLOAD_CHAIN
#upload
iptables -t mangle -F SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -D PREROUTING -j SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -D PREROUTING -j SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -X SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -N SPEEDLIMIT_UPLOAD_CHAIN
iptables -t mangle -I PREROUTING 1 -j SPEEDLIMIT_UPLOAD_CHAIN
#added by gaofei for speedlimit @2016.11.25 end

#-------------------------------------download------------------------------------------
echo "set download speed limit parameter"
if [ "$device_speed_limit_download" == "" ]; then
	device_speed_limit_download="1000000" # 1000000kbit=1000mbit
fi
#flush download qdisc
tc qdisc delete dev $lan_if root handle 1:0 htb
#ʼ
tc qdisc add dev $lan_if root handle 1:0 htb default 100
tc class add dev $lan_if parent 1:0 classid 1:1 htb rate "$device_speed_limit_download"kbit
tc qdisc add dev $lan_if parent 1:1 handle 10: sfq perturb 10
##-----##
#Ĭ1:100
tc class add dev $lan_if parent 1:1 classid 1:100 htb rate "$device_speed_limit_download"kbit
tc qdisc add dev $lan_if parent 1:100 handle 100: sfq perturb 10
iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -d $lan_network_segment/$lan_network_segment_bits -j RETURN
iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -d $lan_network_segment/$lan_network_segment_bits -j MARK --set-mark 100
tc filter add dev $lan_if parent 1:0 protocol ip handle 100 fw classid 1:100
#Ծĳû
i=0
while [ $i -lt $userspeedlimit_count ]
do
	echo "i = [$i]"
	userspeedlimit=`cfg get userspeedlimit_$i`
	if [ "$userspeedlimit" != "" ]; then
		mac=`echo $userspeedlimit | cut -d "," -f 1`
		ip=`echo $userspeedlimit | cut -d "," -f 2`
		upload_speed=`echo $userspeedlimit | cut -d "," -f 3`
		download_speed=`echo $userspeedlimit | cut -d "," -f 4`
		echo "[userspeedlimit, mac, ip, up, down] = [$userspeedlimit, $mac, $ip, $upload_speed, $download_speed]"
		
		j=`expr $i + 1`
		tc class add dev $lan_if parent 1:1 classid 1:1$j htb rate "$download_speed"kbit
		tc qdisc add dev $lan_if parent 1:1$j handle 1$j: sfq perturb 10
		iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -d $ip/32 -j RETURN
		iptables -t mangle -I SPEEDLIMIT_DOWNLOAD_CHAIN -o $lan_if -d $ip/32 -j MARK --set-mark 1$j
		tc filter add dev $lan_if parent 1:0 protocol ip handle 1$j fw classid 1:1$j
	fi	
	i=`expr $i + 1`
done

#-------------------------------------upload------------------------------------------
echo "set upload speed limit parameter"
if [ "$device_speed_limit_upload" == "" ]; then
	device_speed_limit_upload="1000000" # 1000000kbit=1000mbit
fi
#flush download qdisc
tc qdisc delete dev $wan_if root handle 1:0 htb
#ʼϴ
tc qdisc add dev $wan_if root handle 1:0 htb default 100
tc class add dev $wan_if parent 1:0 classid 1:1 htb rate "$device_speed_limit_upload"kbit
tc qdisc add dev $wan_if parent 1:1 handle 10: sfq perturb 10
##-----##
#Ĭ1:100
tc class add dev $wan_if parent 1:1 classid 1:100 htb rate "$device_speed_limit_upload"kbit
tc qdisc add dev $wan_if parent 1:100 handle 100: sfq perturb 10
iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $lan_network_segment/$lan_network_segment_bits -j RETURN
iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $lan_network_segment/$lan_network_segment_bits -j MARK --set-mark 100
tc filter add dev $wan_if parent 1:0 protocol ip handle 100 fw classid 1:100
#Ծĳû
i=0
while [ $i -lt $userspeedlimit_count ]
do
	echo "i = [$i]"
	userspeedlimit=`cfg get userspeedlimit_$i`
	if [ "$userspeedlimit" != "" ]; then
		mac=`echo $userspeedlimit | cut -d "," -f 1`
		ip=`echo $userspeedlimit | cut -d "," -f 2`
		upload_speed=`echo $userspeedlimit | cut -d "," -f 3`
		download_speed=`echo $userspeedlimit | cut -d "," -f 4`
		
		j=`expr $i + 1`
		tc class add dev $wan_if parent 1:1 classid 1:1$j htb rate "$upload_speed"kbit
		tc qdisc add dev $wan_if parent 1:1$j handle 1$j: sfq perturb 10
		iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $ip/32 -m mac --mac-source $mac -j RETURN
		iptables -t mangle -I SPEEDLIMIT_UPLOAD_CHAIN -s $ip/32 -m mac --mac-source $mac -j MARK --set-mark 1$j
		tc filter add dev $wan_if parent 1:0 protocol ip handle 1$j fw classid 1:1$j
		
	fi
	i=`expr $i + 1`
done



