#!/bin/sh
# ===========================================================
# usage: nat.sh
# just for rmnet_data0 up call

mss_del_path="/tmp/mss_del.sh"
trigger_del_patch="/tmp/trigger_del.sh"
cone_nat_del_patch="/tmp/cone_nat_del.sh"
port_trigger_switch=`cfg get port_trigger_enable`
wan_if=$1
nat_mode_switch=`cfg get nat_mode`
mtu=`cfg get mtu`
tcp_mss=`cfg get tcp_mss`
current_wan_ip=`cfg get wan_ipaddr`
current_lan_ip=`cfg get lan_ipaddr_for_current`
PRIVATE_APN1_PPP_STATUS=`cfg get multi_pdns_ppp_status_1`
PRIVATE_APN1_INTERFACE=`cfg get multi_pdns_wan_v4_dev_name_1`
no_mss_set=`cfg get no_mss_set`

CheckIPAddr() 
{
    echo "input para is [$1]"
    echo $1|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null; 

    if [ $? -ne 0 ] 
    then 
        echo "[$1] is not valid ip address"
    	return 1 
    fi 
    ipaddr=$1 
    
    a=`echo $ipaddr|awk -F . '{print $1}'`  
    b=`echo $ipaddr|awk -F . '{print $2}'` 
    c=`echo $ipaddr|awk -F . '{print $3}'` 
    d=`echo $ipaddr|awk -F . '{print $4}'` 
    for num in $a $b $c $d 
    do 
    if [ $num -gt 255 ] || [ $num -lt 0 ]    
    then 
        echo "[$1] is not valid ip address"
    	return 1 
    fi 
    done 
	
    return 0 
} 

if [ "$wan_if" = "" ]
then
	echo "$0 is null,wan iface using default rmnet_data0"
    wan_if=rmnet_data0
fi

if [ "$mtu" = "" ]
then
    mtu=1500
else
    if [ -n "`echo $mtu | sed 's/[0-9]//g'`" ] ; then
    	echo "mtu=[$mtu] is not number,so use default value [1500]"
    	mtu=1500
    fi
fi	

if [ "$tcp_mss" = "" ]
then
#    tcp_mss=1460
    let tcp_mss=mtu-40
else
    if [ -n "`echo $tcp_mss | sed 's/[0-9]//g'`" ] ; then
    	echo "tcp_mss=[$tcp_mss] is not number,so use default value [$mtu-40]"
    	let tcp_mss=mtu-40
    fi
fi

# added by gaofei to modify mss for PPPoE @2017.5.17 begin
opms_wan_mode=`cfg get opms_wan_mode`
opms_wan_auto_mode=`cfg get opms_wan_auto_mode`
if [ "$opms_wan_mode" = "PPPOE" ]; then
	let tcp_mss=tcp_mss-8
elif [ "$opms_wan_mode" = "AUTO" -a "$opms_wan_auto_mode" = "AUTO_PPPOE" ]; then
	let tcp_mss=tcp_mss-8
fi
# added by gaofei to modify mss for PPPoE @2017.5.17 end

echo "nat.sh: wan if name is [$wan_if]"

echo 1 > /proc/sys/net/ipv4/ip_forward
echo 1 > /proc/sys/net/ipv4/conf/$wan_if/proxy_arp
iptables -t filter -D FORWARD -i bridge0 -p tcp -m state --state INVALID -j DROP
iptables -t filter -A FORWARD -i bridge0 -p tcp -m state --state INVALID -j DROP

conntrack -D -n
conntrack -D -g

ip_passthrough_switch=`cfg get ip_passthrough_enabled`
if [ "1" != "$ip_passthrough_switch" ]; then
    iptables -t nat -D POSTROUTING 1
    iptables -t nat -D POSTROUTING 1

    #0 Close SNAT Function ;1 Full Cone NAT ;2 Port Restricted Cone NAT ;3 Restricted Cone NAT ;
    if [ "0" == "$nat_mode_switch" ]
    then
        echo "close nat function"
    elif [ "1" == "$nat_mode_switch" ]
    then
        sh $cone_nat_del_patch 
        iptables -t nat -A POSTROUTING -o $wan_if -j SNAT --to-source $current_wan_ip
        CheckIPAddr $current_lan_ip
        if [ $? -eq 0 ] ; then
             iptables -t nat -A PREROUTING -i $wan_if -j DNAT --to-destination $current_lan_ip
             echo iptables -t nat -D PREROUTING -i $wan_if -j DNAT --to-destination $current_lan_ip > $cone_nat_del_patch
        fi
    elif [ "2" == "$nat_mode_switch" ]	
    then
        sh $cone_nat_del_patch
        iptables -t nat -A POSTROUTING -o $wan_if -j SNAT --to-source $current_wan_ip
    elif [ "3" == "$nat_mode_switch" ]
    then
        sh $cone_nat_del_patch 
        iptables -t nat -A POSTROUTING -o $wan_if -j MASQUERADE --random
        iptables -t nat -A PREROUTING -i $wan_if -j NATTYPE --mode dnat --type 2
        echo iptables -t nat -D PREROUTING -i $wan_if -j NATTYPE --mode dnat --type 2 > $cone_nat_del_patch
        iptables -t nat -A POSTROUTING -o $wan_if -j NATTYPE --mode forward_out --type 2
    else
        iptables -t nat -A POSTROUTING -o $wan_if -j MASQUERADE
    fi
fi

#add by tianshixin for port trigger start
if [ -f $trigger_del_patch ]
then
sh $trigger_del_patch
fi

if [ "1" = "$port_trigger_switch" ]
then
    iptables -t nat -I PREROUTING 1 -i $wan_if -j TRIGGER --trigger-type dnat
    echo iptables -t nat -D PREROUTING -i $wan_if -j TRIGGER --trigger-type dnat > $trigger_del_patch
fi

#add by tianshixin for port trigger end

#busybox ifconfig $wan_if mtu $mtu
#iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
sh $mss_del_path

if [ -n "$wan_if" ]
then
    echo "$0: set mtu, wan=[$wan_if], mtu=[$mtu], tcp_mss=[$tcp_mss]"
    busybox ifconfig $wan_if mtu $mtu
    #iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
    #iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
    if [ "$tcp_mss" != 1460 -a "$no_mss_set" != "1" ]
    then
       iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
       echo iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss > $mss_del_path
       ip6tables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $(( tcp_mss - 20 ))
       echo ip6tables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $(( tcp_mss - 20 )) >> $mss_del_path	

       # added by gaofei to add mss on PREROUTING @2017.5.17 begin
       iptables -t mangle -I PREROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
       echo iptables -t mangle -D PREROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss >> $mss_del_path
       ip6tables -t mangle -I PREROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $(( tcp_mss - 20 ))
       echo ip6tables -t mangle -D PREROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $(( tcp_mss - 20 )) >> $mss_del_path
       # added by gaofei to add mss on PREROUTING @2017.5.17 end
    fi    
fi
if [ "$PRIVATE_APN1_PPP_STATUS" == "ppp_connected" -o "$PRIVATE_APN_PPP_STATUS" == "ipv4_ipv6_connected" ]; then
    for i in `seq 0 4`
    do  
        rule="private_ip_range_"$i
        private_apn_ip_range=`cfg get ${rule}`
        if [ "" != "$private_apn_ip_range" ]; then
            ipv4_range_valid="yes"
        fi
    done  
	
    if [ "yes" = "$ipv4_range_valid" ]; then
	    echo "get rules"
        iptables -t nat -D POSTROUTING -o $PRIVATE_APN1_INTERFACE -j MASQUERADE 
        iptables -t nat -D POSTROUTING -o $PRIVATE_APN1_INTERFACE -j MASQUERADE
        iptables -t nat -A POSTROUTING -o $PRIVATE_APN1_INTERFACE -j MASQUERADE
    else
        echo "no rules, do nothing"
    fi
fi