#!/bin/sh
# ===========================================================
# ipv6_route_check.sh
# create by zhangzhen10130148 2017.6.24

check_route_path="/tmp/ip_6_route"

ppp_status=`cfg get ppp_status`

if [ "$ppp_status" != "ipv4_ipv6_connected" -a "$ppp_status" != "ipv6_connected" ] ; then
	echo "ipv6 no connected, exit"
	exit
fi

v6_interface_name=`cfg get wan_v6_dev_name`

ipv6_addr=`ifconfig $v6_interface_name | grep inet6 | grep Global | head -n 1 | awk '{print $3}'`

if [ "$ipv6_addr" = "" ] ; then
	echo "error: no get ipv6 address"
	exit
fi

prefix=`echo $ipv6_addr | cut -d ':' -f 1,2,3,4`
prefix4=`echo $ipv6_addr | cut -d ':' -f 4`
prefix3=`echo $ipv6_addr | cut -d ':' -f 3`
prefix2=`echo $ipv6_addr | cut -d ':' -f 2`
prefix1=`echo $ipv6_addr | cut -d ':' -f 1`

if [ "$prefix4" = "0" -a  "$prefix3" -ne "0" ] ; then
	prefix="$prefix1:$prefix2:$prefix3"
	echo "prefix=$prefix"
fi

if [ "$prefix4" = "0" -a  "$prefix3" = "0" -a "$prefix2" -ne "0" ] ; then
	prefix="$prefix1:$prefix2"
	echo "prefix=$prefix"
fi

if [ "$prefix4" = "0" -a  "$prefix3" = "0" -a "$prefix2" = "0" -a "$prefix1" -ne "0" ] ; then
	prefix="$prefix1"
	echo "prefix=$prefix"
fi

ip -6 route > $check_route_path

flag=`cat $check_route_path | grep $prefix | grep usb0`
if [ -n "$flag" ] ; then
	echo "del $prefix::/64 route to usb0" >> /tmp/route_record
	ip -6 route del $prefix::/64 dev usb0 
fi

flag=`cat $check_route_path | grep $prefix | grep ecm0`
if [ -n "$flag" ] ; then
	echo "del $prefix::/64 route to ecm0" >> /tmp/route_record
	ip -6 route del $prefix::/64 dev ecm0 
fi 

flag=`cat $check_route_path | grep $prefix | grep rndis0`
if [ -n "$flag" ] ; then
	echo "del $prefix::/64 route to rndis0" >> /tmp/route_record
	ip -6 route del $prefix::/64 dev rndis0 
fi 

flag=`cat $check_route_path | grep $prefix | grep rmnet_data0`
if [ -n "$flag" ] ; then
	echo "del $prefix::/64 route to rmnet_data0" >> /tmp/route_record
	ip -6 route del $prefix::/64 dev rmnet_data0 
fi 

flag=`cat $check_route_path | grep $prefix | grep bridge0`
if [ ! -n "$flag" ] ; then
	echo "add $prefix::/64 route to bridge0" >> /tmp/route_record
	ip -6 route add $prefix::/64 dev bridge0 
fi 
# =============================================================
