#!/bin/sh
# ===========================================================
# usage: tc_control.sh
# traffic control by tc_uplink and tc_downlink
UPLINK=$2
DOWNLINK=$1
IN=`cfg get in_device`
OUT=`cfg get out_device`
GATEWAY=`cfg get router_mode_gateway`
if [ "$UPLINK" = " " ] || [ "$DOWNLINK" = " " ]
then
	echo "no need to traffic control!"
	exit
fi
if [ "$IN" = "" ]
then
	IN=bridge0
fi
if [ "$OUT" = "" ]
then
	OUT=rmnet_data0
fi

if [ "$DOWNLINK" = "-1" -o "$UPLINK" = "-1" ] 
then
	echo "remain the status."
	exit
fi

if [ "$DOWNLINK" = "0" -a "$UPLINK" = "0" ] 
then
	echo "no need to traffic control,start ipacm"
#	killall -SIGUSR2 ipacm_perf
#	echo 3 > /proc/net/fastnat_level
	modprobe shortcut_fe
	modprobe shortcut_fe_ipv6
	modprobe shortcut_fe_cm
fi

tc qdisc del dev $IN root
tc qdisc del dev $OUT root

# give web 100MBps, no share with others
webui_rate="100000000"
#SUM=`expr ${DOWNLINK} + ${webui_rate}`

if [ "$DOWNLINK" != "0" ] 
then
	killall -SIGUSR1 ipacm
#	echo 5 > /proc/net/fastnat_level
	rmmod shortcut_fe_cm
	rmmod shortcut_fe
	rmmod shortcut_fe_ipv6
	ifconfig $IN txqueuelen 1000
	tc qdisc add dev $IN root handle 1: htb default 20
#	tc class add dev $IN parent 1: classid 1:1 htb rate ${SUM}bps
	tc class add dev $IN parent 1:1 classid 1:20 htb rate ${DOWNLINK}bps ceil ${DOWNLINK}bps
	tc class add dev $IN parent 1:1 classid 1:10 htb rate ${webui_rate}bps
	tc qdisc add dev $IN parent 1:10 handle 10: sfq perturb 10
	tc qdisc add dev $IN parent 1:20 handle 20: sfq perturb 10
	tc filter add dev $IN protocol ip parent 1:0 prio 1 u32 match ip src ${GATEWAY}/32 match ip sport 80 0xffff flowid 1:10
fi
  
if [ "$UPLINK" != "0" ] 
then
	killall -SIGUSR1 ipacm
#	echo 5 > /proc/net/fastnat_level
	rmmod shortcut_fe_cm
	rmmod shortcut_fe
	rmmod shortcut_fe_ipv6
	tc qdisc add dev $OUT root handle 1: htb default 1
	tc class add dev $OUT parent 1: classid 1:1 htb rate ${UPLINK}bps ceil ${UPLINK}bps
fi