#!/bin/sh
#

DEFAULT_IP_ADDR="192.168.4.1"
DEFAULT_DHCP_MASK="255.255.255.0"
DEFAULT_DHCP_START_ADDR="192.168.4.2"
DEFAULT_DHCP_START_ADDR_FOR_USE="192.168.4.20"
DEFAULT_DHCP_END_ADDR="192.168.4.253"
DNSMASQ_CONF="/etc_rw/ztembb/dnsmasq.conf"
DHCP_LEASE="/etc_rw/ztembb/dnsmasq.leases"
dhcpEnable=`cfg get dhcpEnabled`

sleep 1
rm /etc_rw/ztembb/dnsmasq.conf

if [ -n "$dhcpEnable" ] ; then
	cz_ip_gw=`cfg get lan_ipaddr`
	cz_ip_mask=`cfg get lan_netmask`
	cz_ip_start=`cfg get dhcpStart`
	cz_ip_end=`cfg get dhcpEnd`
	i_leasetime=`cfg get dhcpLease_hour`
	manual_lan_dns_enable=`cfg get manual_lan_dns_enable`
	if [ "$manual_lan_dns_enable" = "1" ]
	then
		cz_ip_lan_dns1=`cfg get manual_lan_dns_1st`
	    cz_ip_lan_dns2=`cfg get manual_lan_dns_2nd`
	fi	
else
    cz_ip_gw=$DEFAULT_IP_ADDR
	cz_ip_mask=$DEFAULT_DHCP_MASK
	cz_ip_start=$DEFAULT_DHCP_START_ADDR
	cz_ip_end=$DEFAULT_DHCP_END_ADDR
fi  
LocalDomain=`cfg get LocalDomain` 
cfg set LocalDomain_for_current=$LocalDomain
cfg save

if [ -n "$LocalDomain" ]
then
    contain=`echo $LocalDomain | grep '.' | wc -l`
	if [ "$contain" = "0" ] ; then
		echo "domain=router" >> $DNSMASQ_CONF
	    echo "address=/$LocalDomain.router/$cz_ip_gw" >> $DNSMASQ_CONF
	else
	    echo "address=/$LocalDomain/$cz_ip_gw" >> $DNSMASQ_CONF
    fi	
fi

LocalDomain2=`cfg get LocalDomain2` 
if [ -n "$LocalDomain2" ]
then
    contain=`echo $LocalDomain2 | grep '.' | wc -l`
	if [ "$contain" = "0" ] ; then
		echo "domain=router\r\n" >> $DNSMASQ_CONF
	    echo "address=/$LocalDomain2.router/$cz_ip_gw" >> $DNSMASQ_CONF
	else
	    echo "address=/$LocalDomain2/$cz_ip_gw" >> $DNSMASQ_CONF
    fi	
fi

LocalDomain3=`cfg get LocalDomain3` 
if [ -n "$LocalDomain2" ]
then
    contain=`echo $LocalDomain3 | grep '.' | wc -l`
	if [ "$contain" = "0" ] ; then
		echo "domain=router" >> $DNSMASQ_CONF
	    echo "address=/$LocalDomain3.router/$cz_ip_gw" >> $DNSMASQ_CONF
	else
	    echo "address=/$LocalDomain3/$cz_ip_gw" >> $DNSMASQ_CONF
    fi	
fi

if [ "$dhcpEnable" = "1" ]
then
	if [ "$cz_ip_start" = "$DEFAULT_DHCP_START_ADDR" ] ; then
		echo "dhcp-range=$DEFAULT_DHCP_START_ADDR_FOR_USE,$cz_ip_end,$cz_ip_mask,$i_leasetime""h" >> $DNSMASQ_CONF
	else
	    echo "dhcp-range=$cz_ip_start,$cz_ip_end,$cz_ip_mask,$i_leasetime""h" >> $DNSMASQ_CONF
	fi
	
	echo "dhcp-leasefile=$DHCP_LEASE" >> $DNSMASQ_CONF
	
	if [ "$manual_lan_dns_enable" = "1" ]
	then
		if [ -n "$cz_ip_lan_dns1" ]
		then
			if [ -n "$cz_ip_lan_dns2" ] ; then
				echo "dhcp-option=6,$cz_ip_lan_dns1,$cz_ip_lan_dns2" >> $DNSMASQ_CONF
			else
			    echo "dhcp-option=6,$cz_ip_lan_dns1" >> $DNSMASQ_CONF
            fi			
		fi
	fi
fi

killall -9 dnsmasq

dnsmasq -c 300 -C $DNSMASQ_CONF &

echo "dnsmasq start done" >> /dev/kmsg