#!/bin/sh
#

product_type=`cfg get product_type`
mtu=`cfg get mtu`
radvd_conf="/tmp/radvd-mtu.conf"

echo 2 > /proc/sys/net/ipv6/conf/all/forwarding
echo 2 > /proc/sys/net/ipv6/conf/rmnet_data0/accept_ra
echo 2 > /proc/sys/net/ipv6/conf/all/proxy_ndp

lan_dev_name="bridge0"
wan_dev_name=$1

set_radvd_conf()
{
    echo "interface $lan_dev_name" > $radvd_conf
    echo "{" >> $radvd_conf
    echo "        AdvSendAdvert on;" >> $radvd_conf
    echo "        MaxRtrAdvInterval 30;" >> $radvd_conf
    echo "        AdvLinkMTU $mtu;" >> $radvd_conf
    echo "};" >> $radvd_conf
}

if [ "$wan_dev_name" == "mtu_set" ]
then
  echo "$0: mtu_set, set mtu!"
  
  if [ "$mtu" == "1500" -o "$mtu" = "" ]
  then
    echo "$0: mtu is 1500 or empty, exit"
    exit
  fi
  set_radvd_conf
  chmod 755 $radvd_conf
  killall -9 radvd
  radvd -C $radvd_conf &
  exit
fi

wan_dev_name=`cfg get wan_v6_dev_name`

ip -6 route del default
ip -6 route add default dev $wan_dev_name

# here we wait lan ready
while [ ! -d "/sys/class/net/$lan_dev_name" ]
 do
  sleep 1
  echo "ipv6_init.sh: wait $lan_dev_name ..."
done

echo "ipv6_init.sh: $lan_dev_name exist, go ..."

killall -9 radish
radish -k -b $wan_dev_name -i $wan_dev_name -x -i $lan_dev_name -x > /dev/null 2>&1 &

echo "ipv6_init.sh: done ..."
