#!/bin/sh
#
# 
#
# usage: vpn_pthr_control.sh 
# added by myc for vpn control 20121023

ZTE_VPN_CHAIN=vpn_filter

alg_sip_control=`cfg get alg_sip_enable`
alg_ftp_control=`cfg get alg_ftp_enable`
vpn_pptp_control=`cfg get alg_pptp_enable`
vpn_l2tp_control=`cfg get alg_l2tp_enable`
vpn_ipsec_control=`cfg get alg_ipsec_enable`

iptables -t filter -F $ZTE_VPN_CHAIN

if [ "$vpn_pptp_control" == "0" ]; then
  # PPTP:  GRE/47   TCP Port: 1723
  iptables -t filter -A $ZTE_VPN_CHAIN -p 47 -j DROP
  iptables -t filter -A $ZTE_VPN_CHAIN -p tcp --dport 1723 -j DROP
fi

if [ "$vpn_ipsec_control" == "0" ]; then
  # IPsec:  ESP/50  AH/51  UDP Port: 500 4500
  iptables -t filter -A $ZTE_VPN_CHAIN -p 50 -j DROP
  iptables -t filter -A $ZTE_VPN_CHAIN -p 51 -j DROP
  iptables -t filter -A $ZTE_VPN_CHAIN -p udp --dport 500 -j DROP
  iptables -t filter -A $ZTE_VPN_CHAIN -p udp --dport 4500 -j DROP
fi

if [ "$vpn_l2tp_control" == "0" ]; then
  # L2TP:  UDP Port: 1701
  iptables -t filter -A $ZTE_VPN_CHAIN -p udp --dport 1701 -j DROP
fi

if [ "$alg_ftp_control" == "0" ]; then
	iptables -t filter -A $ZTE_VPN_CHAIN -p tcp --dport 21 -j DROP
fi

if [ "$alg_sip_control" = "0" ]; then
	rmmod nf_nat_sip
	rmmod nf_conntrack_sip
else
	rmmod -f nf_nat_sip
	rmmod -f nf_conntrack_sip
	insmod /usr/lib/modules/`uname -r`/kernel/net/netfilter/nf_conntrack_sip.ko
	insmod /usr/lib/modules/`uname -r`/kernel/net/netfilter/nf_nat_sip.ko
fi

echo "vpn_pthr_contrl-tr069.sh end"







