#!/bin/sh
# Copyright (c) 2014-2015, The Linux Foundation. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of The Linux Foundation nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# find_partitions        init.d script to dynamically find partitions
#

FindAndMountUBI () {
   partition=$1
   dir=$2

   mtd_block_number=`cat $mtd_file | grep -i $partition | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   echo "MTD : Detected block device : $dir for $partition"
   mkdir -p $dir

   ubiattach -m $mtd_block_number -d 1 /dev/ubi_ctrl
   device=/dev/ubi1_0
   while [ 1 ]
    do
        if [ -c $device ]
        then
            mount -t ubifs -o ro /dev/ubi1_0 $dir -o bulk_read
            break
        else
            sleep 0.010
        fi
    done
}

FindAndMountVolumeUBI () {
   volume_name=$1
   dir=$2
   if [ ! -d $dir ]
   then
       mkdir -p $dir
   fi
   mount -t ubifs ubi0:$volume_name $dir -o bulk_read
}

FindAndMountEXT4 () {
   partition=$1
   dir=$2
   mmc_block_device=/dev/block/bootdevice/by-name/$partition
   echo "EMMC : Detected block device : $dir for $partition"
   if [ ! -d $dir ]
   then
       mkdir -p $dir
   fi
   mount -t ext4 $mmc_block_device $dir -o relatime,data=ordered,noauto_da_alloc,discard
   echo "EMMC : Mounting of $mmc_block_device on $dir done"
}

emmc_dir=/dev/block/bootdevice/by-name
mtd_file=/proc/mtd

if [ -d $emmc_dir ]
then
        fstype="EXT4"
        eval FindAndMount${fstype} userdata /data
        eval FindAndMount${fstype} cache /cache
else
        fstype="UBI"
        # eval FindAndMountVolume${fstype} usrfs /data
fi

eval FindAndMount${fstype} modem /firmware
mount -t ubifs ubi0:fwfs /lib/firmware -o bulk_read
echo 1 > /dev/ipa
mount -t ubifs -o ro ubi0:ztedata /usr/zte_web -o bulk_read

#mount zterw partition as ubifs filesystem
mtd_num=`cat /proc/mtd | grep "zterw" | awk -F ':' '{print $1}' | awk -F 'mtd' '{print $2}'`
mtd_zterw=`cat /proc/mtd | grep "zterw" | awk -F ':' '{print $1}'`
magic=`od -x /dev/$mtd_zterw -N 4|head -n 1`
echo "print zterw partition the first 4 bytes values"
echo $magic
count=0
device0=/dev/ubi3_0
device1=/dev/ubi3_1
device2=/dev/ubi3_2
if [ x"$magic" != x"0000000 4255 2349" ]
then
	echo "zterw partition is empty,start making zterw ubifs volume and mount it"
	ubiformat -y /dev/$mtd_zterw
	ubiattach -m $mtd_num -d 3 /dev/ubi_ctrl
    sleep 2	
	echo "making zterw ubifs volume done"
else
	echo "zterw partition is not empty"
	ubiattach -m $mtd_num -d 3 /dev/ubi_ctrl
	while [ $count -lt 25 ]
	do
		if [ -c $device0 ] && [ -c $device1 ] && [ -c $device2 ]
		then			
			echo "ubiattach zterw done"	
			break
		fi
		sleep 0.2
		let count+=1
	done
fi

if [ -c $device0 ]
then
	echo "zterw ubiattach success."
else
	echo "zterw ubiattach fail."
	ubiformat -y /dev/$mtd_zterw
	ubiattach -m $mtd_num -d 3 /dev/ubi_ctrl
fi

mount -t ubifs ubi3:etcrwfs /etc_rw -o bulk_read
if [ -d /etc_rw/restore  ]  &&  [ ! -f /etc_rw/WriteRestoreFlag  ]
then
	echo "etc_rw fs check success."
else
	ubirmvol /dev/ubi3 -N etcrwfs
	ubimkvol /dev/ubi3 -s 32MiB -N etcrwfs
	mount -t ubifs ubi3:etcrwfs /etc_rw
	touch /etc_rw/WriteRestoreFlag
	cp -rfv /usr/etc_rw/* /etc_rw/
	rm -rf /etc_rw/WriteRestoreFlag 
fi

mount -t ubifs ubi3:cachefs /cache -o bulk_read
if [ -d /cache/restore  ]  &&  [ ! -f /cache/WriteRestoreFlag  ]
then
	echo "cache fs check success."
else
	ubirmvol /dev/ubi3 -N cachefs
	ubimkvol /dev/ubi3 -s 50MiB -N cachefs
	mount -t ubifs ubi3:cachefs /cache
	touch /cache/WriteRestoreFlag
	cp -rfv /usr/cachefs/* /cache/
	rm -rf /cache/WriteRestoreFlag 
fi

mount -t ubifs ubi3:logfs /logfs -o bulk_read
if [ -d /logfs/restore  ]  &&  [ ! -f /logfs/WriteRestoreFlag  ]
then
	echo "log fs check success."
else
	ubirmvol /dev/ubi3 -N logfs
	ubimkvol /dev/ubi3 -s 20MiB -N logfs
	mount -t ubifs ubi3:logfs /logfs
	touch /logfs/WriteRestoreFlag
	cp -rfv /usr/logfs/* /logfs/
	rm -rf /logfs/WriteRestoreFlag 
fi
exit 0
