#!/bin/sh
# ===========================================================
# usage: nat.sh
# just for rmnet_data0 up call

sip_ports=`cfg get alg_sip_port`
sip_alg_switch=`cfg get alg_sip_enable`

if [ "" = "$sip_ports" ]
then
	conntrack_sip_ko_path="usr/lib/modules/`uname -r`/kernel/net/netfilter/nf_conntrack_sip.ko"
else
	conntrack_sip_ko_path="usr/lib/modules/`uname -r`/kernel/net/netfilter/nf_conntrack_sip.ko ports=$sip_ports"
fi

nat_sip_ko_path="usr/lib/modules/`uname -r`/kernel/net/netfilter/nf_nat_sip.ko"

if [ "" = "$sip_alg_switch" ]
then
	sip_alg_switch="0"
fi

if [ "0" = "$sip_alg_switch" ]
then
	rmmod nf_nat_sip
	rmmod nf_conntrack_sip
else
	rmmod -f nf_nat_sip
	rmmod -f nf_conntrack_sip
	insmod $conntrack_sip_ko_path
	insmod $nat_sip_ko_path
fi

