﻿define([ 'jquery', 'service', 'knockout', 'config/config'], function ($, service, ko, config) {
    var _otaUpdateCancelFlag = null;

    function bindEvent() {
        $("#btnCheckNewVersion").unbind('click').click(function () {

            var info = service.getStatusInfo();
            if (info.current_upgrade_state != "upgrade_prepare_install" &&
                info.current_upgrade_state != "low_battery" &&
                (!checkConnectedStatus(info.connectStatus) && info.connectWifiStatus != "connect")) {
                showAlert("ota_network_disconnected");
                return;
            }

            var s = service.getNewVersionState();
            if (s.hasNewVersion) {
                showOTAAlert();
                return;
            } else {
                if(config.UPGRADE_TYPE=="FOTA"){
                    var runningState = ["version_no_new_software", "version_has_new_critical_software"
                        , "version_has_new_optional_software", "version_start", "version_processing"
                        , "version_roaming", "version_checking", "version_checking_failed"];
                    if ($.inArray(s.new_version_state, runningState) != -1) {
                        showAlert("ota_update_running");
                        return;
                    }
                }
            }
            //OTA开始下载时，会将new_version_state清空，此处判断是否已经在下载过程中
            if (info.current_upgrade_state == "upgrade_prepare_install") {
                showInfo('ota_download_success');
                return;
            }
            if (info.current_upgrade_state == "low_battery") {
                showInfo('ota_low_battery');
                return;
            }
            var upgradingState = ["upgrade_pack_redownload", "connecting_server", "connect_server_success", "upgrading", "accept"];
            if ($.inArray(info.current_upgrade_state, upgradingState) != -1) {
                showOTAAlert();
                return;
            }
            var state = service.dmUpdatePackageExit();
            if(state.dm_update_package_file_exist == "1"){
                showInfo('ota_download_success');
                checkNewVersion();
                return;
            }
            if (info.roamingStatus) {
                showConfirm("ota_check_roaming_confirm", function () {
                    checkNewVersion();
                });
            } else {
                checkNewVersion();
            }

            function checkNewVersion() {
                if(state.dm_update_package_file_exist != "1"){
                    showLoading("ota_new_version_checking");
                }
                function checkResult() {
                    var r = service.getNewVersionState();
                    var data = service.getCurrentUpgradeState();
                    if (r.hasNewVersion) {
                        showOTAAlert();
                    } else if (r.new_version_state == "0" || r.new_version_state == "version_no_new_software") {
                        showAlert("ota_no_new_version");
                    } else if (r.new_version_state == "version_processing" || r.new_version_state == "in_session") {
                        showAlert("ota_update_running");
                        /*} else if (r.new_version_state == "version_roaming" || r.new_version_state == "in_roaming") {
                         showAlert("ota_roamming");*/
                    } else if (r.new_version_state == "version_checking_failed" || r.new_version_state == "network_unavailable") {
                        errorOverlay("ota_check_fail");
                    } else if(data.current_upgrade_state == "low_battery"){
                        showInfo('ota_low_battery');
                    } else if(data.current_upgrade_state == "upgrade_pack_error"){
                        showInfo('ota_md5_error');
                    } else {
                        addTimeout(checkResult, 1000);
                    }
                }

                service.setUpgradeSelectOp({selectOp: 'check'}, function (result) {
                    if (result.result == "success") {
                        checkResult();
                    } else {
                        errorOverlay();
                    }
                });
            }
        });
    }

    function showOTAAlert() {
        var is_mandatory = service.getMandatory().is_mandatory;
        if (is_mandatory) {
            showOtaStatus();
        } else {
            var upgradeState = {};
            upgradeState = service.getCurrentUpgradeState();
            showOTAConfirm(upgradeState);
        }
    }

    function showOTAConfirm(upgradeState) {
        var upgState = upgradeState.current_upgrade_state;
        if (upgState == 'upgrade_pack_redownload') {
            showConfirm("ota_interrupted", {ok: function () {
                getUserSelector(1);
            }, no: function () {
                getUserSelector(0);
            }});
        } else {
            var upgradingState = ["upgrade_prepare_install", "low_battery",
                "connecting_server", "connect_server_success", "upgrading", "accept"];
            if ($.inArray(upgState, upgradingState) != -1) {
                showOtaStatus();
            } else {
                var info = service.getNewVersionInfo();
                var version = "";
                if (info.version) {
                    version = "<br/>" + $.i18n.prop('ota_version') + info.version;
                }
                showConfirm($.i18n.prop('ota_new_version') + version, {ok: function () {
                    getUserSelector(1);
                }, no: function () {
                    getUserSelector(0);
                }});
            }
        }
    }

    function getUserSelector(choice){
        var selector = service.getUserChoice();
        if(choice){
            var info = service.getStatusInfo();
            if (!checkConnectedStatus(info.connectStatus) && info.connectWifiStatus != "connect") {
                showAlert("ota_network_disconnected");
                return;
            }

            if(selector.if_has_select == 'none'){
                startOTAUpgrade();
            }else if(selector.if_has_select == 'accept'){
                showOtaStatus();
            }else if(selector.if_has_select == 'cancel'){
                showAlert("ota_have_cancel");
            }else if(selector.if_has_select == 'downloading_cancel'){
                showAlert("ota_have_cancel");
            }
        }else{
            if(selector.if_has_select == 'none'){
                cancelOTAUpgrade();
            }else if(selector.if_has_select == 'accept'){
                showOtaStatus();
            }else if(selector.if_has_select == 'cancel'){

            }else if(selector.if_has_select == 'downloading_cancel'){

            }
        }
    }

    function getDownloadSize(){
        service.getPackSizeInfo({}, function (data) {
            var percents;
            var completedSize = "";
            if (parseInt(data.pack_total_size) == 0) {
                percents = 0;
                completedSize = "";
            } else {
                percents = parseInt(parseInt(data.download_size) * 100 / parseInt(data.pack_total_size));
                completedSize = transUnit(parseInt(data.download_size),false)+ "/" +transUnit(parseInt(data.pack_total_size),false);
            }
            if (percents > 100) {
                percents = 100;
                completedSize = transUnit(parseInt(data.pack_total_size),false)+ "/" +transUnit(parseInt(data.pack_total_size),false);
            }
            if (percents > 0) {
                if (percents > 95) {
                    showProgressBar("ota_update", "<br/>" + $.i18n.prop("ota_update_warning"));
                }
                setProgressBar(percents,completedSize);
            }
        });
    }

    function startOTAUpgrade(){
        service.setUpgradeSelectOp({selectOp:'1'},function(result){
            if (result.result == "success"){
                showOtaStatus();
            }});
    }

    function cancelOTAUpgrade(){
        service.setUpgradeSelectOp({selectOp:'0'},function(result){ });
    }

    function showOTAUpgradeStatus() {
        var data = service.getMandatory();
        var isMandatory = data.is_mandatory;
        if (isMandatory) {
            showProgressBar("ota_update", "<br/>" + $.i18n.prop("ota_update_warning"));
        } else {
            var cancelHtml = "";
            if (config.UPGRADE_TYPE == "OTA") {
                cancelHtml = "<br/><br/><button id='btnStopUpgrade' onclick='stopOTAUpgrade();' class='btn-1 btn-primary'>" + $.i18n.prop("cancel") + "</button>";
            }
            showProgressBar("ota_update", "<br/>" + $.i18n.prop("ota_update_warning") + cancelHtml);
        }
        setProgressBar(0,"");
    }

    var checkBatteryTimer = 0;

    function CheckBatteryStatus(){
        var state = service.getCurrentUpgradeState();
        if(state.current_upgrade_state == 'low_battery'){
            showInfo('ota_low_battery');
            clearInterval(checkBatteryTimer);
        }
    }

    var timer = 0;
    /**
     * 显示升级状态
     * @method showOtaStatus
     */
    function showOtaStatus() {
        _otaUpdateCancelFlag = true;
        function showProgress() {
            var upgradingState = ["upgrade_pack_redownload", "upgrade_prepare_install", "low_battery"
                , "connecting_server", "connect_server_success", "upgrading", "accept"];
            var info = service.getCurrentUpgradeState();
            if(info.current_upgrade_state.toLowerCase() == "fota_idle") {
                addTimeout(showProgress, 1000);
            } else if($.inArray(info.current_upgrade_state, upgradingState) != -1) {
                hideLoading();
                showOTAUpgradeStatus();
            }
        }
        if (!($("#progress").is(":visible"))) {
            showProgress();
        }
        var times = 0;
        var getOTAUpgradeState = function () {
            var data = null;
            if (times <= 3) {
                times = times + 1;
                data = service.getCurrentUpgradeState();
            } else {
                data = service.getStatusInfo();
            }
            var state = data.current_upgrade_state;
            if(_otaUpdateCancelFlag){
                if(state == 'connecting_server'){
                }else if(state == 'connect_server_failed') {
                    _otaUpdateCancelFlag = false;
                    window.clearTimeout(timer);
                    hideProgressBar();
                    showAlert('ota_connect_server_failed');
                    return;
                }else if(state == 'connect_server_success') {
                }else if(state == 'upgrading') {
                    getDownloadSize();
                }else if(state == 'download_success') {
                }else if(state == 'upgrade_pack_check_ok') {
                }else if(state == 'download_failed') {
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    showAlert('ota_download_failed');
                    window.clearTimeout(timer);
                    return;
                }else if(state == 'server_unavailable'){
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    showAlert('ota_connect_server_failed');
                    window.clearTimeout(timer);
                    return;
                }else if(state == 'network_unavailable'){
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    showAlert('ota_no_network');
                    window.clearTimeout(timer);
                    return;
                }else if(state == 'pkg_exceed'){
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    showAlert('ota_pkg_exceed');
                    window.clearTimeout(timer);
                    return;
                }else if(state == 'accept'){
                }else if(state == 'low_battery'){
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    showInfo('ota_low_battery');
                    window.clearTimeout(timer);
                    return;
                }else if(state == 'upgrade_pack_error'){
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    showInfo('ota_md5_error');
                    window.clearTimeout(timer);
                    return;
                }else if(state == 'upgrade_prepare_install'){
                    hideProgressBar();
                    _otaUpdateCancelFlag = false;
                    service.removeTimerThings('current_upgrade_state',function(){});
                    showInfo('ota_download_success');
                    window.clearTimeout(timer);
                    checkBatteryTimer = setInterval(function () {
                        CheckBatteryStatus();
                    }, 1000);
                    return;
                }else if(state == 'checking' || state == "fota_idle"){
                }else if(state == 'upgrade_pack_redownload'){
                }else{
                    _otaUpdateCancelFlag = false;
                    hideProgressBar();
                    window.clearTimeout(timer);
                    return;
                }
                timer = window.setTimeout(getOTAUpgradeState , 1000);
            }
        };

        if(_otaUpdateCancelFlag){
            timer = window.setTimeout(getOTAUpgradeState , 100);
        }else{
            window.clearTimeout(timer);
        }
    }
    /**
     * 处理页面元素的可用状态
     * @method fixPageEnable
     */
    function fixPageEnable() {
        var info = service.getStatusInfo();
        if (info.connectWifiStatus == "connect" || checkConnectedStatus(info.connectStatus)) {
            enableBtn($("#btnCheckNewVersion"));
        } else {
            disableBtn($("#btnCheckNewVersion"));
        }
        if(info.new_version_state){
            $("#btnCheckNewVersion").attr("data-trans", "ota_update_new_version").text($.i18n.prop("ota_update_new_version"));
            $("#newVersionSpan").text(info.dm_new_version == "" ? "" : info.dm_new_version);
            info.dm_new_version == "" ? $("#newVersionInfoDiv").hide() : $("#newVersionInfoDiv").show();
        }else{
            $("#btnCheckNewVersion").attr("data-trans", "ota_check_new_version").text($.i18n.prop("ota_check_new_version"));
            $("#newVersionSpan").text("");
            $("#newVersionInfoDiv").hide();
        }

        if (info.isLoggedIn && !($("#progress").is(":visible"))){
            if(info.current_upgrade_state == 'connecting_server' || info.current_upgrade_state == 'upgrading'
                || info.current_upgrade_state == 'accept' || info.current_upgrade_state == 'connect_server_success' ){
                if(null == _otaUpdateCancelFlag){
                    if(!info.is_mandatory){
                        $("#dialog").popup("close");
                        $.mobile.loading('hide');
                    }
                    showOtaStatus();
                }else if(false == _otaUpdateCancelFlag){
                    _otaUpdateCancelFlag = null;
                }
            }
        }

    }


    function init() {
        fixPageEnable();
        addInterval(function () {
            fixPageEnable();
        }, 1000);
        var info = service.getDeviceInfo();
        $('#currentVersionSpan').text(info.sw_version);
        bindEvent();
    }

    return {
        init: init
    };
});