#!/bin/sh
# ===========================================================
# mode_switch.sh
# create by zhangwentao187783 20130313

telnet_debug=`cfg get telnet_debug`

if [ "1" = "$telnet_debug" ];then
   killall -9 telnetd
   telnetd -l /bin/sh
else
  echo "no telnet"
fi

DNS_RESOLV_FILE="/etc/resolv.conf"

file_system_readonly=`cfg get file_read_only_flag`
if [ "$file_system_readonly" = "1" ] ; then
    echo "$0:read only file system"
    DNS_RESOLV_FILE="/var/run/resolv.conf"
fi


work_mode=`cfg get opms_work_mode`
echo "work mode is $work_mode"
cable_interface='eth0'
echo "cable iface is $cable_interface"
ip_acquire=`cfg get opms_ip_acquire`
cable_mode=`cfg get current_cable_mode`


#cfg set wan_connect_status=no_connected
router_msg network_off
if [ "$cable_mode" = "$work_mode" ];then
   mode_switch='0'
   echo "mode not changed"
else
   mode_switch='1'
   cfg set current_cable_mode=$work_mode
   echo "mode changed"
fi

if [ "bridge" = "$work_mode" ];then

   router_msg network_on

   if [ "1" = "$mode_switch" ];then
	  router_msg mode_switch 
   else
      echo "cable mode not change"
   fi
  
  
  killall -9 dnsmasq
  killall -9 udhcpc
  
  echo "bridge mode del nat"
  
  iptables -t nat -D POSTROUTING 1
  ip route del default
  ip route del default
  ip route del default
  ip route del default  
  
  ifconfig $cable_interface 0.0.0.0 up
  
  brctl addif bridge0 $cable_interface
  
    if [ "auto" = "$ip_acquire" ];then
	 # cfg set br0_bridge_ip=""
	  udhcpc -i bridge0 -s /usr/zte/zte_conf/scripts/udhcpc.sh &
    elif [ "manual" = "$ip_acquire" ];then
		#manual set ip parameters b
	  lan_ip=`cfg get opms_manual_ip`
	  lan_netmask=`cfg get opms_manual_mask`
	  lan_gw=`cfg get opms_manual_gateway`
	  dns_p=`cfg get opms_manual_dns_p`
	  dns_s=`cfg get opms_manual_dns_s`
		#manual set ip parameters e	
	  ifconfig bridge0 $lan_ip netmask $lan_netmask up
     # route add default gw $lan_gw dev br0
        echo -n > $DNS_RESOLV_FILE     	  
	    echo "nameserver" $dns_p >> $DNS_RESOLV_FILE
	    echo "nameserver" $dns_s >> $DNS_RESOLV_FILE
	  cfg set lan_ipaddr_for_current=$lan_ip
	  router_msg getway_change $ip 
      cfg set wan_connect_status=rj45_connected	  
    else
	    echo "bridge mode some err happen"
    fi

  
elif [ "router" = "$work_mode" ];then

   if [ "1" = "$mode_switch" ];then
	  router_msg mode_switch 
   else
      echo "cable mode not change"
   fi

    ip route del default
    ip route del default
    ip route del default
    lan_ipaddr_for_current=`cfg get router_mode_gateway`  
    
    brctl delif bridge0 $cable_interface
    ifconfig $cable_interface 0.0.0.0 up
    ifconfig bridge0 $lan_ipaddr_for_current up
      
    #cfg set br0_bridge_ip=$lan_ipaddr_for_current
    cfg set lan_ipaddr_for_current=$lan_ipaddr_for_current    
    router_msg getway_change $lan_ipaddr_for_current
    
	killall -9 dnsmasq
	dnsmasq -C /tmp/dnsmasq.conf
	ifconfig $cable_interface 0.0.0.0 up
    killall -9 udhcpc
    killall pppoecd
    if [ "auto" = "$ip_acquire" ];then
	  udhcpc -i $cable_interface -s /usr/zte/zte_conf/scripts/udhcpc.sh &
	  
	    echo 1 > /proc/sys/net/ipv4/ip_forward
      iptables -t nat -D POSTROUTING 1
      iptables -t nat -A POSTROUTING -o $cable_interface -j MASQUERADE
      ip route add default dev $cable_interface
		
    elif [ "manual" = "$ip_acquire" ];then
	
		#manual set ip parameters b
	  lan_ip=`cfg get opms_manual_ip`
	  lan_netmask=`cfg get opms_manual_mask`
	  lan_gw=`cfg get opms_manual_gateway`
	  dns_p=`cfg get opms_manual_dns_p`
	  dns_s=`cfg get opms_manual_dns_s`
		#manual set ip parameters e	

	  ifconfig $cable_interface $lan_ip netmask $lan_netmask up

      route add default gw $lan_gw dev $cable_interface
        echo -n > $DNS_RESOLV_FILE     	  
	    echo "nameserver" $dns_p > $DNS_RESOLV_FILE
	    echo "nameserver" $dns_s >> $DNS_RESOLV_FILE
	  cfg set wan_connect_status=rj45_connected	
	  router_msg network_on

    elif [ "pppoe" = "$ip_acquire" ];then
          
            echo "pppoe dial"
        username=`cfg get pppoe_username`
        pwd=`cfg get pppoe_password`        
        iptables -t nat -D POSTROUTING 1
        iptables -t nat -A POSTROUTING -o ppp0 -j MASQUERADE            
        pppoecd $cable_interface -u $username -p $pwd -N 2 &
    	    
    else
      echo "some err happen"    
    fi	

else
    echo "some err happen"    
fi
