/**
 * @module prot_forward
 * @class prot_forward
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

	function($, ko, config, service, _) {

		var columnsTmpl = [
			{ columnType:"checkbox", rowText:"index", width:"10%"},
			{ headerTextTrans:"mac_address", rowText:"macAddress", width:"30%",trans:true},
			{ headerTextTrans:"ip_address", rowText:"ipAddress", width:"30%",trans:true}
		];
		/**
		 * StaticMACIPAddressVM
		 * @class StaticMACIPAddressVM
		 */
		function StaticMACIPAddressVM() {
			var self = this;
			var info = service.getStaticMacIpAddressList();
			var info_flag = service.getDHCPStaticAddressRules();
			var info_lan = service.getBindIPInfo();
			self.rules = ko.observableArray(info.StaticAddressFilterRules);
			self.hostName = ko.observable(info_lan.host_name_web);
			self.macAddress = ko.observable(info_lan.mac_addr_web);
			self.ipAddress = ko.observable(info_lan.ip_addr_web);
			self.gridTemplate = new ko.simpleGrid.viewModel({
				data:self.rules(),
				idName:"index",
				primaryColumn:"macAddress",
				columns:columnsTmpl,
				tmplType:'list',
				pageSize: 10
			});
			self.macIpBindEnable = ko.observable(info_flag.mac_ip_status);
			self.orimacIpBindEnable = info_flag.mac_ip_status;
			self.isShowStaticAddressDiv = ko.observable(false);
			if(info_flag.mac_ip_status == 1) {
				self.isShowStaticAddressDiv(true);
			} else {
				self.isShowStaticAddressDiv(false);
			}

			self.clear = function() {
				$("#txtMacAddress").val("");
				$("#txtIpAddress").val("");
				$("#hostName").focus();
			};

			self.callback = function(data){
				if(data.result == "success") {
					self.clear();
					init();
					successOverlay();
					$("#staticAddress").translate();
				} else {
					errorOverlay();
				}
			}

			self.setBindSwitch = function(){
				showLoading();
				var params = {};
				params.mac_ip_status = self.macIpBindEnable();
				service.setBindMacIpSwitch(params, function (result) {
					if (result.result == "success") {
						successOverlay();
						self.clear();
						init();
					} else {
						errorOverlay();
					}
				});
			}

			self.addRule = function() {
				if(self.rules().length >= config.staticMacIPAddress) {
					showAlert({msg: "mac_ip_address_filter_max", params: config.staticMacIPAddress});
					return false;
				}
				if(info_lan.ipAddress == self.ipAddress()){
					showAlert("ip_gate_not_same");
					return false;
				}
				if(!staticAddressCheck(info_lan.ipAddress,info_lan.subnetMask,self.ipAddress())) {
					showAlert("static_address_check");
					return false;
				}
				if(!theOnlyIpAddress(self.ipAddress(),info)) {
					showAlert("the_only_ipAddress");
					return false;
				}
				if(!theOnlyMacAddress(self.macAddress(),info)) {
					showAlert("the_only_macAddress");
					return false;
				}
				showLoading();
				var params = {
					goformId : "BIND_STATIC_ADDRESS_ADD",
					mac_address : self.macAddress(),
					ip_address : self.ipAddress()
				};
				service.addStaticAddress(params, self.callback);
			};

			self.deleteRule = function(){

				showConfirm("confirm_data_delete", function () {
					showLoading();
					var params = {
						goformId : "BIND_STATIC_ADDRESS_DEL",
						mac_address : self.gridTemplate.selectedPrimaryValue().join(";") + ";"
					};
					service.delStaticAddrRules(params, self.callback);
				});
			};
			self.restart = function () {
				showConfirm("restart_confirm", function () {
					showLoading("restarting");
					service.restart({}, function (data) {
						if (data && data.result == "success") {
							successOverlay();
						} else {
							errorOverlay();
						}
					}, $.noop);
				});
			};
		}
		function staticAddressCheck(gatewayIp,subnetMask,ipValue){
			var result = validateGateway(gatewayIp,subnetMask,ipValue);
			return result;
		}
		function theOnlyIpAddress(ipValue,info){
			var rules = info.StaticAddressFilterRules;
			var dhcpNow = ipValue;
			var tempArray = [];
			var tempArray1 = [];
			for(var i = 0; i < rules.length; i++){
				var aRule = {};
				aRule.ipAddress =rules[i].ipAddress;
				tempArray.push(aRule);
			}
			for(var i = 0; i < tempArray.length; i++){
				tempArray1.push(tempArray[i].ipAddress)
			}

			if($.inArray(dhcpNow, tempArray1) == -1){
				return true;
			}else {
				return false;
			}
		}
		function theOnlyMacAddress(macValue,info){
			var rules = info.StaticAddressFilterRules;
			var dhcpNow = macValue;
			var tempArray = [];
			var tempArray1 = [];
			for(var i = 0; i < rules.length; i++){
				var aRule = {};
				aRule.macAddress =rules[i].macAddress;
				tempArray.push(aRule);
			}
			for(var i = 0; i < tempArray.length; i++){
				tempArray1.push(tempArray[i].macAddress)
			}

			if($.inArray(dhcpNow, tempArray1) == -1){
				return true;
			}else {
				return false;
			}
		}

		function hex(val) {
			var h = (val-0).toString(16);
			if(h.length==1) h='0'+h;
			return h.toUpperCase();
		}

		function Op_AND_4Byte(v1, v2) {
			var i;
			var var1 = [];
			var var2 = [];
			var result='0x';

			for (i=2,j=0;i<10;i+=2,j++) {
				var1[j]='0x'+v1.substring(i,i+2);
				var2[j]='0x'+v2.substring(i,i+2);
			}

			for (i=0;i<4;i++) {
				result = result + hex(var1[i]&var2[i]);
			}

			return result - 0;
		}
		function validateGateway(wanIp, netmaskIp, gatewayIp) {
			var i1,i2,i3, wip, nip, gip;
			var lan4, mask4, pool4, net_no, lo_broadcast;

			i1=wanIp.indexOf('.');
			i2=wanIp.indexOf('.',(i1+1));
			i3=wanIp.indexOf('.',(i2+1));
			wip = hex(wanIp.substring(0,i1)) + hex(wanIp.substring((i1+1),i2)) +hex(wanIp.substring((i2+1),i3))+hex(wanIp.substring((i3+1),wanIp.length));
			wip = '0x'+wip;
			lan4 = wanIp.substring((i3+1),wanIp.length)-0;

			i1=netmaskIp.indexOf('.');
			i2=netmaskIp.indexOf('.',(i1+1));
			i3=netmaskIp.indexOf('.',(i2+1));
			nip = hex(netmaskIp.substring(0,i1)) + hex(netmaskIp.substring((i1+1),i2)) +hex(netmaskIp.substring((i2+1),i3)) +hex(netmaskIp.substring((i3+1),netmaskIp.length));
			nip = '0x'+nip;
			mask4 = netmaskIp.substring((i3+1),netmaskIp.length)-0;

			i1=gatewayIp.indexOf('.');
			i2=gatewayIp.indexOf('.',(i1+1));
			i3=gatewayIp.indexOf('.',(i2+1));
			gip = hex(gatewayIp.substring(0,i1)) + hex(gatewayIp.substring((i1+1),i2)) +hex(gatewayIp.substring((i2+1),i3)) +hex(gatewayIp.substring((i3+1),gatewayIp.length));
			gip = '0x'+gip;
			pool4 = gatewayIp.substring((i3+1),gatewayIp.length)-0;

			if (Op_AND_4Byte(wip, nip) != Op_AND_4Byte(gip, nip)) {
				return false;
			}

			net_no = (lan4 & mask4);
			lo_broadcast =  (lan4 & mask4) + (255-mask4);

			return !(pool4==net_no || pool4==lo_broadcast);
		}

		/**
		 * RemoteManagementSettingVM model
		 * @method init
		 */
		function init() {
			var container = $('#container');
			ko.cleanNode(container[0]);
			var vm = new StaticMACIPAddressVM();
			ko.applyBindings(vm, container[0]);

			$("#bindMACIPSwitchFrm").validate({
				submitHandler : function(){
					vm.setBindSwitch();
				}
			});

			$('#bindMACIPContentFrm').validate({
				submitHandler : function() {
					vm.addRule();
				},
				rules: {
					txtMacAddress: {
						mac_check: true
					},
					txtIpAddress: {
						ip_check: true
					}
				},
				errorPlacement: function(error, element) {
					if(element.attr("name") == "txtMacAddress") {
						error.appendTo("#macErrorDiv");
					}
					if(element.attr("name") == "txtIpAddress") {
						error.appendTo("#ipErrorDiv");
					}
				}

			});

			$("#bindMACIPListFrm").validate({
				submitHandler : function(){
					vm.deleteRule();
				}
			});
		}

		return {
			init : init
		};
	});