define([ 'jquery', 'knockout', 'configPath', 'service', 'underscore' ],

    function($, ko, config, service, _) {

        /**
         * system fm setting VM
         * @class FmSettingVM
         */
        function FmSettingVM() {
            var self = this;
            var info = getFmSetting();
            self.fm_hz = ko.observable(info.fm_hz);
            self.fm_enable = ko.observable(info.fm_switch);
            self.fm_enable_click = function () {
                if(self.fm_enable()=='on'){
                    self.fm_enable("off");
                }else {
                    self.fm_enable("on");
                }
            };
            self.clear = function() {
                init();
            };

            self.save = function() {
                showLoading();
                var params = {};
                params.fm_hz = self.fm_hz();
                params.fm_switch = self.fm_enable();
                service.setFmSetting(params, function(result) {
                    if (result.result == "success") {
                        //self.clear();
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };
        }

        function getFmSetting() {
            return service.getFmSetting();
        }

        /**
         * 初始化DmzSettingVM model
         * @method init
         */
        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new FmSettingVM();
            ko.applyBindings(vm, container[0]);

            $('#fmApply').click(function() {
                $("#frmFMSetting").submit();
            });

            $('#frmFMSetting').validate({
                submitHandler : function() {
                    vm.save();
                },
                rules: {
                    fmText: 'digits_one_after_dot'
                },
                errorPlacement: function(error, element) {
                    if(element.attr("name") == "fmText") {
                        error.appendTo("#fm_div");
                    }else
                        error.insertAfter(element);
                }
            });
        }

        return {
            init : init
        };
    });