#!/bin/sh
#
# script file to start wlan applications (IAPP, Auth, Autoconf) daemon
#
# Usage: wlanapp.sh [start|kill] wlan_interface...br_interface
#

## error code
ERROR_WSCD_START_FAIL=8

if [ $# -lt 2 ] || [ $1 != 'start' -a $1 != 'kill' ] ; then 
	echo "Usage: $0 [start|kill] wlan_interface...br_interface"
	exit 1 
fi

TOP_VAR_DIR="/etc_rw/ztembb/volatile"
if [ -z "$BIN_DIR" ]; then
	BIN_DIR="/bin"
fi
START=1
PARAM1=$1
WLAN_INTERFACE=$2

rtl_kill_iwcontrol_pid() { 
	PIDFILE="$TOP_VAR_DIR/run/iwcontrol.pid"
	if [ -f $PIDFILE ] ; then
		PID=`cat $PIDFILE`
		echo "IWCONTROL_PID=$PID"
		if [ "$PID" != "0" ]; then
			kill -9 $PID 2>/dev/null
		fi
		rm -f $PIDFILE
	fi
}

rtl_kill_wps_pid() {
			# for WPS ---------------------------------->>
		for WLAN in $WLAN_INTERFACE ; do
		PIDFILE=$TOP_VAR_DIR/run/wscd-$WLAN.pid
		if [ -f $PIDFILE ] ; then
			PID=`cat $PIDFILE`
			echo "WSCD_PID=$PID"
			if [ "$PID" != "0" ]; then
				kill -9 $PID 2>/dev/null
			fi
			rm -f $PIDFILE	 
		fi 
	   done
	#<<----------------------------------- for WPS
}

rtl_wlanapp() {
	if [ $PARAM1 = 'kill' ]; then
		START=0
	fi
	
	rtl_kill_iwcontrol_pid
	rtl_kill_wps_pid

	rm -f $TOP_VAR_DIR/*.fifo

	if [ $START = 0 ]; then
		return;
	fi
}
rtl_wlanapp
