define(['service','knockout', 'configPath', 'router', 'language'], function(service,ko, config, router, language) {
    var loginLockTimer = 0;
    var leftSeconds;
    var uiLoginTimer;
    var loginCount;
    var $lockContainer;
    var $leftUnlockTime;
    var $password;
    var $savePassword;
    var $language;

    function LoginVM(){
        var mode = service.getConnectionMode();
        var self = this;

        self.hasSave = ko.observable(config.HAS_SAVE_LOGIN_PASSWORD);
        self.showLanguage = ko.observable(config.LANGUAGES.length>1);
        var currentLan = language.getLanguage();
        var languages = _.map(config.LANGUAGES, function(item) {
            return new Option(item.name, item.value);
        });

        self.languages = ko.observableArray(languages);
        self.currentLan = ko.observable(currentLan.Language);

        self.langChangeHandler = function(data, event) {
            clearValidateMsg();

            service.setLanguage({Language: self.currentLan()}, function() {
                setLocalization(self.currentLan());
            });
        };

        //init language
        language.setLocalization(self.currentLan());
    }
    var timer = startLoginStatusInterval();
    function startLoginStatusInterval() {
        return setInterval(function () {
            var info = service.getStatusInfo();
            if (!info.isLoggedIn) {
                gotoLogin();
                return;
            }
            lastLoginStatus = service.getStatusInfo().isLoggedIn ? "1" : "0";
        }, 1000);
    }

    function gotoLogin() {
        if (window.location.hash != '#/login') {
            if (!manualLogout && lastLoginStatus == "1") {
                manualLogout = false;
                lastLoginStatus = 'UNREAL';
                showAlert('need_login_again', function () {
                    window.location = "index.html";
                });
            }
            else if (lastLoginStatus == 'UNREAL') {
                //do nothing, only popup need_login_again alert one time
                return;
            }
            else {
                window.location = "index.html";
            }
        }
    }

    function initLanguage() {
        var currentLan = language.getLanguage().Language;
        language.setLocalization(currentLan);
        $language.val(currentLan);

        $language.off('change').on('change', function() {
            var lan = $(this).val();
            service.setLanguage({Language: lan}, function() {
                language.setLocalization(lan);
            });
        })
    }

    function init() {
        var $container = $('#container');
        ko.cleanNode($container[0]);
        var vm = new LoginVM();
        ko.applyBindings(vm, $container[0]);

        $lockContainer = $('#lockContainer', $container);
        $leftUnlockTime = $('#leftUnlockTime', $container);
        $password = $('#password', $container);
        $savePassword = $('#savePassword', $container);
        $language = $('#language');

        leftSeconds = 0;
        uiLoginTimer = 0;
        loginCount = 0;
        $lockContainer.hide();

        initLanguage();
        var info = service.getStatusInfo();
        if(window.location.href.indexOf("?no_connect") != -1){
            if(config.HAS_RJ45 && service.getEthernetConnect().is_rj45_connected){
                showAlert("pppoe_error_jump");
            } else {
                if(info.simStatus == "modem_sim_undetected"){
                    showAlert("no_simcard_jump");
                } else if(info.simStatus == "modem_sim_destroy" || info.simStatus == "modem_destroy") {
                    showAlert("invalid_simcard_jump");
                }else if(info.simStatus == "modem_imsi_waitnck"  || info.simStatus == "modem_waitpin"|| info.simStatus == "modem_waitpuk") {
                    showAlert("locked_simcard_jump");
                } else {
                    if(info.ppp_dial_conn_fail_counter == '0' || info.ppp_dial_conn_fail_counter == ''){
                        showAlert("no_connect_jump");
                    } else {
                        showAlert("connect_failed_jump");
                    }
                }
            }
        } else if(window.location.href.indexOf("?flow_beyond") != -1){
            showAlert("flow_beyond_jump",function(){
                service.setRedirectOff();
            });
        } else if(window.location.href.indexOf("?fota_upgrade") != -1){
            showAlert("fota_upgrade_jump",function(){
                service.setRedirectOff();
            });
        }

        $('#loginBtn').off('click').on('click', function() {
            $('#formLogin').submit();
        });

        $('#formLogin').validate({
            submitHandler:function () {
                doLogin();
            }
        });

        checkLoginData('init');
    }

    function doLogin() {
        if(loginCount == config.MAX_LOGIN_COUNT && leftSeconds != '-1'){
            showAlert("password_error_account_lock_time");
            $password.val("");
            return false;
        }

        window.clearInterval(timer);
        var para = {};
        if(config.HAS_SAVE_LOGIN_PASSWORD){
            para.password = $password.val();
            para.save_login = $savePassword.is(':checked')? "1" : "0";
        }else{
            para.password = $password.val();
        }
        service.login(para, function(data) {
            setTimeout(function () {
                timer = startLoginStatusInterval();
            }, 1300);
            if (data.result) {
                //setCookieRememberPassword(self.rememberPassword(), self.password());
                config.isLogin = true;
                loginCount = 0;
                uiLoginTimer= 300;
                window.clearInterval(loginLockTimer);

                var curentHref = window.location.href;
                if(config.SIM_CARD_STATUS == "modem_imsi_waitnck") {
                    window.location.hash = "#/network_lock";
                } else {
                    if(window.location.href.indexOf("?no_connect") != -1){
                        window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + "#/nosimcard";
                    } else if(window.location.href.indexOf("?flow_beyond") != -1){
                        window.location.href = curentHref.slice(0,curentHref.indexOf("?flow_beyond")) + (config.isTrafficAlertSet?"?traffic_view#/nosimcard":"?traffic_setting#/nosimcard");
                    } else if(window.location.href.indexOf("?fota_upgrade") != -1){
                        window.location.href = curentHref.slice(0,curentHref.indexOf("?fota_upgrade")) + "?ota_update#/nosimcard";
                    } else {
                        window.location.hash = "#/nosimcard";
                    }
                }
            } else {
                $password.val("");
                checkLoginData(function(){
                    if (loginCount == config.MAX_LOGIN_COUNT) {
                        showAlert("password_error_five_times");
                        startLoginLockInterval();
                    } else {
                        showAlert({msg: 'password_error_left', params: [config.MAX_LOGIN_COUNT - loginCount]});
                    }
                });
            }
        });
    }

    function checkLoginData(cb){
        service.getLoginData({}, function(r){
            var failTimes = parseInt(r.psw_fail_num_str, 10);
            loginCount = config.MAX_LOGIN_COUNT - failTimes;
            leftSeconds = r.login_lock_time;
            uiLoginTimer = r.login_lock_time;

            if(cb == 'init') {
                if(config.HAS_SAVE_LOGIN_PASSWORD){
                    var saveLogin = r.save_login;
                    if(saveLogin == "1") {
                        $password.val(r.psw_save);
                        $savePassword.prop('checked', true).checkboxradio('refresh');
                    }
                }
            }

            if($.isFunction(cb)){
                cb();
            } else if (loginCount == config.MAX_LOGIN_COUNT) {
                startLoginLockInterval();
            }
        });
    }

    function startLoginLockInterval() {
        loginLockTimer = setInterval(function () {
            service.getLoginData({}, function (data) {
                if (data.login_lock_time <= 0 || data.psw_fail_num_str == 3) {
                    loginCount = 0;
                    window.clearInterval(loginLockTimer);
                }
                if(leftSeconds != data.login_lock_time){
                    leftSeconds = data.login_lock_time;
                    uiLoginTimer = data.login_lock_time;
                } else {
                    uiLoginTimer = uiLoginTimer > 0 ? uiLoginTimer - 1 : 0;
                }

                showLockTimeInfo();
            });
        }, 1000);
    }

    function showLockTimeInfo() {
        if(loginCount == config.MAX_LOGIN_COUNT && leftSeconds != '-1') {
            $lockContainer.show();
            var formatted = transSecond2Time(uiLoginTimer);
            $leftUnlockTime.text(formatted.substring(formatted.indexOf(':') + 1, formatted.length));
        } else {
            $lockContainer.hide();
        }
    }

    return {
        init: init
    }
});

