/**
 * @module QuickSetting
 * @class QuickSetting
 */
define([ 'jquery', 'knockout', 'configPath', 'service', 'underscore' ],

    function ($, ko, config, service, _) {

        var minStep = 1;
        var maxStep = 6;



        /**
         * 快速设置 view model
         * @class quickSettingVM
         */
        function quickSettingVM() {
            var self = this;
            var info2 = service.getFmSetting();
            self.fm_hz = ko.observable(info2.fm_hz);
            self.fm_enable = ko.observable(info2.fm_switch);

            var info = service.getBluetoothSetting();
            self.allowVisible = ko.observable(info.allow_visible);
            self.bluetooth_enable = ko.observable(info.bluetooth_switch);
            self.currentStep = ko.observable(minStep);

            /**
             * 保存按钮事件
             * @event save
             */
            self.save = function () {

            };

            /**
             * 下一步按钮事件
             * @event next
             */
            self.next = function () {
                var currentStep = self.currentStep();
                if (currentStep == 2 && self.bluetooth_enable() =="0") {
                    showAlert("open_bt_switch");
                    return;
                }
                if (currentStep == 4 && self.fm_enable() =="off") {
                    showAlert("open_fm_switch");
                    return;
                }
                if (currentStep == 5 && self.fm_enable() =="on") {
                    showLoading();
                    var params = {};
                    params.fm_hz = self.fm_hz();
                    params.fm_switch = "on";
                    service.setFmSetting(params, function(result) {
                        if (result.result == "success") {
                            successOverlay();
                            var toStep = self.currentStep() + 1;
                            var result = changeStep(toStep);
                        } else {
                            errorOverlay();
                        }
                    });
                } else {
                    var toStep = self.currentStep() + 1;
                    var result = changeStep(toStep);
                }

            };
            /**
             * 上一步按钮事件
             * @event next
             */
            self.previous = function () {
                var currentStep = self.currentStep();
                var toStep = self.currentStep() - 1;
                var result = changeStep(toStep);
            };

            /**
             * 变换步骤时处理
             * @method changeStep
             */
            function changeStep(step) {
                if (step < minStep) {
                    step = minStep;
                }
                else if (step > maxStep) {
                    step = maxStep;
                }

                var result = true;
                if (step > self.currentStep()) {
                    result = checkStep(step);
                }
                if (result) {
                    self.currentStep(step);
                    $("td[id^='right_step_']").removeClass().addClass("step-left");
                    var tds = $("td[id^='step_']");
                    tds.each(function () {
                        var theStep = parseInt($(this).attr("id").replace("step_", ""));
                        if (theStep == step) {
                            $(this).text($.i18n.prop("bt_step_name_" + theStep)).attr("data-trans", "bt_step_name_" + theStep).removeClass().addClass("step-active-middle");
                            if (theStep == maxStep) {
                                $("#right_step_" + theStep).removeClass().addClass("step-active-right-end");
                            } else {
                                $("#right_step_" + theStep).removeClass().addClass("step-active-right");
                            }
                        } else {
                            $(this).text($.i18n.prop("bt_step_number_" + theStep)).attr("data-trans", "bt_step_number_" + theStep).removeClass().addClass("step-middle");
                            if (theStep == step - 1) {
                                $("#right_step_" + theStep).removeClass().addClass("step-active-left");
                            } else {
                                if (theStep == maxStep) {
                                    $("#right_step_" + theStep).removeClass().addClass("step-right-end");
                                } else {
                                    $("#right_step_" + theStep).removeClass().addClass("step-left");
                                }
                            }
                        }
                    });
                }
                return result;
            }

            /**
             * 下一步的检测
             * @method changeStep
             */
            function checkStep(step) {
                switch (step) {
                    case 1:
                        break;
                    case 2:
                        return true;
                    case 3:
                        break;
                    case 4:
                        break;
                    case 5:
                        break;
                    case 6:
                        break;
                }
                return true;
            }
        }

        /**
         * 初始化快速设置ViewModel
         * @method init
         */
        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new quickSettingVM();
            ko.applyBindings(vm, container[0]);

            $('#btnNext').click(function() {
                $("#quickSettingForm").submit();
            });

            $('#btnSave').click(function() {
                $("#quickSettingForm").submit();
            });

            $('#quickSettingForm').validate({
                submitHandler:function () {
                    if (vm.currentStep() < 6) {
                        vm.next();
                    } else {
                        vm.save();
                    }
                },
                rules: {
                    fmText: 'digits_one_after_dot'
                },
                errorPlacement: function(error, element) {
                    if(element.attr("name") == "fmText") {
                        error.appendTo("#fm_div");
                    }else
                        error.insertAfter(element);
                }
            });
        }

        return {
            init:init
        };
    }
);
