/**
 * @module bluetooth setting
 * @class bluetooth setting
 */
define([ 'jquery', 'knockout', 'configPath', 'service', 'underscore' ],

    function($, ko, config, service, _) {

        /**
         * system bluetooth setting VM
         * @class BluetoothSettingVM
         */
        function BluetoothSettingVM() {
            var self = this;
            var info = getBluetoothSetting();
            self.allowVisible = ko.observable(info.allow_visible);
            self.bluetooth_enable = ko.observable(info.bluetooth_switch);
            self.pairedDevices = ko.observableArray([]);
            self.unpairedDevices = ko.observableArray([]);

            self.setAllowedVisible = function() {
                if(!$("#btAllowBtn").hasClass("disable")){
                    var checkbox = $("#allowVisibleCheckbox:checked");
                    if(checkbox && checkbox.length == 0 ){
                        self.allowVisible("1");
                    }else{
                        self.allowVisible("0");
                    }
                }
            };

            self.clear = function() {
                init();
            };

			self.searchAvailableDevice = function(){
				function checkBTover() {
					service.getBluetoothSetting({}, function (data) {
						if (data.searchOver == '0') {
							//successOverlay();
							$("#search_apply").removeAttr('disabled').attr('enabled',true).removeClass('ui-state-disabled').removeAttr('data-trans').attr('data-trans','search').translate();
							clearInterval(searchTimer);
							//init();
						}
					})
				}

				//showLoading();
				$("#search_apply").removeAttr('enabled').attr('disabled',true).addClass('ui-state-disabled').removeAttr('data-trans').attr('data-trans','searching').translate();
				service.searchAvailableDevice({}, function(result) {
					if (result.result == "success") {
						searchTimer = setInterval(function () {
							checkBTover();
						},1000)
					} else {
						//errorOverlay();
					}
				});
			};

            self.save = function() {
                showLoading();
                var params = {};
                params.bluetooth_switch = self.bluetooth_enable();
                service.setBluetoothSetting(params, function(result) {
                    if (result.result == "success") {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };

            self.saveAllow = function() {
                showLoading();
                var params = {};
                params.allow_visible = self.allowVisible();
                service.setBluetoothAllow(params, function(result) {
                    if (result.result == "success") {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };

            self.fetchPairedDevices = function (cb) {
                service.getPairedList({}, function (data) {
                    self.pairedDevices(_.map(data.attachedDevices, function (ele, idx) {
                        var allData = data.attachedDevices[idx];
                        ele.idx = _.uniqueId('paired_');
                        ele.macAddress = allData.dev_mac;
                        ele.deviceName = allData.dev_name;
                        ele.pairedStaus = allData.dev_status;
                        return ele;
                    }));
                });

                $("#paired_div").translate();
            };
            self.fetchPairedDevices();

            self.fetchUnpairedDevices = function (cb) {
                service.getAvailableList({}, function (data) {
                    self.unpairedDevices(_.map(data.attachedDevices, function (ele, idx) {
                        var allData = data.attachedDevices[idx];
                        ele.idx = _.uniqueId('uppaired_');
                        ele.macAddress = allData.dev_mac;
                        ele.deviceName = allData.dev_name;
                        return ele;
                    }));
                });

                $("#unpaired_div").translate();
            };
            self.fetchUnpairedDevices();

            self.doUnpairBTAct = function(eleData, evt){
                doPairOrUnpairBT(eleData.macAddress,0);
            }

            self.doPairBTAct = function(eleData, evt){
                doPairOrUnpairBT(eleData.macAddress,1);
            }
            self.doConnectAct = function(eleData, evt){
                doConnectOrDisconnectPairedBT(eleData.macAddress,0);
            }

            self.doDisconnectAct = function(eleData, evt){
                doConnectOrDisconnectPairedBT(eleData.macAddress,1);
            }

            addInterval(function(){
                self.fetchPairedDevices();
                self.fetchUnpairedDevices();
            }, 5000);

            self.updateData = function(){
                self.fetchPairedDevices();
                self.fetchUnpairedDevices();
            }
        }

        var pairConnectCount = 0;
        function checkPairedConnectStatus(mac,flag) {
            var tempValue = flag;
            var tempMac = mac;
            service.getPairedList({},function(data){
                var pairedList = data.attachedDevices;
                var currIndex = 0;
                for(i=0;i<pairedList.length;i++){
                    if(pairedList[i].dev_mac == tempMac){
                        currIndex = i;
                        break;
                    }
                }
                if (pairedList[currIndex].dev_status == tempValue) {
                    successOverlay();
                    clearInterval(pairConnectTimer);
                    vm.updateData();
                } else {
                    if (pairConnectCount <= 10) {
                        pairConnectCount = pairConnectCount + 1;
                        addTimeout(function(){
                            checkPairedConnectStatus(mac,flag);
                        }, 1000);
                    } else {
                        errorOverlay();
                        clearInterval(pairConnectTimer);
                        clearValidateMsg();
                        vm.updateData();
                    }
                }
            })
        }

        function doConnectOrDisconnectPairedBT(mac,status){
            dirverCount = 0;
            showLoading();
            var params = {};
            params.curr_mac = mac;
            params.option_select = status == "1" ? 0:1;
            service.doConnectOrDisconnectPairedBT(params, function(result) {
                if (result.result == "success") {
                    pairConnectTimer = setInterval(function () {
                        checkPairedConnectStatus(mac,params.option_select);
                    },1000)
                } else {
                    errorOverlay();
                }
            });
        }

        var pairResultCount = 0;
        var doPairFlag = false;
        var doUnpairedFlag = false;
        function checkPairedResult(mac,flag) {
            var tempValue = flag;
            var tempMac = mac;

            service.getPairedList({},function(data){
                var pairedList = data.attachedDevices;
                var currIndex = 0;
				var uppairedFlagTemp = false;
                for(i=0;i<pairedList.length;i++){
                    if(pairedList[i].dev_mac == tempMac) {
                        doPairFlag = true;
						//doUnpairedFlag = true;
						uppairedFlagTemp = true;
                        break;
                    }
                }
				if(!uppairedFlagTemp&&pairResultCount>=2){
					doUnpairedFlag = true;
				}
				if((flag == 1 && doPairFlag) || (flag != 1 && doUnpairedFlag)){
                    doPairFlag = false;
                    doUnpairedFlag = false;
                    successOverlay();
                    clearInterval(pairTimer);
                    vm.updateData();
                }else {
					if (pairResultCount <= 20) {
                        pairResultCount = pairResultCount + 1;
                    } else {
                        doPairFlag = false;
                        doUnpairedFlag = false;
                        errorOverlay();
                        clearInterval(pairTimer);
                        clearValidateMsg();
                        vm.updateData();
                    }
                }
            })
        }

        doPairOrUnpairBT = function (mac,status){
            showLoading();
            var params = {};
            params.curr_mac = mac;
            params.option_select = status;
            service.doPairOrUnpairBT(params, function(result) {
                if (result.result == "success") {
                    pairTimer = setInterval(function () {
                        checkPairedResult(mac,params.option_select);
                    },1000)
                } else {
                    errorOverlay();
                }
            });
        }

        function getBluetoothSetting() {
            return service.getBluetoothSetting();
        }

        var vm;
        /**
         * 初始化DmzSettingVM model
         * @method init
         */
        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            vm = new BluetoothSettingVM();
            ko.applyBindings(vm, container[0]);

            $('#bt_switch_apply').click(function() {
                $("#frmBlueTooth").submit();
            });

            $('#bt_allow_apply').click(function() {
                $("#frmAllowBlueTooth").submit();
            });


            $('#frmBlueTooth').validate({
                submitHandler : function() {
                    vm.save();
                }
            });
            $('#frmAllowBlueTooth').validate({
                submitHandler : function() {
                    vm.saveAllow();
                }
            });
        }

        return {
            init : init
        };
    });