#!/bin/sh
#
# script file to start wlan applications (IAPP, Auth, Autoconf) daemon
#
# Usage: wlanapp.sh [start|kill] wlan_interface...br_interface
#

## error code
ERROR_WSCD_START_FAIL=8

if [ $# -lt 2 ] || [ $1 != 'start' -a $1 != 'kill' ] ; then 
	echo "Usage: $0 [start|kill] wlan_interface...br_interface"
	exit 1 
fi

TOP_VAR_DIR="/etc_rw/ztembb/volatile"
TOP_ETC_DIR="/etc"
TOP_TMP_DIR="/tmp"
CONFIG_ROOT_DIR="/etc_rw/ztembb/volatile/rtl8192c"
RUN_DIR="/etc_rw/ztembb/volatile/run"

if [ ! -d "$TOP_TMP_DIR" ]; then
	mkdir $TOP_TMP_DIR
fi

if [ ! -d "$RUN_DIR" ]; then
	mkdir $RUN_DIR
fi

if [ -z "$BIN_DIR" ]; then
	BIN_DIR="/bin"
fi

KILLALL=killall
FLASH_PROG=flash
SLEEP=sleep

START=1
PARAM1=$1
WLAN_INTERFACE=$2

## kill 802.1x, autoconf and IAPP daemon ##
rtl_kill_iwcontrol_pid() { 
	PIDFILE="$TOP_VAR_DIR/run/iwcontrol.pid"
	if [ -f $PIDFILE ] ; then
		PID=`cat $PIDFILE`
		echo "IWCONTROL_PID=$PID"
		if [ "$PID" != "0" ]; then
			kill -9 $PID 2>/dev/null
		fi
		rm -f $PIDFILE
	fi
}

rtl_kill_wps_pid() {
			# for WPS ---------------------------------->>
		for WLAN in $WLAN_INTERFACE ; do
		PIDFILE=$TOP_VAR_DIR/run/wscd-$WLAN.pid
		if [ -f $PIDFILE ] ; then
			PID=`cat $PIDFILE`
			echo "WSCD_PID=$PID"
			if [ "$PID" != "0" ]; then
				kill -9 $PID 2>/dev/null
			fi
			rm -f $PIDFILE	 
		fi 
	   done
	#<<----------------------------------- for WPS
}

DEAMON_CREATED=0

# for WPS ------------------------------------------------->>
rtl_start_wps() {
	if [ ! -e $BIN_DIR/wscd ]; then
		return;
	fi
			
			USE_IWCONTROL=1
			DEBUG_ON=1
			_ENABLE_1X=0
			WSC=1
			CONFIG_DIR=$CONFIG_ROOT_DIR/$WLAN
			CONF_FILE=$TOP_VAR_DIR/wsc-$WLAN.conf
			FiFO_File=$TOP_VAR_DIR/wscd-$WLAN.fifo
				_ENABLE_1X=1


			if [ $WSC = 1 ]; then
				if [ ! -f $TOP_VAR_DIR/wps/simplecfgservice.xml ]; then
					if [ -e $TOP_VAR_DIR/wps ]; then
						rm $TOP_VAR_DIR/wps -rf
					fi
					mkdir $TOP_VAR_DIR/wps
					#cp $TOP_ETC_DIR/simplecfg*.xml $TOP_VAR_DIR/wps
					cat $TOP_ETC_DIR/simplecfgservice.xml > $TOP_VAR_DIR/wps/simplecfgservice.xml
				fi

				$BIN_DIR/$FLASH_PROG upd-wsc-conf $TOP_ETC_DIR/wscd.conf $CONF_FILE $WLAN_INTERFACE
				_CMD="$_CMD -start"
				_CMD="$_CMD -c $CONF_FILE -w $WLAN"
		
				if [ $USE_IWCONTROL = 1 ]; then
					_CMD="$_CMD -fi $FiFO_File"
					DEAMON_CREATED=1
				fi
		
	
					_CMD="$_CMD -start_pbc"
			
					#PIN=$3
					#_CMD="$_CMD -peer_pin "
		
				WSC_CMD=$_CMD
				echo "cmd: wscd $WSC_CMD"
				$BIN_DIR/wscd $WSC_CMD $PIN -daemon
				
				WAIT=5
				while [ $USE_IWCONTROL != 0 -a $WAIT != 0 ]		
				do	
					if [ -e $FiFO_File ]; then
						break;
					else
						$SLEEP 1
						WAIT=$((WAIT - 1))
					fi
				done
				if [ $WAIT = 0 ]; then
					exit $ERROR_WSCD_START_FAIL;
				fi
			fi
		

}
#<<--------------------------------------------------- for WPS

rtl_start_iwcontrol() {
	if [ $DEAMON_CREATED = 1 ]; then
		$BIN_DIR/iwcontrol $WLAN_INTERFACE
	fi
}

rtl_wlanapp() {
	if [ $PARAM1 = 'kill' ]; then
		START=0
	fi
	
	rtl_kill_iwcontrol_pid
	rtl_kill_wps_pid

	rm -f $TOP_VAR_DIR/*.fifo

	if [ $START = 0 ]; then
		return;
	fi
	rtl_start_wps
	rtl_start_iwcontrol
}

rtl_wlanapp
