#!/bin/sh
# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

RESOLV_CONF="/etc/resolv.conf"
[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

work_mode=`cfg get opms_work_mode`
file_system_readonly=`cfg get file_read_only_flag`
if [ "$file_system_readonly" = "1" ] ; then
    echo "$0:read only file system"
    RESOLV_CONF="/var/run/resolv.conf"
fi

case "$1" in
    deconfig)
      #  /sbin/ifconfig $interface 0.0.0.0
        ;;

    renew|bound)
        /sbin/ifconfig $interface $ip $BROADCAST $NETMASK

        if [ -n "$router" ] ; then
            echo "deleting routers"
            while route del default gw 0.0.0.0 dev $interface ; do
                :
            done

            metric=0
            for i in $router ; do
                metric=`expr $metric + 1`
                route add default gw $i dev $interface metric $metric
				#ifconfig $interface $ip netmask $subnet up
				#cfg set wan_connect_status=rj45_connected
				if [ "bridge" = "$work_mode" ];then
                                sleep 3
                                echo "interfcae $interface $ip $subnet"
                                ifconfig $interface $ip netmask $subnet up
                                cfg set lan_ipaddr_for_current=$ip
                  router_msg getway_change $ip
				else
                  cfg set wan_ipaddr=$ip
                  cfg set wan_netmask=$subnet
                  cfg set wan_gateway=$i
				fi
				
            done
        fi
        #cfg set cable_dial_status=ppp_connected
		cfg set dhcp_wan_status=1
		router_msg network_up
        echo -n > $RESOLV_CONF
        [ -n "$domain" ] && echo search $domain >> $RESOLV_CONF
	tmp="0" 
        for i in $dns ; do
            echo adding dns $i
            echo nameserver $i >> $RESOLV_CONF
	  
	          #chang by maxl, for dns set error! --20101216
          	#cfg set wan_primary_dns=$i
          	if [ "$tmp" != "$prefer_dns_auto" ]; then
          		cfg set prefer_dns_auto=$i
				prefer_dns_auto=$i
          	else
          			cfg set standby_dns_auto=$i
          	fi
            tmp=$i
	done
		# notify goahead when the WAN IP has been acquired. --yy
		#killall -SIGUSR2 goahead
        ;;
esac

exit 0

