# 
# Created by zhangyuelong10100551 @ 2014.6.26 
# init firewall
#

#FMT_ECHO=1>/dev/null 2>&1
wan_dev_name=$1
remote_manager=`cfg get RemoteManagement`
wan_ping=`cfg get WANPingFilter`
firewall_switch=`cfg get fwSwitchEnabled`
adb_enable=`cfg get adb_enable`
remotemr_port=`cfg get remotemr_port`
ZTE_SYS_FW_FILTER_CHAIN=sys_fw_filter
ZTE_REMOTEMANAGER_CHAIN=remote_manager
ZTE_REMOTE_SETMARK_CHAIN=remote_mark


if [ "$wan_dev_name" == "" ]
then
  echo "$0: no dev in, set rmnet_data0!"
  wan_dev_name="rmnet_data0"
fi

#clear chain
iptables -t filter -F $ZTE_SYS_FW_FILTER_CHAIN
iptables -t filter -F $ZTE_SYS_FW_FILTER_CHAIN
ip6tables -t filter -F $ZTE_SYS_FW_FILTER_CHAIN
iptables -t nat -F $ZTE_REMOTEMANAGER_CHAIN
iptables -t mangle -F $ZTE_REMOTE_SETMARK_CHAIN
iptables -D INPUT -p tcp --dport 22 -j DROP
iptables -D INPUT -p udp --dport 22 -j DROP
iptables -D INPUT -p tcp --dport 5555 -j DROP
iptables -D INPUT -p udp --dport 5555 -j DROP

remotemr_add_whitelist()
{
	#remote_manage src is a ip range like 192.168.0.1+192.168.0.10;192.168.0.1+192.168.0.10;192.168.0.1+192.168.0.10;
	#or is like src ip: 192.168.0.1+;192.168.0.1+192.168.0.10;192.168.0.1+192.168.0.10+;
	#or is like specific: 10.129.48.0/22+; or 10.129.48.0+;
	#in the nv,the ; and the + keep reserved,for split the ip in accord.
	whitelist=`cfg get remotemg_white_list`
	
	#if whitelist is null,do nothing
	if [ "$whitelist" != "" ]
	then
		delmit1=";"
		result=$(echo $whitelist | grep "${delmit1}")
		#$result is null: has not include ; else include ; if include then split

		if [ "$result" != "" ]
		then
			#first split with ;
			fstr=`echo $whitelist | cut -d \; -f 1`
			i=1
			while [ "$fstr" != "" ]
			do
				delmit2="+"
				result=$(echo $fstr | grep "${delmit2}")
				if [ "$result" != "" ]
				then
					#split with +
					src_ip_start=`echo $fstr | cut -d \+ -f 1`
					src_ip_end=`echo $fstr | cut -d \+ -f 2`
					if [ "$src_ip_end" != "" ]
					then
						iptables -I $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -m iprange --src-range $src_ip_start-$src_ip_end -p tcp --dport 80 -j ACCEPT
					else
						iptables -I $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp -s $src_ip_start --dport 80 -j ACCEPT
					fi
				else
					iptables -I $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp -s $fstr --dport 80 -j ACCEPT
				fi
				
				let i=i+1
				fstr=`echo $whitelist | cut -d \; -f $i`
			done
		else
			#no ; maybe like 10.129.48.0/22
			iptables -I $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp -s $whitelist --dport 80 -j ACCEPT
		fi
		
		
		#here is whithelist,the rules below is accquired
		iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 80 -j DROP
	fi
	
	echo "add whitelist done."
}

#for lan ssh
iptables -A INPUT -p tcp --dport 22 -j DROP
iptables -A INPUT -p udp --dport 22 -j DROP


if [ "$adb_enable" != "1" ];then
	iptables -A INPUT -p tcp --dport 5555 -j DROP
	iptables -A INPUT -p udp --dport 5555 -j DROP
fi

iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmp --icmp-type echo-reply -j ACCEPT
ip6tables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmpv6 --icmpv6-type echo-reply -j ACCEPT


if [ "$remote_manager" == "1" ]
then
	remotemr_add_whitelist
	if [ "$remotemr_port" != "" ]
	then
		iptables -t mangle -A $ZTE_REMOTE_SETMARK_CHAIN -p tcp --dport $remotemr_port -j MARK --set-mark 1
		iptables -t nat -A $ZTE_REMOTEMANAGER_CHAIN -p tcp --dport $remotemr_port -j REDIRECT --to-port 80
		iptables -I $ZTE_SYS_FW_FILTER_CHAIN 1 -i $wan_dev_name -p tcp --dport 80 -m mark ! --mark 1 -j DROP
	fi
else
	iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 80 -j DROP
	ip6tables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 80 -j DROP
fi


	
if [ "$firewall_switch" == "0" ]
then
  wan_ping=1
fi

if [ "$wan_ping" == "0" ]
then
  iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmp -j DROP
  ip6tables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmpv6 --icmpv6-type echo-request -j DROP
fi

# disable 22:sh
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 22 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 22 -j DROP
# disable 23: telnet
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 23 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 23 -j DROP
# disable 53:domain
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 53 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 53 -j DROP
# disable 1900:upnp
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 1900 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 1900 -j DROP
# disable 5555:freeciv
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 5555 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 5555 -j DROP
echo "firewall_sys_fw done"



