#!/bin/sh
# ===========================================================
# usb0_2_bridge.sh
# create by zhangyuelong10100551 2012.6.26

echo "usb0_2_bridge.sh.sh: start..."

# here we check if datacard(nat) mode
product_type=`cfg get product_type`
usb_dev_name="rndis0"

if `cat /proc/cpuinfo | grep -q 9630`
then
  if [ "NO_DRIVER_UFI" = "$product_type" ] ; then
	echo "usb0_2_bridge.sh: MDM9630 $product_type exit"
	exit
  fi
else
  echo "usb0_2_bridge.sh: not MDM9630, go on"
fi

# only data card mode
if [ "ONLY_DATA_CARD" = "$product_type" ]
then
  echo "usb0_2_bridge.sh: $product_type only data card mode, exit"
  exit
else
  echo "usb0_2_bridge.sh: $product_type will check product type further"
fi

turbo_nat_flag=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`
if [ "$turbo_nat_flag" == "1" ] ; then
    usb_dev_name="usb0"
elif [ "$turbo_nat_flag" == "2" -o "$turbo_nat_flag" == "4" ] ; then
    usb_dev_name="ecm0"
elif [ "$turbo_nat_flag" == "3" ] ; then
    usb_dev_name="rndis0"
else
   echo "bridge_setup.sh:the interface is not usb0 or ecm0"
fi

# here we setup bridge0, and add usb to bridge0
if [ -d "/sys/class/net/bridge0" ]
then
  echo "usb0_2_bridge.sh: bridge0 exist ..."
else
  echo "usb0_2_bridge.sh: setup bridge0 ..."
  brctl addbr bridge0
  lan_ipaddr=`cfg get lan_ipaddr_for_current`
  lan_netmask=`cfg get lan_netmask`
  echo "usb0_2_bridge.sh: here bridge get lan ip is $lan_ipaddr"
  ifconfig bridge0 $lan_ipaddr netmask $lan_netmask up
  echo 1 > /proc/sys/net/ipv4/conf/bridge0/proxy_arp
  #iptables -A FORWARD --in-interface bridge0 -j ACCEPT
fi

echo "usb0_2_bridge.sh: ifup usb0 iface  ..."
ifconfig $usb_dev_name 169.254.3.1 netmask 255.255.255.0 up
route del -net 169.254.3.0 netmask 255.255.255.0 dev $usb_dev_name
ip -6 route del fe80::/64 dev $usb_dev_name
echo "usb0_2_bridge.sh: add usb0 to bridge ..."
brctl addif bridge0 $usb_dev_name
echo "usb0_2_bridge.sh: done ..."
# =============================================================
