#!/bin/sh
#=====================================================
#set_dns_resolv.sh
#create by hebin10099125 2012.05.15
#modify by zhangyuelong10100551
DNS_RESOLV_FILE="/etc/resolv.conf"
DNS_RESOLV_FILE_PPP="/tmp/resolv.conf-ppp"
route_wifi_flag="/tmp/route_wifi.flag"
set_dns_run_flag="/tmp/set_dns.flag"
set_dns_flag=`cfg get dns_err_set_dns_flag`
GOOGLE_DNS=8.8.8.8

file_system_readonly=`cfg get file_read_only_flag`
if [ "$file_system_readonly" = "1" ] ; then
    echo "$0:read only file system"
    DNS_RESOLV_FILE="/var/run/resolv.conf"
fi

if [ -f "$set_dns_run_flag" ] ; then
	echo "set_dns_resolv.sh is running exit" 
	exit 0
fi
touch $set_dns_run_flag
 
echo "" > $DNS_RESOLV_FILE_PPP

# ipv4 dns set
dnsmode=`cfg get dns_mode`
if [ "$dnsmode" = "auto" ] ; then
    echo "auto dnsmode"
    dns1=`cfg get prefer_dns_auto`
    if [ -n "$dns1" ];then
    	echo "nameserver" $dns1 >> $DNS_RESOLV_FILE_PPP
    else
    	if [ "$set_dns_flag" == "1" ];then
			echo "nameserver" $GOOGLE_DNS >> $DNS_RESOLV_FILE_PPP
		fi
	fi
	
    dns2=`cfg get standby_dns_auto`
    if [ -n "$dns2" ];then
    	echo "nameserver" $dns2 >> $DNS_RESOLV_FILE_PPP
    fi
   
fi

if [ "$dnsmode" = "manual" ] ; then
    echo "manual dns mode"
    
    dns1=`cfg get prefer_dns_manual`
    if [ -n "$dns1" ];then
    	echo "nameserver" $dns1 >> $DNS_RESOLV_FILE_PPP
    fi
    
    dns2=`cfg get standby_dns_manual`
    if [ -n "$dns2" ];then
    	echo "nameserver" $dns2 >> $DNS_RESOLV_FILE_PPP
    fi
    
fi

 # ipv6 dns set
ipv6_dns_mode=`cfg get ipv6_dns_mode`
echo "ipv6_dns_mode: $ipv6_dns_mode"
    
if [ "$ipv6_dns_mode" = "auto" ];then

	ipv6_prefer_dns_auto=`cfg get ipv6_prefer_dns_auto`
	ipv6_standby_dns_auto=`cfg get ipv6_standby_dns_auto`
				
		if [ -n "$ipv6_prefer_dns_auto" ]&& [ "$ipv6_prefer_dns_auto" != "::" ];then
			echo nameserver $ipv6_prefer_dns_auto >> $DNS_RESOLV_FILE_PPP
		fi
				
	if [ -n "$ipv6_standby_dns_auto" ] && [ "$ipv6_standby_dns_auto" != "::" ];then
		echo nameserver $ipv6_standby_dns_auto >> $DNS_RESOLV_FILE_PPP
	fi
	
elif [ "$ipv6_dns_mode" = "manual" ];then
    
	ipv6_prefer_dns_manual=`cfg get  ipv6_prefer_dns_manual`
	ipv6_standby_dns_manual=`cfg get ipv6_standby_dns_manual`
			
	if [ -n "$ipv6_prefer_dns_manual" ] && [ "$ipv6_prefer_dns_manual" != "::" ];then
		echo nameserver $ipv6_prefer_dns_manual >> $DNS_RESOLV_FILE_PPP
	fi
			
	if [ -n "$ipv6_standby_dns_manual" ] && [ "$ipv6_standby_dns_manual" != "::" ];then
		echo nameserver $ipv6_standby_dns_manual >> $DNS_RESOLV_FILE_PPP 
	fi
			
fi




# if route is on wifi, don't change resolv.conf
if [ -f $route_wifi_flag ]; then
  echo "Router is wifi"
else
  echo "Router is 3G/4G"
  cp -fr $DNS_RESOLV_FILE_PPP $DNS_RESOLV_FILE
fi
rm $set_dns_run_flag