# 
# Created by LiuWei @ 2010.8.27 
# init firewall
#

#FMT_ECHO=1>/dev/null 2>&1

ZTE_FILTER_CHAIN=macipport_filter
ZTE_FORWARD_CHAIN=port_forward
ZTE_DMZ_CHAIN=DMZ
ZTE_MAP_CHAIN=port_map
ZTE_URL_FILTER=url_filter

#clear filter
iptables -t filter -F
iptables -t filter -X $ZTE_FILTER_CHAIN
iptables -t filter -X $ZTE_URL_FILTER

iptables -P INPUT ACCEPT
iptables -P OUTPUT ACCEPT
iptables -P FORWARD ACCEPT

#clear nat
iptables -t nat -F
iptables -t nat -X $ZTE_FORWARD_CHAIN
iptables -t nat -X $ZTE_DMZ_CHAIN
iptables -t nat -X $ZTE_MAP_CHAIN

#make a new chain for filter
#add by zhangrui00144639 for check_privateip @2014.3.28 begin
iptables -t filter -I FORWARD -m state --state INVALID -j DROP
iptables -t filter -A OUTPUT -m state --state INVALID -j DROP
#add by zhangrui00144639 for check_privateip @2014.3.28 end
iptables -t filter -N $ZTE_URL_FILTER
iptables -t filter -A FORWARD -j $ZTE_URL_FILTER

iptables -t filter -N $ZTE_FILTER_CHAIN
iptables -t filter -A FORWARD -j $ZTE_FILTER_CHAIN

# begin - zhangyuelong10100551 for ipv6 firewall 2012.08.30
#clear filter
ip6tables -t filter -F
ip6tables -t filter -X $ZTE_FILTER_CHAIN

ip6tables -P INPUT ACCEPT
ip6tables -P OUTPUT ACCEPT
ip6tables -P FORWARD ACCEPT

ip6tables -t filter -N $ZTE_FILTER_CHAIN
ip6tables -t filter -A FORWARD -j $ZTE_FILTER_CHAIN
# end - zhangyuelong10100551 for ipv6 firewall 2012.08.30

#Make a new chain for nat
iptables -t nat -N $ZTE_FORWARD_CHAIN
iptables -t nat -N $ZTE_DMZ_CHAIN
iptables -t nat -N $ZTE_MAP_CHAIN

iptables -t nat -I PREROUTING 1 -j $ZTE_FORWARD_CHAIN
iptables -t nat -I PREROUTING 2 -j $ZTE_MAP_CHAIN
iptables -t nat -I PREROUTING 3 -j $ZTE_DMZ_CHAIN

echo "firewall init done"
#nat.sh




