#!/bin/sh

if [ -f /var/hibernate_mode.lock ] ; then
	# to resolve issue which pressing power key to trigger hibernate and 
	# auto power saving are happenned at the same time
	exit 1
fi

eval `sncfg mget PWM_HOTSPOT_STANDBY_MODE WLAN_WifiEnable`

sncfg set PWM_HOTSPOT_STANDBY_MODE_FLAG 1
 
sncfg set lcm.display.mode 4

sncfg set lcm.display.done 0

while [ "$(sncfg get lcm.display.done | grep \"1\")" == "" ]
do
	sleep 1
done

sncfg get lcm.display.done

#/sbin/lcm_ctrl 1    

if [ "$PWM_HOTSPOT_STANDBY_MODE" == 0 ]; then
	printf "[%12s] %s\n" "pw_standby_on.sh" "disable WAN connect"
	nmc sys hibernate enable
	while [ "$(sncfg get nm.wificlt_mode | grep \"0\")" == "" ]
	do
		sleep 1
	done
	sleep 1
elif [ "$PWM_HOTSPOT_STANDBY_MODE" == 1 ]; then
	printf "[%12s] %s\n" "pw_standby_on.sh" "disable wifi"
	if [ "$WLAN_WifiEnable" == 1 ]; then
		nmc if wifi1 pwmradiooff
		while [ "$(sncfg get nm.profile.wifi.radio.state | grep \"2\")" == "" ]
		do
			sleep 1
		done
		sleep 1
	fi
	printf "[%12s] %s\n" "pw_standby_on.sh" "disable WAN query"
	nmc sys standby enable
fi

sleep 1

printf "[%12s] %s\n" "pw_standby_on.sh" "disable LCM"
/sbin/lcm_ctrl 0

/sbin/pwmctrl.elf mode standby
