#!/bin/sh

eval `sncfg mget WLAN_WifiEnable PWM_HOTSPOT_STANDBY_MODE_FLAG`

if [ -f /var/hibernate_mode.lock ] ; then
	exit 1
else
	touch /var/hibernate_mode.lock
fi

sncfg set lcm.display.mode 2

sncfg set lcm.display.done 0

while [ "$(sncfg get lcm.display.done | grep \"1\")" == "" ]
do
  sleep 1
done

sncfg get lcm.display.done

eval `sncfg get pwm_hibernate_by_button`
if [ "$pwm_hibernate_by_button" == 1 ]; then
    #flag = 1 means trigger from pwrkey push
    /sbin/lcm_ctrl 1    
fi


printf "[%12s] %s\n" "pw_hibernate_on.sh" "disable wifi"
if [ "$WLAN_WifiEnable" == 1 ]; then
	nmc if wifi1 pwmradiooff
	while [ "$(sncfg get nm.profile.wifi.radio.state | grep \"2\")" == "" ]
	do
		sleep 1
	done
	sleep 1
fi

printf "[%12s] %s\n" "pw_hibernate_on.sh" "disable WAN connect"
if ["$PWM_HOTSPOT_STANDBY_MODE_FLAG" == 0 ]; then
	nmc sys hibernate enable
	while [ "$(sncfg get nm.wificlt_mode | grep \"0\")" == "" ]
	do
		sleep 1
	done
	sleep 1
fi

printf "[%12s] %s\n" "pw_hibernate_on.sh" "disable LCM"
/sbin/lcm_ctrl 0

#gpioctl blink5 blue

/sbin/pwmctrl.elf mode hibernate
