var g_server = null;

$(document).ready(function() {
    button_enable('apply', '0');
    init();

    $("#apply").click(function() {
        if (!isButtonEnable('apply')) {
            return;
        }
        apply();
    });
    $('.input_select').change( function() {
        button_enable('apply', '1');
    });
});

function getCountrylist() {
    getConfigData('config/voice/country.xml', function($xml) {      
        var ret = _xml2feature($xml);
        if (null != ret.country) {
            var country = CreateArray(ret.country);
			$('#voip_regionSettings_select').empty();
            $(country).each( function(i) {
                $('#voip_regionSettings_select').append("<option value=" + country[i].name + ">"+ eval(country[i].value) + "</option>");
            });
        }else{
			$('.voip_regionSettings').addClass("hidden");
		}
    }, {
        sync: true
    });
}

function set_data() {

        if ("" !== g_server.dtmfmethod) {
            $('#voip_dtmfmethod_select').val(g_server.dtmfmethod);
            $('#voip_dtmfmethod_select').removeAttr('disabled');
        }else{
            $('#voip_dtmfmethod_select').attr('disabled', 'disabled');
        }

        if ("" !== g_server.faxoption) {
            $('#voip_faxoption_select').val(g_server.faxoption);
            $('#voip_faxoption_select').removeAttr('disabled');
        }else{
            $('#voip_faxoption_select').attr('disabled', 'disabled');
        }

        if ("" !== g_server.region) {
            $('#voip_regionSettings_select').val(g_server.region);
            $('#voip_regionSettings_select').removeAttr('disabled');
        }else{
            $('#voip_regionSettings_select').attr('disabled', 'disabled');
        }    
		            
}

function init() {	
    getAjaxData('api/voice/voiceadvance', function($xml) {
        var cap_ret = xml2object($xml);
        if ('response' == cap_ret.type) {
            g_server = cap_ret.response;
        }
    }, {
        sync : true
    });
     
    getAjaxData('api/voice/sipaccount', function($xml) {
      var cap_ret = xml2object($xml);
      var tempvalue = 'CS,';
      $("#fxsmode").find("option").remove();
      if ('response' == cap_ret.type && null == cap_ret.response.account) {
	      $("#fxsmode").attr('disabled','disabled');
	      showConfirmDialog(IDS_VOIP_Error_Message1,function(){gotoPageWithoutHistory("serverbasic.html");});
      }else{ 	
	  	tempvalue = tempvalue + cap_ret.response.account.directorynumber;	
		 $("#fxsmode").append("<option value='" + tempvalue + "'>" + IDS_Voice_Cs_Primary + "</option>");
		 $("#fxsmode").append("<option value='" + 'auto' + "'>" + IDS_Voice_Sip_Primary + "</option>");
		 $("#fxsmode").append("<option value='" + 'CS' + "'>" + IDS_Voice_Cs_Only + "</option>");
		 $("#fxsmode").append("<option value='" + cap_ret.response.account.directorynumber + "'>" + IDS_Voice_Sip_Only + "</option>");
	  	if ("" !== g_server.outgoinglist) {
	  	    $('#fxsmode').val(g_server.outgoinglist);
	  	    $('#fxsmode').removeAttr('disabled');
	  	}else{
	  	    $('#fxsmode').attr('disabled', 'disabled');
        }
	  }
    }, {
    sync:true
    });
    getCountrylist();
	set_data();
}

function apply() {
    clearAllErrorLabel();
		
    button_enable('apply', '0');
    g_server.dtmfmethod = $('#voip_dtmfmethod_select').val();
    g_server.faxoption = $('#voip_faxoption_select').val();
    if(null !== $('#voip_regionSettings_select').val()){
        g_server.region = $('#voip_regionSettings_select').val();
    }
	g_server.outgoinglist = $('#fxsmode').val();
    var newXmlString = object2xml('request', g_server);
    saveAjaxData('api/voice/voiceadvance', newXmlString, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            init();
            showInfoDialog(common_success);
        } else {
            button_enable('apply','1');
            if ( typeof (ret.error) != 'undefined' && ret.error.code == ERROR_SYSTEM_BUSY) {
                showInfoDialog(common_system_busy);
            } else {
                showInfoDialog(common_fail);
            }
        }
    });
}