var URL_FILTER_NUM = 16;
var ok_flag = 0;
var add_flag = 0;
var MAX_NUMBER = 63;
var filterStatusArray = [
[FILTER_DISABLED, common_off],
[FILTER_ENABLED, common_on]
];

var g_source_num = 0;
var firewall_status = null;

var g_filter_mode = null;
var g_new_filter_mode = null;
var g_black_filters = null;
var g_white_filters = null;
var BLACK_URL = "black";
var WHITE_URL = "white";
var FILTER_MODE_BLACK = 0;

function addDomainNameFilter(insertNode) {
    var addLine = null;

    if(arguments[3] !== 'undefined' && arguments[3] !== "") {
        addLine = "<tr class='user_add_line show_"+arguments[3]+"'>";
    }
    else {
        addLine = "<tr class=\"user_add_line\">";
    }

    addLine += "<td  width='420'  style='word-break: break-all;'>" + arguments[1] + "</td>";
    addLine += "<td>" + arguments[2] + "</td>";
    if ((firewall_status != null && firewall_status.FirewallMainSwitch == 0) || (firewall_status != null &&
    firewall_status.firewallurlfilterswitch == 0)) {
        addLine += "<td class='user_options'><span class=\"button_edit_list clr_gray\">" + common_edit + "</span><span class=\"button_delete_list clr_gray\">" + common_delete + "</span></td></tr>";
    }
    else {
        addLine += "<td class='user_options'><span class=\"button_edit_list clr_blue\">" + common_edit + "</span><span class=\"button_delete_list clr_blue\">" + common_delete + "</span></td></tr>";
    }

    var currentTrTotal = $(insertNode).size();
    $(insertNode).eq(currentTrTotal - 2).after(addLine);
}

function isVaildValue() {
    $.each($('.qtip-defaults'), function() {
        $(this).remove();
    });
    var domainNameFilter = $.trim($('#input_domain_name').val());
    if('' == domainNameFilter ) {
        showQtip('input_domain_name', IDS_security_urlfilter_isnull);
        return false;

    }

 if (!isValidAscIICharset(domainNameFilter) || !isVaildDomainname(domainNameFilter)) {
        showQtip('input_domain_name', IDS_security_urlfilter_error);
        return false;
    }
    if (!isStartWithChar(domainNameFilter) ||(domainNameFilter.indexOf(".") == -1 && domainNameFilter != "") ||(domainNameFilter.indexOf(".") != -1 && domainNameFilter.length == 1) ) {
        showQtip('input_domain_name', IDS_security_ddns_domain_contain);
        return false;
    }
    if (/\.$/.exec(domainNameFilter) || /^\./.exec(domainNameFilter) || /-$/.exec(domainNameFilter)|| /^-/.exec(domainNameFilter)) {
        showQtip('input_domain_name', IDS_security_domain_dot_char);
        return false;
    }
    if(!validEditSameDomain()) {
        showQtip('input_domain_name', IDS_security_ddns_domain_diff);
        return false;
    }
    return true;
}
function validEditSameDomain() {
    var validDomain = true;
    var ddns_valid_domain = $.trim($('#input_domain_name').val());
    var domain_List = $('.user_add_line');
    var i=0;
    for (i=0;i<domain_List.length;i++) {
        if (domain_List.eq(i).children().eq(0).html() == ddns_valid_domain) {
            validDomain = false;
        }
    }
    return validDomain;
}
function isStartWithChar(str) {
    var reg = /^[a-zA-Z]/;
    var value = reg.test(str);
    return value;
}
function isVaildDomainname(val) {
    if (val == '') {
        return false;
    }
    for (j = 0; j < val.length; j++) {
        var c = val.charAt(j);
        if (c >= 'a' && c <= 'z') {
            continue;
        } else if (c >= 'A' && c <= 'Z') {
            continue;
        } else if (c >= '0' && c <= '9') {
            continue;
        } else if (c == '-' || c == '.') {
            continue;
        } else {
            return false;
        }
    }
    return true;
}

function isValidAscIICharset(str) {
    var i=0;
    for(i = 0; i < str.length; i++) {
        if(!(str.charCodeAt(i) >= 33 && str.charCodeAt(i) <= 126)) {
            return false;
        }
    }
    return true;
}
function initPage() {
    button_enable('apply', '0');

    $('.user_add_line').remove();
    getAjaxData('api/security/firewall-switch', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            firewall_status = ret.response;
        }
    }, {
        sync: true
    });

    if (firewall_status != null && firewall_status.FirewallMainSwitch == 0) {
        button_enable('add_item', '0');
        $('#service_list').attr('disabled', true);
        $('input[name=radio]').attr('disabled', true);
        showInfoDialog(IDS_security_message_firewall_disabled);
       // return false;
    }
    if (firewall_status != null &&
    firewall_status.firewallurlfilterswitch == 0) {
        button_enable('add_item', '0');
        $('#service_list').attr('disabled', true);
        $('input[name=radio]').attr('disabled', true);
        showInfoDialog(IDS_security_urlfilter_disabled);
    }
    getAjaxData('api/security/url-filter', function($xml) {
        var ret = xml2object($xml);
        var filters = null;
        if(ret.type == 'response') {
        	if(ret.response == "\n" || ret.response == "") {
        		$("#blacklist_enable").get(0).checked = true;
        		$("#whitelist_enable").get(0).checked = false;
        		g_filter_mode = FILTER_MODE_BLACK;
        	}
        	else {
		        if(typeof(ret.response.urlfilterpolicy) == 'undefined') {
		            $('.urlfilter_mode').remove();
		            filters = ret.response.urlfilters.urlfilter;
		        }
		        else {
		            g_filter_mode = parseInt(ret.response.urlfilterpolicy,10);
		            g_black_filters = ret.response.blackurlfilters.urlfilter;
		            g_white_filters = ret.response.whiteurlfilters.urlfilter;
		            if (FILTER_MODE_BLACK == g_filter_mode) {
		                $("#blacklist_enable").get(0).checked = true;
		                $("#whitelist_enable").get(0).checked = false;
		                filters = g_black_filters;
		            }
		            else {
		                $("#blacklist_enable").get(0).checked = false;
		                $("#whitelist_enable").get(0).checked = true;
		                filters = g_white_filters;
		            }
		        }
		        showUrlFiters(filters);
        	}
        }
    }, {
        sync: true
    });
}

function addEnableOrDisenable() {
    if($('.urlfilter_mode').length > 0) {
        if($(".show_"+($("#blacklist_enable").get(0).checked == true ? BLACK_URL : WHITE_URL)).size() >= URL_FILTER_NUM ) {
               button_enable('add_item', '0');
        }     
    }
    else {
        if ($('.user_add_line').length >= URL_FILTER_NUM) {
            button_enable('add_item', '0');
        }
    }
}

function showUrlFiters(filters) {
    var status = '';
    var domainName = '';
    var filter_type = '';
    if($('.urlfilter_mode').length > 0) {
        filter_type = ($("#blacklist_enable").get(0).checked == true ? BLACK_URL:WHITE_URL);
    }
    if (filters) {
        if($.isArray(filters)) {
            $(filters).each( function(i) {
                domainName = XSSResolveCannotParseChar(filters[i].value);
                status = getDArrayElement(filterStatusArray, filters[i].status, 'value');
                addDomainNameFilter($('#service_list tr'),domainName,status,filter_type);
            });
        } else {
            domainName = XSSResolveCannotParseChar(filters.value);
            status = getDArrayElement(filterStatusArray, filters.status, 'value');
            addDomainNameFilter($('#service_list tr'),domainName,status,filter_type);
        }
    }
    addEnableOrDisenable();
}

function UpdateUrlFilter()
{
    getAjaxData('api/security/url-filter', function($xml) {
            var ret = xml2object($xml);
            if(ret.type == 'response') {
                if(typeof(ret.response.urlfilterpolicy) != 'undefined') {
                    g_black_filters = ret.response.blackurlfilters.urlfilter;
                    g_white_filters = ret.response.whiteurlfilters.urlfilter;
                }
            }
        }, {
            sync: true
        });
}

function onRadioChange() {
    hideAddItemControl();
    $('.user_add_line').remove();
    if($("#blacklist_enable").get(0).checked) {
        g_new_filter_mode = 0;
        showUrlFiters(g_black_filters);
        if($(".show_" + BLACK_URL).size() < URL_FILTER_NUM ) {
            button_enable('add_item', '1');
        }
    } 
    else {
        g_new_filter_mode = 1;
        showUrlFiters(g_white_filters);
        if($(".show_" + WHITE_URL).size() < URL_FILTER_NUM ) {
            button_enable('add_item', '1');
        }
    }
    button_enable('apply', '1');
}

$(document).ready( function() {
    URL_FILTER_NUM = parseInt(g_config_firewall.urlfilter.number,10);
    initPage();
    openPortToCss('service_list');
   // $('.user_options').attr('width','105');
    var currentAllVal = null;
    var editIndex = null;
    var editStatus = null;

    if($('.urlfilter_mode').length > 0) {
        $("#blacklist_enable").click(function(){
            onRadioChange();
        });
        $("#whitelist_enable").click(function(){
            onRadioChange();
        });
    }

    $('.button_edit_list').live('click', function() {
              if($(".add_item_control:hidden").size() > 0 && $("#edit_item_ok").size() < 1
        && ((firewall_status != null && firewall_status.FirewallMainSwitch == 1) && (firewall_status != null && firewall_status.firewallurlfilterswitch == 1))) {
            editIndex = $('.button_edit_list').index(this);
            // save the value before user edit
            currentAllVal = $('.user_add_line').eq(editIndex).html();
            var editDomainNameFilter = $(this).parent().siblings();

            var editDomainName = editDomainNameFilter.eq(0);
            editStatus=editDomainNameFilter.eq(1);

            editDomainName.html('<input type="text" value="' + XSSResolveHtmlReturnChar(editDomainName.html()) + '" id="input_domain_name"  maxlength="63"></td>');
            var htmlStatus = editStatus.html();

            createSelect(editStatus, 'select_status', filterStatusArray);
            $('#select_status').val(getDArrayElement(filterStatusArray, htmlStatus, 'key'));
            $(this).parent().html('<a id="edit_item_ok" class="clr_blue" href="javascript:void(0);">' + common_ok +
            '</a><a id="edit_item_cancel" class="clr_blue" href="javascript:void(0);">' + common_cancel + '</a>');

            hideAddItemControl();
            $('.user_add_line input').eq(0).focus();

            $('#edit_item_cancel').live('click', function() {
                $('.user_add_line').eq(editIndex).html(currentAllVal);
                $('.qtip').qtip('destroy');
                if (!isButtonEnable('add_item')) {
                    button_enable('add_item', '1');
                    $('input[name=radio]').attr('disabled', false);
                    if((1 == ok_flag) || (1 == add_flag)) {
                        button_enable('apply', '1');
                    }
                }
                addEnableOrDisenable();
            });
            button_enable('apply', '0');
            button_enable('add_item', '0');
            $('input[name=radio]').attr('disabled', true);
        }

    });
    $('#edit_item_ok').live('click', function() {
        if (isVaildValue()) {
            var domain_name = $.trim($('#input_domain_name').val());
            var statusOption = $('#select_status option:selected').text();

            hideAddItemControl();
            var editDNFilter = $(this).parent().siblings();

            editDNFilter.eq(0).html(domain_name);
            editDNFilter.eq(1).html(statusOption);

            $(this).parent().html('<span class=\"button_edit_list clr_blue\">' + common_edit +
            '</span><span class=\"button_delete_list clr_blue\">' + common_delete + '</span>');

            // currentAllVal = $('.user_add_line').eq(editIndex).html();
            button_enable('apply', '1');
            button_enable('add_item', '1');
            $('input[name=radio]').attr('disabled', false);
            ok_flag = 1;
            addEnableOrDisenable();
        }
    });
    $('#add_item_ok').live('click', function() {
        if (isVaildValue()) {
            var domain_name = $.trim($('#input_domain_name').val());
            var statusOption = $('#select_status option:selected').text();
            hideAddItemControl();

            if($('.urlfilter_mode').length > 0) {
                if ($("#blacklist_enable").get(0).checked) {
                    addDomainNameFilter($('#service_list tr'),domain_name,statusOption,BLACK_URL);
                }
                else {
                    addDomainNameFilter($('#service_list tr'),domain_name,statusOption,WHITE_URL);
                }
            }
            else {
                addDomainNameFilter($('#service_list tr'),domain_name,statusOption);
            }

            button_enable('apply', '1');
            $('input[name=radio]').attr('disabled', false);
            addEnableOrDisenable();
            add_flag = 1;
        }
        return false;
    });
    //hide add item control
    $('#add_item_cancel').live('click', function() {
        hideAddItemControl();
        $('input[name=radio]').attr('disabled', false);
        if((1 == add_flag) || (1 == ok_flag)) {
            button_enable('apply', '1');
        }
		$('#input_domain_name').val("");
		initSelectOption('select_status', filterStatusArray);
        return false;
    });
    //show add item control
    $('#add_item').click( function() {
        if (isButtonEnable('add_item')) {
            showAddItemControl();
            $('.add_item_control input').eq(0).focus();
            button_enable('apply', '0');
            $('#input_domain_name').removeAttr('disabled');
	    $('input[name=radio]').attr('disabled', true);
        }
		$('#input_domain_name').val("");
		initSelectOption('select_status', filterStatusArray);
    });
    //if there hasn't any add or delete button it won't work
    $(".button_delete_list").live("click", function() {
        if($(".add_item_control:hidden").size() > 0 && $("#edit_item_ok").size() < 1
        && ((firewall_status != null && firewall_status.FirewallMainSwitch == 1) && (firewall_status != null && firewall_status.firewallurlfilterswitch == 1))) {
            var deleteIndex = $(".button_delete_list").index(this);
            call_dialog(common_delete, firewall_hint_delete_list_item, common_ok, "pop_OK", common_cancel, "pop_Cancel");
            $("#pop_OK").click( function() {
                deleteFilter(deleteIndex, $(".user_add_line"));
                clearDialog();
                button_enable("apply", "1");
                button_enable("add_item", "1");
                $('input[name=radio]').attr('disabled', false);
            });
        }
		$('#input_domain_name').val("");
		initSelectOption('select_status', filterStatusArray);
    });
    function postData() {
        var submitObject = {};
        var domain_urlfilter = [];
        var filter = [];
        var submitServerValue = '';
        var submitServerStatus = '';
        var filterMode = '';
        $('.user_add_line').each( function(i) {
            submitServerValue = $(this).children().eq(0).text();
            submitServerStatus = getDArrayElement(filterStatusArray, $(this).children().eq(1).text(), 'key');

            filter = {
                value: submitServerValue,
                status: submitServerStatus
            };
            domain_urlfilter.push(filter);
        });
        if($('.urlfilter_mode').length > 0) {
            filterMode = (g_new_filter_mode == null?  g_filter_mode:g_new_filter_mode);
            submitObject = {
                urlfilterpolicy: filterMode,
                urlfilters: {
                    urlfilter: domain_urlfilter
                }
            };
        }
        else {
            submitObject = {
                urlfilters: {
                    urlfilter: domain_urlfilter
                }
            };        
        }
        var submitData = object2xml('request', submitObject);

        saveAjaxData('api/security/url-filter', submitData, function($xml) {
            var ret = xml2object($xml);
            if (isAjaxReturnOK(ret)) {
                UpdateUrlFilter();
                showInfoDialog(common_success);
                button_enable('apply', '0');
            } else {
                showInfoDialog(common_failed);           
                initPage();
            }
        });
    }

    $('#apply').click( function() {
        if (isButtonEnable('apply')) {
            showConfirmDialog(firewall_hint_submit_list_item, postData);
        }
        ok_flag = 0;
        add_flag = 0;
    });
    initSelectOption('select_status', filterStatusArray);

});


