var g_auto_update = {};
var g_server_update = {};
var g_force_switch;

function apply() {
    if (!isButtonEnable('apply_button')) {
        return;
    }

    if (g_force_switch !== '1') {
    	postWhitelist();
    	return;
    }

    var enable_svrupd = $("[name='serverUpdate']:checked").val();

    postAutoUpdateData(enable_svrupd);
}

function postWhitelist() {
    var autoupdate_userreport = {
        whitelist_enable: 0
    };
    autoupdate_userreport.whitelist_enable = $("[name='usesreport']:checked").val();
    var res = object2xml('request', autoupdate_userreport);
    saveAjaxData('api/user/white_list_switch', res, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            button_enable('apply_button', '0');
            showInfoDialog(common_success);
            log.debug('api/user/white_list_switch success.');
        } else {
            button_enable('apply_button', '1');
            showInfoDialog(common_failed);
            log.debug('api/user/white_list_switch failed.');
        }
        update_settings_refresh();
    }, {
        sync: true
    });
}

function postAutoUpdateData(autoUpdate) {
    g_server_update.server_force_enable = autoUpdate;
    res = object2xml('request', g_server_update);
    saveAjaxData('api/online-update/configuration', res, function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
            button_enable('apply_button', '0');
            postWhitelist();
        } else {
            button_enable('apply_button', '1');
            showInfoDialog(common_failed);
            update_settings_refresh();
        }
    }, {
        sync: true
    });
}

function setAutoStatus(_enable) {
    _enable = 0 == _enable ? 1 : 0;
    $("input[name='usesreport']").get(_enable).checked = true;
}

function getDeviseAutoUpdae() {
    getAjaxData('api/user/white_list_switch', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            $('.auto_update_login :input').removeAttr('disabled');
            if (ret.response.whitelist_enable == '1') { //open auto update
                setAutoStatus(1);
                g_auto_update = 1;
            } else {
                setAutoStatus(0);
                g_auto_update = 0;
            }
        } else {
            $('.auto_update_login :input').attr('disabled', 'disabled');
        }
    }, {
        errorCB: function() {
            $('.auto_update_login :input').attr('disabled', 'disabled');
        },
        sync: true
    });
}

function getServerUpdate() {
    getAjaxData('api/online-update/configuration', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            $('.auto_update_login :input').removeAttr('disabled');
            g_server_update = ret.response;
            if (g_server_update.server_force_enable == '1') { //open server update
                $("input[name='serverUpdate']").get(0).checked = true;
            } else {
                $("input[name='serverUpdate']").get(1).checked = true;
            }
        } else {
            $('.auto_update_login :input').attr('disabled', 'disabled');
        }
    }, {
        errorCB: function() {
            $('.auto_update_login :input').attr('disabled', 'disabled');
        },
        sync: true
    });
}

function update_settings_refresh() {
    getDeviseAutoUpdae();
    if (g_force_switch === '1') {
        getServerUpdate();
    }
}

function getFeatureSwitch() {
    getAjaxData('config/update/config.xml', function($xml) {
        var ret = xml2object($xml);
        g_force_switch = ret.config.force_update_enabled;
        if (g_force_switch === '1') {
            $('#server_update_enable').show();
	    $('#server_update_label').show();
        }
    }, {
        sync: true
    });
}

$(document).ready(function() {
    getFeatureSwitch();
    update_settings_refresh();
    $('#apply_button').click(function() {
        apply();
    });
    button_enable('apply_button', '0');
    $('input').bind('change input paste cut keydown', function() {
        button_enable('apply_button', '1');
    });
});
