var UPDATE_STATUS_IDLE = 10;
var UPDATE_STATUS_QUERYING = 11;
var UPDATE_NEWVERSION_FOUND = 12;
var UPDATE_STATUS_QUERYING_FAILED = 13;
var UPDATE_UP_TO_DATE = 14;
var UPDATE_DOWNLOAD_FAILED = 20;
var UPDATE_DOWNLOAD_PROGRESSING = 30;
var UPDATE_DOWNLOAD_PENDING = 31;
var UPDATE_DOWNLOAD_COMPLETE = 40;
var UPDATE_READYTO_UPDATE = 50;
var UPDATE_PROGRESSING = 60;
var UPDATE_FAILED_HAVEDATA = 70;
var UPDATE_FAILED_NODATA = 80;
var UPDATE_SUCCESSFUL_HAVEDATA = 90;
var UPDATE_SUCCESSFUL_NODATA = 100;
var RELOAD_PAGE_DELAY = 600;
var UPDATE_STATUS_INTERVAL = 1000;
var ONLINE_UPDATE_STATUS_INTERVAL = 10000;
var UPDATE_STATUS_QUICK_INTERVAL = 50;

var BATTERY_LESSTHAN_HALF = '110024';
var g_status = null;
var g_update_value = null;
var g_updateComponent = null;

var g_TB = 1024 * 1024 * 1024 * 1024;
var g_GB = 1024 * 1024 * 1024;
var g_MB = 1024 * 1024;
var g_KB = 1024;

var g_install_processbar_enable = 1;
var g_install_processbar_speed = 1;

var g_install_progress = 0;
var g_install_quick_flag = true;
var g_install_quick_speed = 1;

var g_download_install = true;
var g_install_finshed = false;
var g_progress_interval = null;

var g_updateStatus = 0;
// If we didn't login, we default set force update switch is open.
var g_force_update = true;
var g_force_status = false;

function reloadPage() {
    setTimeout(function() {
        window.location.reload();
    }, RELOAD_PAGE_DELAY);
}

function update_displayNoNewVersionInfo() {

    if (!g_isBridgeNotesOpened) {
        clearDialog();
    }

    $('#up_content').hide();
    $('#up_version').hide();
    $('#up_system').show();
    $('#up_now').hide();
}

function formatComponentSize(bytes_number) {
    if (bytes_number >= g_TB) {
        return formatFloat((parseFloat(bytes_number / (g_TB))), 2) + ' TB';
    }
    if (bytes_number >= g_GB && bytes_number < g_TB) {
        return formatFloat((parseFloat(bytes_number / (g_GB))), 2) + ' GB';
    } else if (bytes_number >= g_MB && bytes_number < g_GB) {
        return formatFloat((parseFloat(bytes_number / (g_MB))), 2) + ' MB';
    } else if (bytes_number >= g_KB && bytes_number < g_MB) {
        return formatFloat((parseFloat(bytes_number / (g_KB))), 2) + ' KB';
    } else if (bytes_number < g_KB) {
        return formatFloat((parseFloat(bytes_number / (1))), 2) + ' B';
    }
}

function update_showDownloading() {
    //show DownloadProgress
    if (g_download_install) {
        var current_progress = g_status.DownloadProgress;
        var persent = formatFloat(parseInt(current_progress, 10) / 100, 2);
        var update_width = $('.graph').width() - 8;
        update_width = parseInt(update_width * persent, 10);
        $('.press').css({
            'width': update_width + 'px'
        });
        $('#downloadProcess').html(current_progress + '%');
        cancelLogoutTimer();
        if (g_updateComponent) {
            // show current component index,name and version
            var downloadProcess = get_label_get + '&nbsp;' + eval(parseInt(g_status.CurrentComponentIndex, 10) + 1) + of_label_of + '&nbsp;' + g_status.TotalComponents + common_colon + '&nbsp;';
            if ($.isArray(g_updateComponent)) {
                downloadProcess += XSSResolveCannotParseChar(g_updateComponent[g_status.CurrentComponentIndex].ComponentName) + '&nbsp;' + formatComponentSize(g_updateComponent[g_status.CurrentComponentIndex].ComponentSize);
            } else {
                downloadProcess += XSSResolveCannotParseChar(g_updateComponent.ComponentName) + '&nbsp;' + formatComponentSize(g_updateComponent.ComponentSize);
            }
            $('#update_download .up_get').html(downloadProcess);
        }

        //show Download dialog
        if ($('#div_wrapper').size() < 1) {
            $('.body_bg').before("<div id='div_wrapper'><iframe   id='ifream_dialog'  src= '' frameborder= '0' style= 'background:#bcbcbc; width:100%; height:100%; display: block;'> </iframe></div>");
        } else {
            $('#div_wrapper').remove();
            $('.body_bg').before("<div id='div_wrapper'><iframe   id='ifream_dialog'  src= '' frameborder= '0' style= 'background:#bcbcbc; width:100%; height:100%; display: block;'> </iframe></div>");
        }
        reputPosition($('#update_download'), $('#div_wrapper'));
        disableTabKey();

        if (current_progress == UPDATE_SUCCESSFUL_NODATA && g_updateStatus == UPDATE_PROGRESSING) {
            g_install_progress = 0;
            g_download_install = false;
            g_install_quick_flag = true;
            $('#update_download .dialog_header_left').html(IDS_update_title_installing);
            $('#update_download .up_get').html(IDS_update_label_installing);
            $('#DownloadProgressing_Cancel').css('display', 'none');
            clearTimeout(g_decive_timer);
            clearTimeout(g_simcard_timer);
            clearTimeout(g_heart_beat_timer);
            show_install_progress();
        }
    }
}

function show_install_progress() {
    if (g_install_progress < 100) {
        if (!(g_updateStatus == UPDATE_SUCCESSFUL_NODATA || g_updateStatus == UPDATE_SUCCESSFUL_HAVEDATA)) {
            g_install_progress += g_install_processbar_speed;
        } else {
            g_install_progress += g_install_quick_speed;
        }

        if (g_updateStatus == UPDATE_PROGRESSING && g_install_progress >= 100) {
            g_install_progress = 99;
        } else if (!(g_updateStatus == UPDATE_SUCCESSFUL_NODATA || g_updateStatus == UPDATE_SUCCESSFUL_HAVEDATA) && g_install_progress >= 100) {
            g_install_progress = 99;
        } else if (g_install_progress > 100) {
            g_install_progress = 100;
        }
    }

    var persent = formatFloat(parseInt(g_install_progress, 10) / 100, 2);
    var update_width = $('.graph').width() - 8;
    update_width = parseInt(update_width * persent, 10);
    $('.press').css({
        'width': update_width + 'px'
    });
    $('#downloadProcess').html(g_install_progress + '%');
    if (g_install_progress < 100) {
        if (g_updateStatus == UPDATE_SUCCESSFUL_NODATA) {
            g_progress_interval = setTimeout(show_install_progress, UPDATE_STATUS_QUICK_INTERVAL);
        } else {
            g_progress_interval = setTimeout(show_install_progress, UPDATE_STATUS_INTERVAL);
        }
        g_install_finshed = false;
    } else {
        //clearTimeout(g_progress_interval);
        g_install_finshed = true;
        setTimeout(update_downloadSuccess, UPDATE_STATUS_INTERVAL);
    }
}

function update_displayNewVersionFoundInfo(isShowDownloading) {
    $('#up_content').hide();
    $('#up_version').show();
    $('#up_system').hide();
    $('#up_now').hide();
    if (g_update_value == null) {
        getAjaxData('api/online-update/url-list', function($xml) {
            var update_ret = xml2object($xml);
            if (update_ret.type == 'response') {
                g_update_value = update_ret.response;
                g_updateComponent = g_update_value.ComponentList.Component;
                g_force_status = (g_update_value.forced_update_status === '1');
                if (g_updateComponent) {
                    var list_info = '';
                    var changeLog = IDS_update_label_features + common_colon;
                    if ($.isArray(g_updateComponent)) {
                        $.each(g_updateComponent, function(i) {
                            list_info += "<tr><td width='100'>" + XSSResolveCannotParseChar(g_updateComponent[i].ComponentName) + common_colon + "</td><td><label class='up_newversion'>" + XSSResolveCannotParseChar(g_updateComponent[i].Version) + '</label></td></tr>' +
                                '<tr><td >' + sd_label_size + common_colon + "</td><td class = 'up_size'><label class='up_release'>" + formatComponentSize(g_updateComponent[i].ComponentSize) + '</label></td></tr>';
                        });
                    } else {
                        list_info += "<tr><td width='100'>" + XSSResolveCannotParseChar(g_updateComponent.ComponentName) + common_colon + "</td><td><label class='up_newversion'>" + XSSResolveCannotParseChar(g_updateComponent.Version) + '</label></td></tr>' +
                            '<tr><td >' + sd_label_size + common_colon + "</td><td class = 'up_size'><label class='up_release'>" + formatComponentSize(g_updateComponent.ComponentSize) + '</label></td></tr>';
                    }
                    var useDefault = true;
                    $($xml.find('language')).each(function() {
                        if ($(this).attr('name') == LANGUAGE_DATA.current_language.replace(/_/, '-')) {
                            useDefault = false;
                            $($(this).find('features').find('feature')).each(function() {
                                changeLog += '\n' + $(this).text();
                            });
                        }
                    });
                    $($xml.find('language')).each(function() {
                        if (useDefault) {
                            var defaultLanguage = $xml.find('default-language').attr('name');
                            if ($(this).attr('name') == defaultLanguage) {
                                $($(this).find('features').find('feature')).each(function() {
                                    changeLog += '\n' + $(this).text();
                                });
                            }
                        }
                    });
                    $('.cancel_table').html(list_info);
                    $('.update_textarea').val(changeLog);

                    if (isShowDownloading) {
                        update_showDownloading();
                    }
                }
            }
        });
    }
    //only click the Update Now button
    else {
        update_showDownloading();
    }
}

function update_downloadSuccess() {
    if (g_updateStatus == UPDATE_SUCCESSFUL_NODATA || g_updateStatus == UPDATE_SUCCESSFUL_HAVEDATA) {
        if (!g_install_processbar_enable || (g_install_processbar_enable && g_install_finshed)) {
            $('.update_dialog').hide();
            reputPosition($('#upload_success'), $('#div_wrapper'));
        }
    }
}

function update_clickSuccessCancel() {
    var dialogLeft = $(window).width() / 2 - $('.update_dialog').outerWidth() / 2;
    $('#success_ok').live('click', function() {
        $('#upload_success,#div_wrapper').hide();
        reloadPage();
    });
}

function update_failed() {
    $('.update_dialog').hide();
    reputPosition($('#update_failed'), $('#div_wrapper'));
}

function update_battery_low() {
    $('.update_dialog').hide();
    reputPosition($('#update_battery_low'), $('#div_wrapper'));
}

function update_checkUpdateStatus() {
    getAjaxData('api/online-update/status', function($xml) {
        var update_ret = xml2object($xml);
        if (update_ret.type == 'response') {
            g_status = update_ret.response;
            g_updateStatus = parseInt(g_status.CurrentComponentStatus, 10);
            g_dlStatus = parseInt(g_status.DownloadProgress, 10);
            update_processStatus(g_updateStatus, g_dlStatus);
        }
    }, {
        errorCB: function() {
            setTimeout(update_checkUpdateStatus, ONLINE_UPDATE_STATUS_INTERVAL);
        }
    });
}

function getServerUpdate() {
    getAjaxData('api/online-update/configuration', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            g_force_update = (ret.response.server_force_enable === '1');
            return;
        }
    }, {
        sync: true
    });
}

function update_processStatus(CurrentComponentStatus, dlStatus) {
    $('#online_update h2').show();
    if (CurrentComponentStatus == UPDATE_DOWNLOAD_PROGRESSING && parseInt(g_status.DownloadProgress, 10) > 0 && !(g_force_status && g_force_update)) {
        button_enable('DownloadProgressing_Cancel', '1');
    } else {
        button_enable('DownloadProgressing_Cancel', '0');
    }
    switch (CurrentComponentStatus) {
        //The content in log debug is just for test, it can be ignored.
        case UPDATE_STATUS_IDLE:
            log.debug('online-update : update_processStatus(UPDATE_STATUS_IDLE)');
            $('#online_update').show();
            //$('#uploadLocalFile').hide();
            $('#up_system').html('');
            $('#online_update h2').hide();
            update_displayNoNewVersionInfo(); //Told user there hasn't new version.
            return;
        case UPDATE_STATUS_QUERYING:
            log.debug('online-update : update_processStatus(UPDATE_STATUS_QUERYING)');
            break;
        case UPDATE_NEWVERSION_FOUND:
            log.debug('online-update : update_processStatus(UPDATE_NEWVERSION_FOUND)');
            $('#update_download').hide('fast');
            $('#div_wrapper').hide('fast');
            if ($('#up_version').is(':hidden')) {
                g_update_value = null;
                update_displayNewVersionFoundInfo(); //show dialog new feature
            }
            return;
        case UPDATE_STATUS_QUERYING_FAILED:
            log.debug('online-update : update_processStatus(UPDATE_STATUS_QUERYING_FAILED)');
            update_displayNoNewVersionInfo();
            return;
        case UPDATE_UP_TO_DATE:
            log.debug('online-update : update_processStatus(UPDATE_UP_TO_DATE)');
            if (100 === dlStatus) {
                $('#update_download').hide();
                $('#div_wrapper').hide();
                $("#up_currentVersion").hide();
                $('#up_content').hide();
                $('#up_version').hide();
                $('#up_system').hide();
                $('#up_now').show();
                return;
            }

            $('#up_system').html(IDS_update_latest_version);
            $('#online_update h2').hide();
            update_displayNoNewVersionInfo(); //Told user there hasn't new version.
            return;
        case UPDATE_DOWNLOAD_FAILED:
            if (g_status.updatebatterystatus == '1') {
                log.debug('online-update : update_processStatus(UPDATE_BATTERY_LOW)');
                update_battery_low();
            } else {
                log.debug('online-update : update_processStatus(UPDATE_DOWNLOAD_FAILED)');
                update_failed();
            }
            startLogoutTimer();
            return;
        case UPDATE_DOWNLOAD_PROGRESSING:
            log.debug('online-update : update_processStatus(UPDATE_DOWNLOAD_PROGRESSING');
            update_displayNewVersionFoundInfo(true);
            break;
        case UPDATE_DOWNLOAD_PENDING:
            log.debug('online-update : update_processStatus(UPDATE_DOWNLOAD_PENDING)');
            update_displayNewVersionFoundInfo();
            return;
        case UPDATE_DOWNLOAD_COMPLETE:
            log.debug('online-update : update_processStatus(UPDATE_DOWNLOAD_COMPLETE)');
            break;
        case UPDATE_READYTO_UPDATE:
            log.debug('online-update : update_processStatus(UPDATE_READYTO_UPDATE)');
            break;
        case UPDATE_PROGRESSING:
            log.debug('online-update : update_processStatus(UPDATE_PROGRESSING)');
            update_displayNewVersionFoundInfo();
            break;
        case UPDATE_FAILED_HAVEDATA:
            log.debug('online-update : update_processStatus(UPDATE_FAILED_HAVEDATA)');
            update_failed();
            startLogoutTimer();
            return;
        case UPDATE_FAILED_NODATA:
            log.debug('online-update : update_processStatus(UPDATE_FAILED_NODATA)');
            update_failed();
            startLogoutTimer();
            return;
        case UPDATE_SUCCESSFUL_HAVEDATA:
            log.debug('online-update : update_processStatus(UPDATE_SUCCESSFUL_HAVEDATA)');
            update_downloadSuccess();
            update_clickSuccessCancel();
            startLogoutTimer();
            return;
        case UPDATE_SUCCESSFUL_NODATA:
            log.debug('online-update : update_processStatus(UPDATE_SUCCESSFUL_NODATA)');
            update_downloadSuccess();
            update_clickSuccessCancel();
            startLogoutTimer();
            return;
        default:
            break;
    }
    setTimeout(update_checkUpdateStatus, UPDATE_STATUS_INTERVAL);

}

function update_checkNewVersion() {
    $("#up_currentVersion").hide();
    $('#up_content').show();
    $('#up_version').hide();
    $('#up_system').hide();
    $('#up_now').hide();
    saveAjaxData('api/online-update/check-new-version', '', function($xml) {
        update_checkUpdateStatus();
        var return_ret = xml2object($xml);
        if (isAjaxReturnOK(return_ret)) {
            log.debug('online-update : send check-new-version success.');
        }
    });
}

function update_onClickInstallNow() {
    var updateStatus = parseInt(G_NotificationsStatus.OnlineUpdateStatus, 10);
    if (updateStatus != UPDATE_DOWNLOAD_PROGRESSING && updateStatus != UPDATE_PROGRESSING) {
        clearAllErrorLabel();
        $('#install_now').unbind('click');
        var submitData = {
            UserAckUpdate: 0
        };
        var res = object2xml('request', submitData);
        saveAjaxData('api/online-update/ack-readytoupdate', res, function($xml) {
            var update_ret = xml2object($xml);
            if (update_ret.type == 'response') {
                update_checkUpdateStatus();
                g_download_install = true;
            } else if (update_ret.type == 'error') {
                if (update_ret.error.code == BATTERY_LESSTHAN_HALF) {
                    showInfoDialog(STRID_update_hint_battery_prower_low);
                }
            }
        });
    } else {
        showInfoDialog(IDS_update_updateing_try_again);
    }
}

function update_onClickUpdateNow() {
    var updateStatus = parseInt(G_NotificationsStatus.OnlineUpdateStatus, 10);
    if (updateStatus != UPDATE_DOWNLOAD_PROGRESSING && updateStatus != UPDATE_PROGRESSING) {
        clearAllErrorLabel();
        $('#update_now').unbind('click');
        var submitData = {
            userAckNewVersion: 0
        };
        var res = object2xml('request', submitData);
        saveAjaxData('api/online-update/ack-newversion', res, function($xml) {
            var update_ret = xml2object($xml);
            if (update_ret.type == 'response') {
                log.debug('update data successfull');
                update_checkUpdateStatus();
                g_download_install = true;
            } else if (update_ret.type == 'error') {
                if (update_ret.error.code == BATTERY_LESSTHAN_HALF) {
                    if (g_coulometer_status == '1') {
                        log.debug('the battery less than 20%');
                    } else {
                        log.debug('the battery less than 50%');
                    }
                    showInfoDialog(STRID_update_hint_battery_prower_low);
                    return;
                }
            }
        });
    } else {
        clearAllErrorLabel();
        showErrorUnderTextbox('update_now', IDS_update_updateing_try_again);
    }
}

function update_okDownloading() {
    if (isButtonEnable('DownloadProgressing_Cancel')) {
        $('#update_download,#div_wrapper').hide();
        saveAjaxData('api/online-update/cancel-downloading', '', function($xml) {
            var return_ret = xml2object($xml);
            if (return_ret.type == 'response') {
                log.debug('update data successfull');
            }
        }, {
            sync: true
        });
        saveAjaxData('api/online-update/check-new-version', '', function($xml) {
            var return_ret = xml2object($xml);
            if (isAjaxReturnOK(return_ret)) {
                log.debug('online-update : send check-new-version success.');
            }
        }, {
            sync: true
        });
        reloadPage();
    }
}

function getUpdateConfig() {
    getConfigData('config/webuicfg/config.xml', function($xml) {
        var update_config = _xml2feature($xml);
        g_install_processbar_enable = update_config.install_processbar_enable;
        g_install_processbar_speed = update_config.install_processbar_speed;

    }, {
        sync: true
    });

}

function createCanvas(id, idcanvas) {
    var div = $('#' + id + ' span:eq(1) a');
    if ($.browser.msie && (parseInt($.browser.version, 10) < 9)) {
        $(".dialog_header_left").css("margin-top", "5");
        $(".dialog_header_right").css("margin-top", "5");
        $(".dialog_header").css({
            "width": "500px",
            "height": "29px"
        });
        $(".dialog_header").corner("top 5px");
        $(".dialog_table_bottom").corner("keep round br bl 3px cc:6a6a6a");
        var ahtml = "<img src='../res/dialog_close_btn.png' title='' alt='' />";
        div.append(ahtml);
        div.css("margin-top", "-12px");
    } else {
        var svg = "<canvas id='" + idcanvas + "' width='25px' height='25px'></canvas>";
        div.append(svg);
        var canvas = document.getElementById(idcanvas);
        draw(canvas);
    }
}


function update_executeBeforeDocumentReady() {
    getAjaxData('api/monitoring/status', function($xml) {
        log.debug('MAIN : getDeviceStatus() get monitoring success');
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            G_MonitoringStatus = ret;
        }
    }, {
        sync: true
    });

    if (g_module.cradle_enabled) {
        getAjaxData('api/cradle/status-info', function($xml) {
            var ret = xml2object($xml);
            if (ret.type == 'response') {
                G_cradleStationStatus = ret.response;
            }
        }, {
            sync: true
        });

    }
    if (WIFI_CONNECTED == G_MonitoringStatus.response.WifiConnectionStatus ||
        (g_module.cradle_enabled && CRADLE_NETLINE_EXIST == G_cradleStationStatus.cradlestatus &&
            G_cradleStationStatus.connectionmode != ETHERNET_LAN_MODE &&
            (G_cradleStationStatus.connectstatus != MACRO_CRADLE_CONNECTSTATUSNULL &&
                G_cradleStationStatus.connectstatus != MACRO_CRANDLE_CONNECTSTATUSERRO)) ||
        !(redirectOnCondition(null, 'update'))) {
        if (g_needToLogin == '1' && !g_auto_update) {
            checklogin();
            //getLoginStatus();
        }
    }
    getUpdateConfig();
}

update_executeBeforeDocumentReady();

function initPage() {
    getAjaxData('api/device/information', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            if (ret.response.SoftwareVersion != '' && typeof(ret.response.SoftwareVersion) != 'undefined') {
                $(".software_version").text(ret.response.SoftwareVersion);
            } else {
                $(".software_version").text(common_unknown);
            }
            if (ret.response.WebUIVersion != '' && typeof(ret.response.WebUIVersion) != 'undefined') {
                $(".ui_version").text(ret.response.WebUIVersion);
            } else {
                $(".ui_version").text(common_unknown);
            }
        }
    });
}

function autoUpdateInitPage() {
    getAjaxData('api/device/basic_information', function($xml) {
        var ret = xml2object($xml);
        if (ret.type !== 'response') {
            return;
        }
        if (ret.response.SoftwareVersion) {
            $(".software_version").text(ret.response.SoftwareVersion);
        } else {
            $(".software_version").text(common_unknown);
        }
        if (ret.response.WebUIVersion) {
            $(".ui_version").text(ret.response.WebUIVersion);
        } else {
            $(".ui_version").text(common_unknown);
        }
    });
}

function update_checkAutoUpdateStatus() {
    getAjaxData('api/online-update/status', function($xml) {
        var update_ret = xml2object($xml);
        var autoUpdateStatus = null;
        if (update_ret.type !== 'response') {
            $("#up_currentVersion").show();
            return;
        }
        autoUpdateStatus = parseInt(update_ret.response.CurrentComponentStatus, 10);
        if (30 == autoUpdateStatus || 31 == autoUpdateStatus || 40 == autoUpdateStatus || 50 == autoUpdateStatus || 60 == autoUpdateStatus) {
            $("#up_currentVersion").hide();
            $('#up_content').show();
            $('#up_version').hide();
            $('#up_system').hide();
            $('#up_now').hide();
            update_checkUpdateStatus();
            g_download_install = true;
        } else {
            $("#up_currentVersion").show();
        }
    }, {
        sync: true
    });
}

function checkNewVersionShowUpdate() {
    if (g_auto_update) {
        autoUpdateInitPage();
        update_checkAutoUpdateStatus();
    } else {
        initPage();
        $("#up_currentVersion").show();
    }
}

/**********************************After loaded (common)************/
$(document).ready(function() {
    getServerUpdate();
    checkNewVersionShowUpdate();
    $("#up_currentVersion").hide();
    initPage();
    update_checkNewVersion();
    $('#check_now').live('click', function() {
        if (!isButtonEnable("check_now")) {
            return;
        }
        update_checkNewVersion();
    });
    $('#update_now').live('click', function() {
        if (!isButtonEnable("update_now")) {
            return;
        }
        update_onClickUpdateNow();
    });
    $('#install_now').live('click', function() {
        if (!isButtonEnable("install_now")) {
            return;
        }
        update_onClickInstallNow();
    });
    $('#DownloadProgressing_Cancel, #cancel_download').bind('click', update_okDownloading);
    $('#query_again').bind('click', function() {
        update_checkNewVersion();
    });
    $('.dialog_close_btn, .pop_Cancel').live('click', function() {
        reloadPage();
    });
    if (g_coulometer_status == '-1') {
        getAjaxData('api/device/device-feature-switch', function($xml) {
            var coulometer_ret = xml2object($xml);
            if (coulometer_ret.type == 'response') {
                g_coulometer_status = coulometer_ret.response.coulometer_enabled;
            }
        }, {
            sync: true
        });
    }
    IDS_update_battery_low_warning = coulometerCheck(IDS_update_battery_low_warning);
    STRID_update_hint_battery_prower_low = coulometerCheck(STRID_update_hint_battery_prower_low);
    $('#battery_low_replace').text(IDS_update_battery_low_warning);
});
